/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import antlr.RecognitionException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.QuerySyntaxException;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.exec.AbstractStatementExecutor;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;

public class BasicExecutor
extends AbstractStatementExecutor {
    private static final Log log = LogFactory.getLog((Class)BasicExecutor.class);
    private final Queryable persister;
    private final String sql;

    public BasicExecutor(HqlSqlWalker walker, Queryable persister) {
        super(walker, log);
        this.persister = persister;
        try {
            SqlGenerator gen = new SqlGenerator(this.getFactory());
            gen.statement(walker.getAST());
            this.sql = gen.getSQL();
            gen.getParseErrorHandler().throwQueryException();
        }
        catch (RecognitionException e) {
            throw new QuerySyntaxException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int execute(QueryParameters parameters, SessionImplementor session) throws HibernateException {
        this.coordinateSharedCacheCleanup(session);
        PreparedStatement st = null;
        RowSelection selection = parameters.getRowSelection();
        try {
            int n;
            block7: {
                try {
                    st = session.getBatcher().prepareStatement(this.sql);
                    Iterator paramSpecifications = this.getWalker().getParameters().iterator();
                    int pos = 1;
                    while (paramSpecifications.hasNext()) {
                        ParameterSpecification paramSpec = (ParameterSpecification)paramSpecifications.next();
                        pos += paramSpec.bind(st, parameters, session, pos);
                    }
                    if (selection != null && selection.getTimeout() != null) {
                        st.setQueryTimeout(selection.getTimeout());
                    }
                    n = st.executeUpdate();
                    Object var9_10 = null;
                    if (st == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (st != null) {
                        session.getBatcher().closeStatement(st);
                    }
                    throw throwable;
                }
                session.getBatcher().closeStatement(st);
            }
            return n;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not execute update query", this.sql);
        }
    }

    protected Queryable[] getAffectedQueryables() {
        return new Queryable[]{this.persister};
    }
}

