/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.message;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Constants;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.description.ParameterDesc;
import org.jboss.axis.description.ServiceDesc;
import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.encoding.SerializationContext;
import org.jboss.axis.enums.Style;
import org.jboss.axis.enums.Use;
import org.jboss.axis.handlers.soap.SOAPService;
import org.jboss.axis.message.EnvelopeHandler;
import org.jboss.axis.message.RPCHandler;
import org.jboss.axis.message.RPCParam;
import org.jboss.axis.message.RPCParamElementImpl;
import org.jboss.axis.message.SOAPBodyElementAxisImpl;
import org.jboss.axis.message.SOAPElementAxisImpl;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.axis.wsdl.toJava.Utils;
import org.jboss.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RPCElement
extends SOAPBodyElementAxisImpl {
    private static Logger log = Logger.getLogger((String)RPCElement.class.getName());
    protected Vector params = new Vector();
    protected boolean needDeser = false;
    OperationDesc[] operations = null;

    public RPCElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context, OperationDesc[] operations) throws AxisFault {
        super(namespace, localName, prefix, attributes, context);
        SOAPService service;
        this.needDeser = true;
        MessageContext msgContext = context.getMessageContext();
        if (operations == null && msgContext != null && (service = msgContext.getService()) != null) {
            ServiceDesc serviceDesc = service.getInitializedServiceDesc(msgContext);
            String lc = Utils.xmlNameToJava(this.name);
            if (serviceDesc == null) {
                AxisFault.makeFault(new ClassNotFoundException(Messages.getMessage("noClassForService00", lc)));
            }
            operations = serviceDesc.getOperationsByName(lc);
        }
        this.operations = operations;
    }

    public RPCElement(String namespace, String methodName, Object[] args) {
        super(namespace, methodName);
        this.setNamespaceURI(namespace);
        this.name = methodName;
        for (int i = 0; args != null && i < args.length; ++i) {
            RPCParam rpcParam = null;
            if (args[i] instanceof RPCParam) {
                rpcParam = (RPCParam)args[i];
            } else {
                String name = null;
                if (name == null) {
                    name = "arg" + i;
                }
                rpcParam = new RPCParam(namespace, name, args[i]);
            }
            this.addParam(rpcParam);
            try {
                this.addChildElement(new RPCParamElementImpl(rpcParam));
                continue;
            }
            catch (SOAPException e) {
                log.error((Object)"Cannot ass rpc param child element", (Throwable)e);
            }
        }
    }

    public RPCElement(String methodName) {
        super(methodName);
        this.name = methodName;
    }

    public String getMethodName() {
        return this.name;
    }

    public void setNeedDeser(boolean needDeser) {
        this.needDeser = needDeser;
    }

    public void deserialize() throws SAXException {
        this.needDeser = false;
        MessageContext msgContext = this.context.getMessageContext();
        Message msg = msgContext.getCurrentMessage();
        SOAPConstants soapConstants = msgContext.getSOAPConstants();
        boolean isResponse = msg != null && "response".equals(msg.getMessageType());
        RPCHandler rpcHandler = new RPCHandler(this, isResponse);
        if (this.operations != null) {
            int numParams = this.getChildren().size();
            SAXException savedException = null;
            boolean acceptMissingParams = msgContext.isPropertyTrue("acceptMissingParams", true);
            for (int i = 0; i < this.operations.length; ++i) {
                OperationDesc operation = this.operations[i];
                boolean needHeaderProcessing = this.needHeaderProcessing(operation, isResponse);
                if (operation.getStyle() != Style.DOCUMENT && operation.getStyle() != Style.WRAPPED && operation.getUse() != Use.LITERAL && !(acceptMissingParams ? operation.getNumInParams() >= numParams : operation.getNumInParams() == numParams)) continue;
                boolean isEncoded = operation.getUse() == Use.ENCODED;
                rpcHandler.setOperation(operation);
                try {
                    if (operation.getStyle() == Style.DOCUMENT && operation.getNumInParams() > 0) {
                        this.context.pushElementHandler(rpcHandler);
                        this.context.setCurElement(null);
                    } else {
                        this.context.pushElementHandler(new EnvelopeHandler(rpcHandler));
                        this.context.setCurElement(this);
                    }
                    this.publishToHandler((ContentHandler)((Object)this.context));
                    if (needHeaderProcessing) {
                        this.processHeaders(operation, isResponse, this.context, rpcHandler);
                    }
                    boolean match = true;
                    for (int j = 0; j < this.params.size() && match; ++j) {
                        Class sigType;
                        RPCParam rpcParam = (RPCParam)this.params.get(j);
                        Object value = rpcParam.getValue();
                        ParameterDesc paramDesc = rpcParam.getParamDesc();
                        if (paramDesc == null || paramDesc.getJavaType() == null || JavaUtils.isConvertable(value, sigType = paramDesc.getJavaType(), !isEncoded)) continue;
                        match = false;
                    }
                    if (match) {
                        msgContext.setOperation(operation);
                        return;
                    }
                    this.params = new Vector();
                    continue;
                }
                catch (SAXException e) {
                    savedException = e;
                    this.params = new Vector();
                    continue;
                }
                catch (AxisFault e) {
                    savedException = new SAXException(e);
                    this.params = new Vector();
                }
            }
            if (!msgContext.isClient() && soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                AxisFault fault = new AxisFault(Constants.FAULT_SOAP12_SENDER, "string", null, null);
                fault.addFaultSubCode(Constants.FAULT_SUBCODE_BADARGS);
                throw new SAXException(fault);
            }
            if (savedException != null) {
                throw savedException;
            }
            if (!msgContext.isClient()) {
                QName faultCode = new QName("Client");
                if (soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    faultCode = Constants.FAULT_SOAP12_SENDER;
                }
                AxisFault fault = new AxisFault(faultCode, null, Messages.getMessage("noSuchOperation", this.name), null, null, null);
                throw new SAXException(fault);
            }
        }
        if (this.operations != null) {
            rpcHandler.setOperation(this.operations[0]);
        }
        if (this.operations != null && this.operations.length > 0 && this.operations[0].getStyle() == Style.DOCUMENT) {
            this.context.pushElementHandler(rpcHandler);
            this.context.setCurElement(null);
        } else {
            this.context.pushElementHandler(new EnvelopeHandler(rpcHandler));
            this.context.setCurElement(this);
        }
        this.publishToHandler((ContentHandler)((Object)this.context));
    }

    public RPCParam getParam(String name) throws SAXException {
        if (this.needDeser) {
            this.deserialize();
        }
        for (int i = 0; i < this.params.size(); ++i) {
            RPCParam param = (RPCParam)this.params.elementAt(i);
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public Vector getParams() throws SAXException {
        if (this.needDeser) {
            this.deserialize();
        }
        return this.params;
    }

    public void addParam(RPCParam param) {
        param.setRPCCall(this);
        this.params.addElement(param);
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        boolean noParams;
        boolean hasOperationElement = true;
        MessageContext msgContext = context.getMessageContext();
        if (msgContext != null) {
            hasOperationElement = msgContext.getOperationStyle() == Style.RPC || msgContext.getOperationStyle() == Style.WRAPPED;
        }
        boolean bl = noParams = this.params.size() == 0;
        if (this.needDeser && context.getCurrentMessage() != null) {
            boolean bl2 = noParams = this.getParams().size() == 0;
        }
        if (hasOperationElement || noParams) {
            if (this.encodingStyle != null && this.encodingStyle.equals("")) {
                context.registerPrefixForURI("", this.getNamespaceURI());
            }
            context.startElement(new QName(this.getNamespaceURI(), this.name), this.attributes);
        }
        for (int i = 0; i < this.params.size(); ++i) {
            RPCParam param = (RPCParam)this.params.elementAt(i);
            if (!hasOperationElement && this.encodingStyle != null && this.encodingStyle.equals("")) {
                String uri = param.getQName().getNamespaceURI();
                String prefix = context.getPrefixForURI(uri);
                context.registerPrefixForURI(prefix, uri);
            }
            param.serialize(context);
        }
        if (hasOperationElement || noParams) {
            context.endElement();
        }
    }

    private boolean needHeaderProcessing(OperationDesc operation, boolean isResponse) {
        ArrayList paramDescs = operation.getParameters();
        if (paramDescs != null) {
            for (int j = 0; j < paramDescs.size(); ++j) {
                ParameterDesc paramDesc = (ParameterDesc)paramDescs.get(j);
                if ((isResponse || !paramDesc.isInHeader()) && (!isResponse || !paramDesc.isOutHeader())) continue;
                return true;
            }
        }
        return isResponse && operation.getReturnParamDesc() != null && operation.getReturnParamDesc().isOutHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHeaders(OperationDesc operation, boolean isResponse, DeserializationContext context, RPCHandler handler) throws AxisFault, SAXException {
        try {
            SOAPElement envelope;
            handler.setHeaderElement(true);
            for (envelope = this.getParentElement(); envelope != null && !(envelope instanceof SOAPEnvelopeAxisImpl); envelope = envelope.getParentElement()) {
            }
            if (envelope == null) {
                return;
            }
            ArrayList paramDescs = operation.getParameters();
            if (paramDescs != null) {
                for (int j = 0; j < paramDescs.size(); ++j) {
                    ParameterDesc paramDesc = (ParameterDesc)paramDescs.get(j);
                    if ((isResponse || !paramDesc.isInHeader()) && (!isResponse || !paramDesc.isOutHeader())) continue;
                    Enumeration headers = ((SOAPEnvelopeAxisImpl)envelope).getHeadersByName(paramDesc.getQName().getNamespaceURI(), paramDesc.getQName().getLocalPart(), true);
                    while (headers != null && headers.hasMoreElements()) {
                        context.pushElementHandler(handler);
                        context.setCurElement(null);
                        ((SOAPElementAxisImpl)headers.nextElement()).publishToHandler((ContentHandler)((Object)context));
                    }
                }
            }
            if (isResponse && operation.getReturnParamDesc() != null && operation.getReturnParamDesc().isOutHeader()) {
                ParameterDesc paramDesc = operation.getReturnParamDesc();
                Enumeration headers = ((SOAPEnvelopeAxisImpl)envelope).getHeadersByName(paramDesc.getQName().getNamespaceURI(), paramDesc.getQName().getLocalPart(), true);
                while (headers != null && headers.hasMoreElements()) {
                    context.pushElementHandler(handler);
                    context.setCurElement(null);
                    ((SOAPElementAxisImpl)headers.nextElement()).publishToHandler((ContentHandler)((Object)context));
                }
            }
        }
        finally {
            handler.setHeaderElement(false);
        }
    }
}

