/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.navtree;

import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jboss.console.navtree.NodeWrapper;
import org.jboss.console.navtree.TreeContext;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    protected TreeContext ctx = null;
    protected static HashMap cache = new HashMap();

    public TreeCellRenderer(TreeContext ctx) {
        this.ctx = ctx;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof NodeWrapper) {
            NodeWrapper node = (NodeWrapper)value;
            String targetUrl = node.getIconUrl();
            ImageIcon img = (ImageIcon)cache.get(targetUrl);
            if (img != null) {
                this.setIcon(img);
            } else {
                URL target = null;
                try {
                    target = new URL(this.ctx.localizeUrl(targetUrl));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                if (target != null) {
                    try {
                        img = new ImageIcon(target);
                        cache.put(targetUrl, img);
                        this.setIcon(img);
                    }
                    catch (Exception tobad) {
                        // empty catch block
                    }
                }
            }
            String desc = node.getDescription();
            if (desc != null) {
                this.setToolTipText(desc);
            }
        }
        return this;
    }

    public TreeCellRenderer() {
    }
}

