/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.encoding.ser;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.jboss.axis.NotImplementedException;
import org.jboss.axis.encoding.SerializationContext;
import org.jboss.axis.encoding.Serializer;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.axis.wsdl.fromJava.Types;
import org.jboss.logging.Logger;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class ListSerializer
implements Serializer {
    private static Logger log = Logger.getLogger((String)ListSerializer.class.getName());
    private Class javaType;
    private QName xmlType;

    public ListSerializer(Class javaType, QName xmlType) {
        this.javaType = javaType;
        this.xmlType = xmlType;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        if (value == null || !JavaUtils.isArrayClass(value.getClass())) {
            throw new IllegalStateException("Cannot use this serializer with: " + value);
        }
        Object[] itemArr = (Object[])value;
        context.startElement(name, attributes);
        for (int i = 0; i < itemArr.length; ++i) {
            String strValue = this.getValueAsString(itemArr[i]);
            if (i > 0) {
                strValue = " " + strValue;
            }
            context.serialize(null, null, strValue);
        }
        context.endElement();
    }

    private String getValueAsString(Object item) {
        return item.toString();
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        throw new NotImplementedException();
    }
}

