/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.encoding.ser;

import java.lang.reflect.Constructor;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.Deserializer;
import org.jboss.axis.encoding.ser.BaseDeserializerFactory;
import org.jboss.axis.encoding.ser.SimpleDeserializer;
import org.jboss.axis.utils.JavaUtils;

public class SimpleDeserializerFactory
extends BaseDeserializerFactory {
    private Constructor constructor = null;

    public SimpleDeserializerFactory(Class javaType, QName xmlType) {
        super(SimpleDeserializer.class, xmlType, javaType);
        try {
            if (!javaType.isPrimitive()) {
                this.constructor = javaType.getDeclaredConstructor(String.class);
            } else {
                Class wrapper = JavaUtils.getWrapperClass(javaType);
                if (wrapper != null) {
                    this.constructor = wrapper.getDeclaredConstructor(String.class);
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public Deserializer getDeserializerAs(String mechanismType) throws JAXRPCException {
        if (this.javaType == Object.class) {
            return null;
        }
        SimpleDeserializer deser = (SimpleDeserializer)super.getDeserializerAs(mechanismType);
        if (deser != null) {
            deser.setConstructor(this.constructor);
        }
        return deser;
    }
}

