/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.xml.rpc.holders.BooleanHolder;
import org.jboss.axis.wsdl.symbolTable.BindingEntry;
import org.jboss.axis.wsdl.symbolTable.Parameter;
import org.jboss.axis.wsdl.symbolTable.Parameters;
import org.jboss.axis.wsdl.symbolTable.SymbolTable;
import org.jboss.axis.wsdl.symbolTable.TypeEntry;
import org.jboss.axis.wsdl.toJava.Emitter;
import org.jboss.axis.wsdl.toJava.JavaBindingWriter;
import org.jboss.axis.wsdl.toJava.JavaClassWriter;
import org.jboss.axis.wsdl.toJava.Utils;

public class JavaImplWriter
extends JavaClassWriter {
    protected Binding binding;
    protected SymbolTable symbolTable;
    protected BindingEntry bEntry;

    protected JavaImplWriter(Emitter emitter, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, bEntry.getName() + "Impl", "templateImpl");
        this.binding = bEntry.getBinding();
        this.symbolTable = symbolTable;
        this.bEntry = bEntry;
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        List operations = this.binding.getBindingOperations();
        for (int i = 0; i < operations.size(); ++i) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            Operation ptOperation = operation.getOperation();
            OperationType type = ptOperation.getStyle();
            Parameters parameters = this.bEntry.getParameters(operation.getOperation());
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                pw.println(parameters.signature);
                pw.println();
                continue;
            }
            this.writeOperation(pw, parameters);
        }
    }

    protected String getImplementsText() {
        String portTypeName = (String)this.bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME);
        String implementsText = "implements " + portTypeName;
        return implementsText;
    }

    protected void writeOperation(PrintWriter pw, Parameters parms) throws IOException {
        pw.println(parms.signature + " {");
        Iterator iparam = parms.list.iterator();
        while (iparam.hasNext()) {
            Parameter param = (Parameter)iparam.next();
            if (param.getMode() != 2) continue;
            BooleanHolder bThrow = new BooleanHolder(false);
            String constructorString = Utils.getConstructorForParam(param, this.symbolTable, bThrow);
            if (bThrow.value) {
                pw.println("        try {");
            }
            pw.println("        " + Utils.xmlNameToJava(param.getName()) + ".value = " + constructorString + ";");
            if (!bThrow.value) continue;
            pw.println("        } catch (Exception e) {");
            pw.println("        }");
        }
        if (parms.returnParam != null) {
            TypeEntry returnType = parms.returnParam.getType();
            pw.print("        return ");
            if (Utils.isPrimitiveType(returnType)) {
                String returnString = returnType.getName();
                if ("boolean".equals(returnString)) {
                    pw.println("false;");
                } else if ("byte".equals(returnString)) {
                    pw.println("(byte)-3;");
                } else if ("short".equals(returnString)) {
                    pw.println("(short)-3;");
                } else {
                    pw.println("-3;");
                }
            } else {
                pw.println("null;");
            }
        }
        pw.println("    }");
        pw.println();
    }
}

