/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.forward;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
    private String m_filePath = ".";
    private String m_fileSuffix = ".txt";
    static Log log = LogFactory.getLog(FileUtil.class);
    private SimpleDateFormat m_dtFmt = new SimpleDateFormat("yyyyMMddHHmmss");
    private DecimalFormat m_numFmt = new DecimalFormat("-000");

    public FileUtil(String Path2, String Suffix) {
        this.m_filePath = Path2;
        this.m_fileSuffix = Suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object msg) {
        File fi = this.getFileName();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(fi);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(msg);
            objectOutputStream.flush();
        }
        catch (IOException e) {
            log.error(msg, (Throwable)e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String msg) {
        File fi = this.getFileName();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(fi));
            writer.write(msg, 0, msg.length());
        }
        catch (IOException e) {
            log.error((Object)msg, (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private File getFileName() {
        File fi = null;
        String filenameDate = this.m_dtFmt.format(new Date());
        StringBuffer fileNameFull = new StringBuffer(filenameDate);
        int i = 0;
        while (true) {
            fileNameFull.append(this.m_numFmt.format(i++));
            fileNameFull.append(this.m_fileSuffix);
            fi = new File(this.m_filePath, fileNameFull.toString());
            if (!fi.exists()) break;
            fileNameFull.delete(filenameDate.length(), fileNameFull.length());
        }
        return fi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readTxtFile(File file) {
        StringBuffer msg = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                msg.append(line);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            String string = null;
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        return msg.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readMsgFile(File file) {
        Object ret = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            ret = objectInputStream.readObject();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {}
        }
        return ret;
    }

    public Collection getFileList() {
        File dir = new File(this.m_filePath);
        File[] files = dir.listFiles();
        TreeMap<String, File> tree = new TreeMap<String, File>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().endsWith(this.m_fileSuffix)) continue;
            tree.put(files[i].getName(), files[i]);
        }
        return tree.values();
    }
}

