/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.troubledetection.jmx;

import com.clustercontrol.troubledetection.jmx.TroubleDetectionServiceMBean;
import com.clustercontrol.troubledetection.monitor.MonitorManagement;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;

public class TroubleDetectionService
extends ServiceMBeanSupport
implements TroubleDetectionServiceMBean {
    private String jndiName = "TroubleDetectionService";
    private MonitorManagement manager;

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) throws NamingException {
        this.log.info((Object)("setJndiName() : jndiName = " + jndiName));
        String oldName = this.jndiName;
        this.jndiName = jndiName;
        if (super.getState() == 3) {
            NamingException ne;
            try {
                this.unbind(oldName);
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to unbind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
            try {
                this.rebind();
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to rebind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
        }
    }

    public String getName() {
        return "TroubleDetectionService(" + this.jndiName + ")";
    }

    public void createService() {
        this.log.info((Object)("Create TroubleDetectionService(" + this.jndiName + ")"));
        this.manager = new MonitorManagement();
        this.log.info((Object)("Created TroubleDetectionService(" + this.jndiName + ")"));
    }

    public void startService() throws NamingException {
        this.log.info((Object)("Start TroubleDetectionService(" + this.jndiName + ")"));
        this.manager.exec();
        this.rebind();
        this.log.info((Object)("Started TroubleDetectionService(" + this.jndiName + ")"));
    }

    public void stopService() throws NamingException {
        this.log.info((Object)("Stop TroubleDetectionService(" + this.jndiName + ")"));
        this.manager.terminate();
        this.unbind(this.jndiName);
        this.log.info((Object)("Stoped TroubleDetectionService(" + this.jndiName + ")"));
    }

    public void destroyService() throws Exception {
        this.log.info((Object)("Destroy TroubleDetectionService(" + this.jndiName + ")"));
        if (this.manager != null) {
            this.manager.terminate();
        }
        this.manager = null;
        this.log.info((Object)("Destroyed TroubleDetectionService(" + this.jndiName + ")"));
    }

    public void updateNotify() {
        this.log.debug((Object)"updateNotify() start");
        this.manager.updateNotifyInfo();
        this.log.debug((Object)"updateNotify() end");
    }

    public void putMessage(String monitorId, String messageId) {
        this.log.debug((Object)("putMessage() start : monitorId=" + monitorId + ", messageId=" + messageId));
        this.manager.putMessage(monitorId, messageId);
        this.log.debug((Object)("putMessage() end : monitorId=" + monitorId + ", messageId=" + messageId));
    }

    private static Context createContext(Context rootCtx, Name name) throws NamingException {
        Context subctx = rootCtx;
        for (int n = 0; n < name.size(); ++n) {
            String atom = name.get(n);
            try {
                Object obj = subctx.lookup(atom);
                subctx = (Context)obj;
                continue;
            }
            catch (NamingException e) {
                subctx = subctx.createSubcontext(atom);
            }
        }
        return subctx;
    }

    private void rebind() throws NamingException {
        Name fullName;
        InitialContext rootCtx = new InitialContext();
        Name parentName = fullName = rootCtx.getNameParser("").parse(this.jndiName);
        parentName = fullName.size() > 1 ? fullName.getPrefix(fullName.size() - 1) : new CompositeName();
        Context parentCtx = TroubleDetectionService.createContext(rootCtx, parentName);
        Name atomName = fullName.getSuffix(fullName.size() - 1);
        String atomStirng = atomName.get(0);
        NonSerializableFactory.rebind((Context)parentCtx, (String)atomStirng, (Object)this.manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind(String jndiName) throws NamingException {
        InitialContext rootCtx = null;
        try {
            rootCtx = new InitialContext();
            Name fullName = rootCtx.getNameParser("").parse(jndiName);
            Name atomName = fullName.getSuffix(fullName.size() - 1);
            String atom = atomName.get(0);
            rootCtx.unbind(jndiName);
            NonSerializableFactory.unbind((String)atom);
        }
        finally {
            if (rootCtx != null) {
                rootCtx.close();
            }
        }
    }
}

