/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.troubledetection.monitor;

import com.clustercontrol.monitor.message.LogOutputBasicInfo;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.monitor.MonitorBase;
import com.clustercontrol.troubledetection.output.OutputLog;
import com.clustercontrol.troubledetection.util.NotifyMessages;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.postgresforest.vm.jdbc.ForestConnection;

public class MonitorForest
extends MonitorBase {
    private static Log log = LogFactory.getLog(MonitorForest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.debug((Object)"run() start :");
        Connection conn = null;
        ResultSet rs = null;
        boolean server1 = false;
        boolean server2 = false;
        try {
            InitialContext iniCtx = new InitialContext();
            DataSource ds = (DataSource)iniCtx.lookup("java:/HinemosDS");
            conn = ds.getConnection();
            ForestConnection forestConn = (ForestConnection)((WrappedConnection)conn).getUnderlyingConnection();
            rs = forestConn.getGscMetaData().getServer();
            while (rs.next()) {
                String server = rs.getString(2);
                int status = rs.getInt(3);
                if (server.matches(".*" + this.troubleDetectionInfo.getForest1() + ".*")) {
                    if (status != 1) continue;
                    server1 = true;
                    continue;
                }
                if (!server.matches(".*" + this.troubleDetectionInfo.getForest2() + ".*") || status != 1) continue;
                server2 = true;
            }
            rs.close();
        }
        catch (NamingException e) {
            log.error((Object)("run() : PostgresForest Connection Error : " + e.getMessage()));
        }
        catch (SQLException e) {
            log.error((Object)("run() : PostgresForest Connection Error : " + e.getMessage()));
        }
        catch (NoClassDefFoundError e) {
            log.error((Object)("run() : PostgresForest Connection Error : " + e.getMessage()));
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)("run() Error : " + e.getMessage()));
            }
        }
        this.logout(server1, server2);
        log.debug((Object)"run() end :");
    }

    protected void logout(boolean server1, boolean server2) {
        String application = NotifyMessages.getString("hinemosdb.application");
        OutputLog output = new OutputLog(this.troubleDetectionInfo);
        if (server1 && server2) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("HINEMOSDB01");
            info.setMessageId("001");
            info.setMessage(NotifyMessages.getString("hinemosdb01.001.message"));
            Object[] args = new String[]{this.troubleDetectionInfo.getForest1(), this.troubleDetectionInfo.getForest2()};
            info.setMessageOrg(NotifyMessages.getString("hinemosdb01.001.org.message", args));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("hinemosdb01.001.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        } else if (server1 && !server2) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("HINEMOSDB01");
            info.setMessageId("002");
            Object[] args = new String[]{this.troubleDetectionInfo.getForest2()};
            info.setMessage(NotifyMessages.getString("hinemosdb01.002.message", args));
            info.setMessageOrg(NotifyMessages.getString("hinemosdb01.002.org.message", args));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("hinemosdb01.002.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        } else if (!server1 && server2) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("HINEMOSDB01");
            info.setMessageId("002");
            Object[] args = new String[]{this.troubleDetectionInfo.getForest1()};
            info.setMessage(NotifyMessages.getString("hinemosdb01.002.message", args));
            info.setMessageOrg(NotifyMessages.getString("hinemosdb01.002.org.message", args));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("hinemosdb01.002.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        } else if (!server1 && !server2) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("HINEMOSDB01");
            info.setMessageId("003");
            info.setMessage(NotifyMessages.getString("hinemosdb01.003.message"));
            info.setMessageOrg(NotifyMessages.getString("hinemosdb01.003.org.message"));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("hinemosdb01.003.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        }
    }

    public void logout(String monitorId, String messageId) {
        String application = NotifyMessages.getString("hinemosdb.application");
        String key = monitorId.toLowerCase() + "." + messageId;
        OutputLog output = new OutputLog(this.troubleDetectionInfo);
        LogOutputInfo info = new LogOutputInfo();
        info.setPluginId("SYSMON");
        info.setApplication(application);
        info.setMonitorId(monitorId);
        info.setMessageId(messageId);
        info.setMessage(NotifyMessages.getString(key + ".message"));
        info.setMessageOrg(NotifyMessages.getString(key + ".org.message"));
        info.setFacilityId("SYSTEM");
        info.setScopeText("");
        info.setPriority(this.getPriority(NotifyMessages.getString(key + ".priority")));
        info.setGenerationDate(new Date());
        output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
    }
}

