/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.troubledetection.monitor;

import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;
import com.clustercontrol.troubledetection.ejb.session.TroubleDetectionControllerLocal;
import com.clustercontrol.troubledetection.ejb.session.TroubleDetectionControllerUtil;
import com.clustercontrol.troubledetection.monitor.MonitorForest;
import com.clustercontrol.troubledetection.monitor.MonitorJboss;
import com.clustercontrol.troubledetection.monitor.MonitorLdap;
import com.clustercontrol.troubledetection.monitor.MonitorSyslogForward;
import com.clustercontrol.troubledetection.monitor.MonitorTask;
import com.clustercontrol.troubledetection.util.MailManager;
import java.util.Timer;
import java.util.TimerTask;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MonitorManagement {
    private static Log log = LogFactory.getLog(MonitorManagement.class);
    protected Timer timer = null;
    protected MonitorTask task = null;
    protected TroubleDetectionInfo troubleDetectionInfo = null;
    protected NotifyInfo notifyInfo = null;

    public void exec() {
        this.troubleDetectionInfo = this.getTroubleDetectionInfo();
        this.notifyInfo = this.getNotifyInfo();
        MailManager mailManager = MailManager.getMailManager();
        mailManager.setTroubleDetectionInfo(this.troubleDetectionInfo);
        mailManager.start();
        this.task = new MonitorTask();
        this.task.setTroubleDetectionInfo(this.troubleDetectionInfo);
        this.task.setNotifyInfo(this.notifyInfo);
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)this.task, this.troubleDetectionInfo.getInterval() * 60000, (long)(this.troubleDetectionInfo.getInterval() * 60000));
    }

    public void terminate() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
        MailManager mailManager = MailManager.getMailManager();
        mailManager.interrupt();
    }

    public void updateNotifyInfo() {
        log.debug((Object)"updateNotifyInfo() start");
        NotifyInfo info = this.getNotifyInfo();
        if (info != null) {
            this.notifyInfo = info;
            this.task.setNotifyInfo(this.notifyInfo);
        }
        log.debug((Object)"updateNotifyInfo() end");
    }

    public void putMessage(String monitorId, String messageId) {
        log.debug((Object)("putMessage() start : monitorId=" + monitorId + ", messageId=" + messageId));
        String lowerMonitorId = monitorId.toLowerCase();
        if (lowerMonitorId.matches("jboss.*")) {
            MonitorJboss jboss = new MonitorJboss();
            jboss.setTroubleDetectionInfo(this.troubleDetectionInfo);
            jboss.setNotifyInfo(this.notifyInfo);
            jboss.logout(monitorId, messageId);
        } else if (lowerMonitorId.matches("ldap.*")) {
            MonitorLdap ldap = new MonitorLdap();
            ldap.setTroubleDetectionInfo(this.troubleDetectionInfo);
            ldap.setNotifyInfo(this.notifyInfo);
            ldap.logout(monitorId, messageId);
        } else if (lowerMonitorId.matches("hinemosdb.*")) {
            MonitorForest forest = new MonitorForest();
            forest.setTroubleDetectionInfo(this.troubleDetectionInfo);
            forest.setNotifyInfo(this.notifyInfo);
            forest.logout(monitorId, messageId);
        } else if (lowerMonitorId.matches("syslog.*")) {
            MonitorSyslogForward syslogForward = new MonitorSyslogForward();
            syslogForward.setTroubleDetectionInfo(this.troubleDetectionInfo);
            syslogForward.setNotifyInfo(this.notifyInfo);
            syslogForward.logout(monitorId, messageId);
        }
        log.debug((Object)("putMessage() end : monitorId=" + monitorId + ", messageId=" + messageId));
    }

    public TroubleDetectionInfo getTroubleDetectionInfo() {
        TroubleDetectionInfo info = null;
        try {
            TroubleDetectionControllerLocal controller = TroubleDetectionControllerUtil.getLocalHome().create();
            info = controller.getInfo();
        }
        catch (CreateException e) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return info;
    }

    public NotifyInfo getNotifyInfo() {
        NotifyInfo info = null;
        try {
            TroubleDetectionControllerLocal controller = TroubleDetectionControllerUtil.getLocalHome().create();
            info = controller.getNotify();
        }
        catch (CreateException e) {
        }
        catch (NamingException e) {
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        return info;
    }
}

