/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.troubledetection.monitor;

import com.clustercontrol.monitor.message.LogOutputBasicInfo;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.monitor.MonitorBase;
import com.clustercontrol.troubledetection.output.OutputLog;
import com.clustercontrol.troubledetection.util.NotifyMessages;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.jms.InvalidSelectorException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.mq.Subscription;
import org.jboss.mq.selectors.Selector;

public class MonitorSyslogForward
extends MonitorBase {
    private static Log log = LogFactory.getLog(MonitorSyslogForward.class);
    protected static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    protected static final String OBJECT_NAME = "jboss.mq.destination:name=clustercontrol/Repository/update,service=Topic";
    protected static final String OPERATION_NAME = "listAllSubscriptions";

    public void run() {
        log.debug((Object)"run() start :");
        boolean syslogForward1 = false;
        boolean syslogForward2 = false;
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(OBJECT_NAME);
            Object returnObject = server.invoke(name, OPERATION_NAME, null, null);
            if (returnObject instanceof List) {
                String checkString1 = "MultiId='" + this.troubleDetectionInfo.getSyslogForward1() + "'";
                String checkString2 = "MultiId='" + this.troubleDetectionInfo.getSyslogForward2() + "'";
                for (int i = 0; i < ((List)returnObject).size(); ++i) {
                    Subscription subscription = (Subscription)((List)returnObject).get(i);
                    try {
                        Selector selecter = subscription.getSelector();
                        if (selecter == null) continue;
                        if (selecter.selector.indexOf(checkString1) != -1) {
                            syslogForward1 = true;
                            continue;
                        }
                        if (selecter.selector.indexOf(checkString2) == -1) continue;
                        syslogForward2 = true;
                        continue;
                    }
                    catch (InvalidSelectorException e) {
                        log.debug((Object)("run() : " + e.getMessage()));
                    }
                }
            }
        }
        catch (NamingException e) {
            log.debug((Object)("run() : " + e.getMessage()));
        }
        catch (MalformedObjectNameException e) {
            log.debug((Object)("run() : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            log.debug((Object)("run() : " + e.getMessage()));
        }
        catch (InstanceNotFoundException e) {
            log.debug((Object)("run() : " + e.getMessage()));
        }
        catch (MBeanException e) {
            log.debug((Object)("run() : " + e.getMessage()));
        }
        catch (ReflectionException e) {
            log.debug((Object)("run() : " + e.getMessage()));
        }
        catch (IOException e) {
            log.debug((Object)("run() : " + e.getMessage()));
        }
        this.logout(syslogForward1, syslogForward2);
        log.debug((Object)"run() end :");
    }

    protected void logout(boolean syslogForward1, boolean syslogForward2) {
        String application = NotifyMessages.getString("syslog.application");
        OutputLog output = new OutputLog(this.troubleDetectionInfo);
        if (syslogForward1 && syslogForward2) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("SYSLOG01");
            info.setMessageId("001");
            info.setMessage(NotifyMessages.getString("syslog01.001.message"));
            Object[] args = new String[]{this.troubleDetectionInfo.getSyslogForward1(), this.troubleDetectionInfo.getSyslogForward2()};
            info.setMessageOrg(NotifyMessages.getString("syslog01.001.org.message", args));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("syslog01.001.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        } else if (!syslogForward1 && syslogForward2) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("SYSLOG01");
            info.setMessageId("002");
            Object[] args1 = new String[]{this.troubleDetectionInfo.getSyslogForward1()};
            info.setMessage(NotifyMessages.getString("syslog01.002.message", args1));
            Object[] args2 = new String[]{this.troubleDetectionInfo.getSyslogForward1(), this.troubleDetectionInfo.getSyslogForward2()};
            info.setMessageOrg(NotifyMessages.getString("syslog01.002.org.message", args2));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("syslog01.002.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        } else if (syslogForward1 && !syslogForward2) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("SYSLOG01");
            info.setMessageId("002");
            Object[] args1 = new String[]{this.troubleDetectionInfo.getSyslogForward2()};
            info.setMessage(NotifyMessages.getString("syslog01.002.message", args1));
            Object[] args2 = new String[]{this.troubleDetectionInfo.getSyslogForward2(), this.troubleDetectionInfo.getSyslogForward1()};
            info.setMessageOrg(NotifyMessages.getString("syslog01.002.org.message", args2));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("syslog01.002.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        } else if (!syslogForward1 && !syslogForward2) {
            LogOutputInfo info = new LogOutputInfo();
            info.setPluginId("SYSMON");
            info.setApplication(application);
            info.setMonitorId("SYSLOG01");
            info.setMessageId("003");
            info.setMessage(NotifyMessages.getString("syslog01.003.message"));
            Object[] args = new String[]{this.troubleDetectionInfo.getSyslogForward1(), this.troubleDetectionInfo.getSyslogForward2()};
            info.setMessageOrg(NotifyMessages.getString("syslog01.003.org.message", args));
            info.setFacilityId("SYSTEM");
            info.setScopeText("");
            info.setPriority(this.getPriority(NotifyMessages.getString("syslog01.003.priority")));
            info.setGenerationDate(new Date());
            output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
        }
    }

    public void logout(String monitorId, String messageId) {
        String application = NotifyMessages.getString("syslog.application");
        String key = monitorId.toLowerCase() + "." + messageId;
        OutputLog output = new OutputLog(this.troubleDetectionInfo);
        LogOutputInfo info = new LogOutputInfo();
        info.setPluginId("SYSMON");
        info.setApplication(application);
        info.setMonitorId(monitorId);
        info.setMessageId(messageId);
        info.setMessage(NotifyMessages.getString(key + ".message"));
        info.setMessageOrg(NotifyMessages.getString(key + ".org.message"));
        info.setFacilityId("SYSTEM");
        info.setScopeText("");
        info.setPriority(this.getPriority(NotifyMessages.getString(key + ".priority")));
        info.setGenerationDate(new Date());
        output.outputLog(this.notifyInfo, (LogOutputBasicInfo)info);
    }
}

