/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.troubledetection.output;

import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.message.LogOutputControlInfo;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputControl {
    private static Log log = LogFactory.getLog(OutputControl.class);
    private static HashMap<String, LogOutputControlInfo> controlBuffer = new HashMap();
    private Timestamp outputDate = null;
    private boolean insertFlg;
    private boolean updateFlg;

    public void control(LogOutputInfo logOutput, Timestamp outputDate) {
        log.debug((Object)("control() start : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId()));
        this.outputDate = outputDate;
        this.insertFlg = false;
        this.updateFlg = false;
        if (logOutput.isEventLogFlg()) {
            LogOutputControlInfo controlInfo;
            if (logOutput.getExcludeFlg() == 1 || logOutput.getExcludeFlg() == 2 || logOutput.getExcludeFlg() == 3) {
                controlInfo = controlBuffer.get(logOutput.getMonitorId());
                if (controlInfo != null) {
                    if (this.isInhibited(logOutput, controlInfo)) {
                        this.updateFlg = true;
                    } else {
                        this.insertFlg = true;
                    }
                } else {
                    this.insertFlg = true;
                }
            } else {
                this.insertFlg = true;
            }
            if (this.insertFlg) {
                controlInfo = new LogOutputControlInfo();
                controlInfo.setLogOutputInfo(logOutput);
                controlInfo.setDuplicationCount(0);
                controlBuffer.put(logOutput.getMonitorId(), controlInfo);
                log.debug((Object)("control() insert : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId()));
            }
            if (this.updateFlg) {
                controlInfo = controlBuffer.get(logOutput.getMonitorId());
                controlInfo.setDuplicationCount(controlInfo.getDuplicationCount() + 1);
                controlBuffer.put(logOutput.getMonitorId(), controlInfo);
                log.debug((Object)("control() update : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId()));
                if (logOutput.getExcludeConfirmFlg() == 1 || logOutput.getExcludeConfirmFlg() == 0) {
                    this.insertFlg = true;
                    log.debug((Object)("control() insert : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId()));
                }
            }
        }
        log.debug((Object)("control() end : MonitorId=" + logOutput.getMonitorId() + ", MessageId" + logOutput.getMessageId()));
    }

    public boolean isInhibited(LogOutputInfo logOutput, LogOutputControlInfo controlInfo) {
        if (logOutput.getExcludeFlg() == 1) {
            if (controlInfo.getDuplicationCount() < logOutput.getExcludeNumber()) {
                return true;
            }
        } else if (logOutput.getExcludeFlg() == 2) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(controlInfo.getLogOutputInfo().getGenerationDate());
            cal.add(12, logOutput.getExcludePeriod());
            if (cal.getTime().compareTo(logOutput.getGenerationDate()) > 0) {
                return true;
            }
        } else if (logOutput.getExcludeFlg() == 3 && controlInfo.getLogOutputInfo().getPriority() == logOutput.getPriority()) {
            return true;
        }
        return false;
    }

    public Timestamp getOutputDate() {
        return this.outputDate;
    }

    public void setOutputDate(Timestamp outputDate) {
        this.outputDate = outputDate;
    }

    public boolean isInsertFlg() {
        return this.insertFlg;
    }

    public boolean isUpdateFlg() {
        return this.updateFlg;
    }
}

