/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.handler;

import java.security.Principal;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.encoding.Base64;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;

public class ClientLoginHandler
extends BasicHandler {
    static final long serialVersionUID = -5105554242454628283L;
    private static final Logger log = Logger.getLogger((Class)ClientLoginHandler.class);

    public void invoke(MessageContext msgContext) throws AxisFault {
        String username = msgContext.getUsername();
        String password = msgContext.getPassword();
        if (username == null && password == null) {
            Principal principal = SecurityAssociation.getPrincipal();
            Object credential = SecurityAssociation.getCredential();
            if (principal != null) {
                username = principal.getName();
            }
            if (credential instanceof char[]) {
                password = new String((char[])credential);
            } else if (credential != null) {
                password = credential.toString();
            }
        }
        if (username != null && password != null) {
            try {
                msgContext.setUsername(username);
                msgContext.setPassword(password);
                SOAPMessage soapMessage = msgContext.getMessage();
                SOAPHeader soapHeader = soapMessage.getSOAPPart().getEnvelope().getHeader();
                SOAPFactory soapFactory = SOAPFactory.newInstance();
                Name usrName = soapFactory.createName("username", "jbws", "http://webservice.jboss.com/ws4ee");
                SOAPHeaderElement usrElement = soapHeader.addHeaderElement(usrName);
                usrElement.setActor("http://webservice.jboss.com/ws4ee/login");
                usrElement.addTextNode(username);
                password = Base64.encode((byte[])password.getBytes());
                Name pwdName = soapFactory.createName("password", "jbws", "http://webservice.jboss.com/ws4ee");
                SOAPHeaderElement pwdElement = soapHeader.addHeaderElement(pwdName);
                pwdElement.setActor("http://webservice.jboss.com/ws4ee/login");
                pwdElement.addTextNode(password);
            }
            catch (SOAPException e) {
                log.error((Object)("Client login failed: " + e.toString()));
                throw new AxisFault("Client login failed", (Throwable)e);
            }
        }
    }
}

