/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jboss.beans.metadata.plugins.AbstractTypeMetaData;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;

public class StringValueMetaData
extends AbstractTypeMetaData {
    private static final Logger log = Logger.getLogger((Class)StringValueMetaData.class);

    public StringValueMetaData() {
    }

    public StringValueMetaData(String value) {
        super(value);
    }

    public void setValue(String value) {
        super.setValue(value);
    }

    public void setValue(Object value) {
        if (value != null && !(value instanceof String)) {
            throw new ClassCastException("value is not a String: " + value);
        }
        super.setValue(value);
    }

    public Object getValue(TypeInfo info) throws Throwable {
        ClassInfo typeInfo;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("getValue value=" + this.value + " type=" + this.type + " info=" + info));
        }
        if ((typeInfo = this.getClassInfo()) == null) {
            typeInfo = info;
        }
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to determine type for value: " + this.value);
        }
        Class clazz = typeInfo.getType();
        PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
        if (editor != null) {
            editor.setAsText((String)this.value);
            return editor.getValue();
        }
        Constructor constructor = clazz.getConstructor(String.class);
        try {
            return constructor.newInstance(this.value);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    static {
        try {
            Class.forName("org.jboss.util.propertyeditor.PropertyEditors");
        }
        catch (ClassNotFoundException ignored) {
            log.trace((Object)"Unable to load property editors", (Throwable)ignored);
        }
    }
}

