/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment.xml;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.xb.binding.MetadataDrivenObjectModelFactory;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.TypeBinding;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.metadata.unmarshalling.BasicElementBinding;
import org.jboss.xb.binding.metadata.unmarshalling.DocumentBinding;
import org.jboss.xb.binding.metadata.unmarshalling.DocumentBindingFactory;
import org.jboss.xb.binding.metadata.unmarshalling.ElementBinding;
import org.jboss.xb.binding.metadata.unmarshalling.NamespaceBinding;
import org.jboss.xb.binding.metadata.unmarshalling.TopElementBinding;
import org.jboss.xb.binding.metadata.unmarshalling.XmlValueBinding;
import org.jboss.xb.binding.metadata.unmarshalling.XmlValueContainer;

public class XMLKernelDeployer
extends AbstractKernelDeployer {
    private static final Logger log = Logger.getLogger((Class)XMLKernelDeployer.class);
    protected DocumentBinding documentBinding;

    public XMLKernelDeployer(Kernel kernel) throws Throwable {
        super(kernel);
        DocumentBindingFactory factory = DocumentBindingFactory.newInstance();
        this.documentBinding = factory.newDocumentBinding();
        NamespaceBinding ns = factory.bindNamespace(this.documentBinding, "", "org.jboss.beans.metadata.plugins");
        TopElementBinding deployment = factory.bindTopElement(ns, "deployment", AbstractKernelDeployment.class);
        factory.bindValue((XmlValueContainer)deployment, "beans", ArrayList.class);
        ElementBinding bean = factory.bindElement((BasicElementBinding)deployment, "", "bean", "beans", AbstractBeanMetaData.class);
        factory.bindAttribute((BasicElementBinding)bean, "", "name", "name", String.class);
        factory.bindAttribute((BasicElementBinding)bean, "", "class", "bean", String.class);
        factory.bindValue((XmlValueContainer)bean, "properties", HashSet.class);
        factory.bindValue((XmlValueContainer)bean, "demands", HashSet.class);
        factory.bindValue((XmlValueContainer)bean, "supplies", HashSet.class);
        ElementBinding property = factory.bindElement((BasicElementBinding)bean, "", "property", "properties", AbstractPropertyMetaData.class);
        factory.bindAttribute((BasicElementBinding)property, "", "name", "name", String.class);
        XmlValueBinding propertyStringValue = factory.bindValue((XmlValueContainer)property, "value", StringValueMetaData.class);
        factory.bindValue((XmlValueContainer)propertyStringValue, "value", String.class);
        ElementBinding propertyDependency = factory.bindElement((BasicElementBinding)property, "", "inject", "value", AbstractDependencyValueMetaData.class);
        factory.bindAttribute((BasicElementBinding)propertyDependency, "", "bean", "value", String.class);
        ElementBinding constructor = factory.bindElement((BasicElementBinding)bean, "", "constructor", "constructor", AbstractConstructorMetaData.class);
        factory.bindAttribute((BasicElementBinding)constructor, "", "factoryClass", "factoryClass", String.class);
        factory.bindAttribute((BasicElementBinding)constructor, "", "factoryMethod", "factoryMethod", String.class);
        factory.bindValue((XmlValueContainer)constructor, "parameters", ArrayList.class);
        ElementBinding factoryElement = factory.bindElement((BasicElementBinding)constructor, "", "factory", "factory", AbstractDependencyValueMetaData.class);
        factory.bindAttribute((BasicElementBinding)factoryElement, "", "value", "value", String.class);
        ElementBinding parameter = factory.bindElement((BasicElementBinding)constructor, "", "parameter", "parameters", AbstractParameterMetaData.class);
        factory.bindAttribute((BasicElementBinding)parameter, "", "type", "type", String.class);
        XmlValueBinding parameterStringValue = factory.bindValue((XmlValueContainer)parameter, "value", StringValueMetaData.class);
        factory.bindValue((XmlValueContainer)parameterStringValue, "value", String.class);
        ElementBinding parameterDependency = factory.bindElement((BasicElementBinding)parameter, "", "inject", "value", AbstractDependencyValueMetaData.class);
        factory.bindAttribute((BasicElementBinding)parameterDependency, "", "bean", "value", String.class);
        ElementBinding demand = factory.bindElement((BasicElementBinding)bean, "", "demand", "demands", AbstractDemandMetaData.class);
        factory.bindValue((XmlValueContainer)demand, "demand", String.class);
        ElementBinding supply = factory.bindElement((BasicElementBinding)bean, "", "supply", "supplies", AbstractSupplyMetaData.class);
        factory.bindValue((XmlValueContainer)supply, "supply", String.class);
    }

    public KernelDeployment deploy(URL url) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        if (trace) {
            log.trace((Object)("Parsing " + url));
        }
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(url.toString(), (ObjectModelFactory)new MetadataDrivenObjectModelFactory(), this.documentBinding);
        deployment.setName(url.toString());
        if (trace) {
            log.trace((Object)("Deploying " + deployment));
        }
        this.deploy(deployment);
        if (trace) {
            log.trace((Object)("Deployed " + deployment.getInstalledContexts()));
        }
        return deployment;
    }

    public KernelDeployment deploy(String deploymentName, InputStream stream) throws Throwable {
        boolean trace = log.isTraceEnabled();
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(stream, (ObjectModelFactory)new MetadataDrivenObjectModelFactory(), (Object)this.documentBinding);
        deployment.setName(deploymentName);
        if (trace) {
            log.trace((Object)("Deploying " + deployment));
        }
        this.deploy(deployment);
        if (trace) {
            log.trace((Object)("Deployed " + deployment.getInstalledContexts()));
        }
        return deployment;
    }

    protected static class StateConverter
    implements TypeBinding {
        public static final StateConverter instance = new StateConverter();

        protected StateConverter() {
        }

        public String marshal(Object value) {
            throw new NotImplementedException("NYI");
        }

        public Object unmarshal(String value) {
            return new ControllerState(value);
        }
    }
}

