/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.xml.sax.Attributes;

public class SundayContentHandler
implements JBossXBParser.ContentHandler {
    private static final Logger log = Logger.getLogger(SundayContentHandler.class);
    private static final Object NIL = new Object();
    private final SchemaBinding schema;
    private final SchemaBindingResolver schemaResolver;
    private final StackImpl elementStack = new StackImpl();
    private final StackImpl objectStack = new StackImpl();
    private StringBuffer textContent = new StringBuffer();
    private Object root;
    private NamespaceRegistry nsRegistry = new NamespaceRegistry();

    public SundayContentHandler(SchemaBinding schema) {
        this.schema = schema;
        this.schemaResolver = null;
    }

    public SundayContentHandler(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
        this.schema = null;
    }

    public void characters(char[] ch, int start, int length) {
        if (this.elementStack.peek() != null) {
            this.textContent.append(ch, start, length);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        block18: {
            Object o;
            block21: {
                ElementInterceptor interceptor;
                int i;
                Object parent;
                List elementHandlers;
                QName endName;
                block19: {
                    ElementBinding parentElement;
                    block20: {
                        ElementBinding elementBinding = (ElementBinding)this.elementStack.pop();
                        if (elementBinding == null) break block18;
                        endName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
                        o = this.objectStack.pop();
                        TypeBinding typeBinding = elementBinding.getType();
                        elementHandlers = elementBinding.getInterceptors();
                        if (o != NIL) {
                            CharactersHandler simpleType = typeBinding.getSimpleType();
                            if (this.textContent.length() > 0 || simpleType != null) {
                                Object unmarshalled;
                                String dataContent;
                                SchemaBinding schema = elementBinding.getSchema();
                                if (this.textContent.length() == 0) {
                                    dataContent = null;
                                } else {
                                    dataContent = this.textContent.toString();
                                    if (schema != null && schema.isReplacePropertyRefs()) {
                                        dataContent = StringPropertyReplacer.replaceProperties(dataContent);
                                    }
                                    this.textContent.delete(0, this.textContent.length());
                                }
                                if (simpleType == null) {
                                    if (schema != null && schema.isStrictSchema()) {
                                        throw new JBossXBRuntimeException("Element " + endName + " type binding " + typeBinding.getQName() + " does not include text content binding ('" + dataContent);
                                    }
                                    unmarshalled = dataContent;
                                } else {
                                    CharactersMetaData charactersMetaData;
                                    ValueMetaData valueMetaData = elementBinding.getValueMetaData();
                                    if (valueMetaData == null && (charactersMetaData = typeBinding.getCharactersMetaData()) != null) {
                                        valueMetaData = charactersMetaData.getValue();
                                    }
                                    Object object = unmarshalled = dataContent == null ? simpleType.unmarshalEmpty(endName, typeBinding, this.nsRegistry, valueMetaData) : simpleType.unmarshal(endName, typeBinding, this.nsRegistry, valueMetaData, dataContent);
                                }
                                if (unmarshalled != null) {
                                    if (o == null) {
                                        o = unmarshalled;
                                    } else if (simpleType != null) {
                                        simpleType.setValue(endName, elementBinding, o, unmarshalled);
                                    }
                                }
                                int i2 = elementHandlers.size();
                                while (i2-- > 0) {
                                    ElementInterceptor interceptor2 = (ElementInterceptor)elementHandlers.get(i2);
                                    interceptor2.characters(this.objectStack.peek(elementHandlers.size() - 1 - i2), endName, typeBinding, this.nsRegistry, dataContent);
                                }
                            }
                        } else {
                            o = null;
                        }
                        parent = this.objectStack.isEmpty() ? null : this.objectStack.peek();
                        o = typeBinding.endElement(parent, o, elementBinding, endName);
                        i = elementHandlers.size();
                        while (i-- > 0) {
                            interceptor = (ElementInterceptor)elementHandlers.get(i);
                            interceptor.endElement(this.objectStack.peek(elementHandlers.size() - 1 - i), endName, typeBinding);
                        }
                        i = elementHandlers.size();
                        if (i != 0) break block19;
                        ElementBinding elementBinding2 = parentElement = this.elementStack.isEmpty() ? null : (ElementBinding)this.elementStack.peek();
                        if (parent == null) break block20;
                        typeBinding.getHandler().setParent(parent, o, endName, elementBinding, parentElement);
                        break block21;
                    }
                    if (parentElement == null || this.objectStack.isEmpty()) break block21;
                    this.objectStack.pop();
                    this.objectStack.push(o);
                    if (!log.isTraceEnabled()) break block21;
                    log.trace("Value of " + endName + " " + o + " is promoted as the value of its parent element.");
                    break block21;
                }
                while (i-- > 0) {
                    interceptor = (ElementInterceptor)elementHandlers.get(i);
                    parent = this.objectStack.pop();
                    interceptor.add(parent, o, endName);
                    o = parent;
                }
            }
            if (this.objectStack.isEmpty()) {
                this.root = o;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts, XSTypeDefinition type) {
        QName startName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
        ElementBinding binding = null;
        ElementBinding parentBinding = null;
        SchemaBinding schemaBinding = this.schema;
        if (this.elementStack.isEmpty()) {
            if (schemaBinding != null) {
                binding = schemaBinding.getElement(startName);
            } else {
                if (this.schemaResolver == null) throw new JBossXBRuntimeException("Neither schema binding nor schema binding resolver is not available!");
                String schemaLocation = atts == null ? null : Util.getSchemaLocation(atts, namespaceURI);
                schemaBinding = this.schemaResolver.resolve(namespaceURI, localName, null, schemaLocation);
                if (schemaBinding != null) {
                    binding = schemaBinding.getElement(startName);
                }
            }
        } else {
            parentBinding = (ElementBinding)this.elementStack.peek();
            if (parentBinding != null) {
                binding = parentBinding.getType().getElement(startName, atts);
                schemaBinding = parentBinding.getSchema();
            }
        }
        this.elementStack.push(binding);
        if (binding != null) {
            TypeBinding typeBinding = binding.getType();
            Object o = this.objectStack.isEmpty() ? null : this.objectStack.peek();
            List elementHandlers = binding.getInterceptors();
            for (int i = 0; i < elementHandlers.size(); ++i) {
                ElementInterceptor interceptor = (ElementInterceptor)elementHandlers.get(i);
                o = interceptor.startElement(o, startName, typeBinding);
                this.objectStack.push(o);
                interceptor.attributes(o, startName, typeBinding, atts, this.nsRegistry);
            }
            String nil = atts.getValue("xsi:nil");
            o = nil == null || !"1".equals(nil) && !"true".equals(nil) ? typeBinding.startElement(o, startName, binding) : NIL;
            this.objectStack.push(o);
            if (o == null || o == NIL) return;
            atts = typeBinding.expandWithDefaultAttributes(atts);
            typeBinding.attributes(o, startName, binding, atts, this.nsRegistry);
            return;
        } else {
            if (schemaBinding != null && schemaBinding.isStrictSchema()) {
                throw new JBossXBRuntimeException("Element " + startName + " is not bound " + (parentBinding == null ? "as a global element." : "in type " + parentBinding.getType().getQName()));
            }
            if (!log.isTraceEnabled()) return;
            log.trace("Element " + startName + " is not bound " + (parentBinding == null ? "as a global element." : "in type " + parentBinding.getType().getQName()));
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.nsRegistry.addPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        this.nsRegistry.removePrefixMapping(prefix);
    }

    public void processingInstruction(String target, String data) {
    }

    public Object getRoot() {
        return this.root;
    }

    static class StackImpl {
        private LinkedList list = new LinkedList();

        StackImpl() {
        }

        public void clear() {
            this.list.clear();
        }

        public void push(Object o) {
            this.list.addLast(o);
        }

        public Object pop() {
            return this.list.removeLast();
        }

        public Object peek() {
            return this.list.getLast();
        }

        public Object peek(int i) {
            return this.list.get(this.list.size() - 1 - i);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public int size() {
            return this.list.size();
        }
    }
}

