/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jfree.text.TextUtilities;
import org.jfree.ui.NumberCellRenderer;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;

public abstract class RefineryUtilities {
    private static boolean useDrawRotatedStringWorkaround = true;
    protected static final LogContext logger = Log.createContext(class$org$jfree$ui$RefineryUtilities == null ? (class$org$jfree$ui$RefineryUtilities = RefineryUtilities.class$("org.jfree.ui.RefineryUtilities")) : class$org$jfree$ui$RefineryUtilities);
    static /* synthetic */ Class class$org$jfree$ui$RefineryUtilities;
    static /* synthetic */ Class class$java$lang$Number;

    public static void setUseDrawRotatedStringWorkaround(boolean bl) {
        useDrawRotatedStringWorkaround = bl;
    }

    public static void centerFrameOnScreen(Window window) {
        RefineryUtilities.positionFrameOnScreen(window, 0.5, 0.5);
    }

    public static void positionFrameOnScreen(Window window, double d, double d2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        int n = Math.max(dimension.width - dimension2.width, 0);
        int n2 = Math.max(dimension.height - dimension2.height, 0);
        int n3 = (int)(d * (double)n);
        int n4 = (int)(d2 * (double)n2);
        window.setBounds(n3, n4, dimension2.width, dimension2.height);
    }

    public static void positionFrameRandomly(Window window) {
        RefineryUtilities.positionFrameOnScreen(window, Math.random(), Math.random());
    }

    public static void centerDialogInParent(Dialog dialog) {
        RefineryUtilities.positionDialogRelativeToParent(dialog, 0.5, 0.5);
    }

    public static void positionDialogRelativeToParent(Dialog dialog, double d, double d2) {
        Dimension dimension = dialog.getSize();
        Container container = dialog.getParent();
        Dimension dimension2 = container.getSize();
        int n = container.getX() - dimension.width;
        int n2 = container.getY() - dimension.height;
        int n3 = dimension.width + dimension2.width;
        int n4 = dimension.height + dimension2.height;
        int n5 = n + (int)(d * (double)n3);
        int n6 = n2 + (int)(d2 * (double)n4);
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        n5 = Math.min(n5, dimension3.width - dimension.width);
        n5 = Math.max(n5, 0);
        n6 = Math.min(n6, dimension3.height - dimension.height);
        n6 = Math.max(n6, 0);
        dialog.setBounds(n5, n6, dimension.width, dimension.height);
    }

    public static JPanel createTablePanel(TableModel tableModel) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTable jTable = new JTable(tableModel);
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            Class<?> clazz = tableModel.getColumnClass(i);
            if (!clazz.equals(class$java$lang$Number == null ? RefineryUtilities.class$("java.lang.Number") : class$java$lang$Number)) continue;
            tableColumn.setCellRenderer(new NumberCellRenderer());
        }
        jPanel.add(new JScrollPane(jTable));
        return jPanel;
    }

    public static JLabel createJLabel(String string, Font font) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        return jLabel;
    }

    public static JLabel createJLabel(String string, Font font, Color color) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        jLabel.setForeground(color);
        return jLabel;
    }

    public static JButton createJButton(String string, Font font) {
        JButton jButton = new JButton(string);
        jButton.setFont(font);
        return jButton;
    }

    public static void drawAlignedString(String string, Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor) {
        float[] fArray = RefineryUtilities.deriveTextBoundsAnchorOffsets(graphics2D, string, textAnchor);
        graphics2D.drawString(string, f + fArray[0], f2 + fArray[1]);
    }

    public static Shape calculateRotatedStringBounds(String string, Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, TextAnchor textAnchor2, double d) {
        if (string == null || string.equals("")) {
            return null;
        }
        float[] fArray = RefineryUtilities.deriveTextBoundsAnchorOffsets(graphics2D, string, textAnchor);
        if (logger.isDebugEnabled()) {
            logger.debug("TextBoundsAnchorOffsets = " + fArray[0] + ", " + fArray[1]);
        }
        float[] fArray2 = RefineryUtilities.deriveRotationAnchorOffsets(graphics2D, string, textAnchor2);
        if (logger.isDebugEnabled()) {
            logger.debug("RotationAnchorOffsets = " + fArray2[0] + ", " + fArray2[1]);
        }
        Shape shape = RefineryUtilities.calculateRotatedStringBounds(string, graphics2D, f + fArray[0], f2 + fArray[1], d, f + fArray[0] + fArray2[0], f2 + fArray[1] + fArray2[1]);
        return shape;
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, float f, float f2, double d) {
        RefineryUtilities.drawRotatedString(string, graphics2D, f, f2, d, f, f2);
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, float f3, float f4, double d) {
        if (string == null || string.equals("")) {
            return;
        }
        float[] fArray = RefineryUtilities.deriveTextBoundsAnchorOffsets(graphics2D, string, textAnchor);
        RefineryUtilities.drawRotatedString(string, graphics2D, f + fArray[0], f2 + fArray[1], d, f3, f4);
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, TextAnchor textAnchor2, double d) {
        if (string == null || string.equals("")) {
            return;
        }
        float[] fArray = RefineryUtilities.deriveTextBoundsAnchorOffsets(graphics2D, string, textAnchor);
        float[] fArray2 = RefineryUtilities.deriveRotationAnchorOffsets(graphics2D, string, textAnchor2);
        RefineryUtilities.drawRotatedString(string, graphics2D, f + fArray[0], f2 + fArray[1], d, f + fArray[0] + fArray2[0], f2 + fArray[1] + fArray2[1]);
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, float f, float f2, double d, float f3, float f4) {
        if (string == null || string.equals("")) {
            return;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d, f3, f4);
        graphics2D.transform(affineTransform2);
        if (useDrawRotatedStringWorkaround) {
            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
            textLayout.draw(graphics2D, f, f2);
        } else {
            graphics2D.drawString(string, f, f2);
        }
        graphics2D.setTransform(affineTransform);
    }

    public static Shape calculateRotatedStringBounds(String string, Graphics2D graphics2D, float f, float f2, double d, float f3, float f4) {
        if (string == null || string.equals("")) {
            return null;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        Shape shape = affineTransform.createTransformedShape(rectangle2D);
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d, f3, f4);
        Shape shape2 = affineTransform2.createTransformedShape(shape);
        return shape2;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D graphics2D, String string, TextAnchor textAnchor) {
        float[] fArray = new float[2];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = graphics2D.getFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        Rectangle2D rectangle2D = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        float f = lineMetrics.getAscent();
        float f2 = f / 2.0f;
        float f3 = lineMetrics.getDescent();
        float f4 = lineMetrics.getLeading();
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (textAnchor == TextAnchor.TOP_CENTER || textAnchor == TextAnchor.CENTER || textAnchor == TextAnchor.BOTTOM_CENTER || textAnchor == TextAnchor.BASELINE_CENTER || textAnchor == TextAnchor.HALF_ASCENT_CENTER) {
            f5 = (float)(-rectangle2D.getWidth()) / 2.0f;
        } else if (textAnchor == TextAnchor.TOP_RIGHT || textAnchor == TextAnchor.CENTER_RIGHT || textAnchor == TextAnchor.BOTTOM_RIGHT || textAnchor == TextAnchor.BASELINE_RIGHT || textAnchor == TextAnchor.HALF_ASCENT_RIGHT) {
            f5 = (float)(-rectangle2D.getWidth());
        }
        if (textAnchor == TextAnchor.TOP_LEFT || textAnchor == TextAnchor.TOP_CENTER || textAnchor == TextAnchor.TOP_RIGHT) {
            f6 = -f3 - f4 + (float)rectangle2D.getHeight();
        } else if (textAnchor == TextAnchor.HALF_ASCENT_LEFT || textAnchor == TextAnchor.HALF_ASCENT_CENTER || textAnchor == TextAnchor.HALF_ASCENT_RIGHT) {
            f6 = f2;
        } else if (textAnchor == TextAnchor.CENTER_LEFT || textAnchor == TextAnchor.CENTER || textAnchor == TextAnchor.CENTER_RIGHT) {
            f6 = -f3 - f4 + (float)(rectangle2D.getHeight() / 2.0);
        } else if (textAnchor == TextAnchor.BASELINE_LEFT || textAnchor == TextAnchor.BASELINE_CENTER || textAnchor == TextAnchor.BASELINE_RIGHT) {
            f6 = 0.0f;
        } else if (textAnchor == TextAnchor.BOTTOM_LEFT || textAnchor == TextAnchor.BOTTOM_CENTER || textAnchor == TextAnchor.BOTTOM_RIGHT) {
            f6 = -lineMetrics.getDescent() - lineMetrics.getLeading();
        }
        fArray[0] = f5;
        fArray[1] = f6;
        return fArray;
    }

    private static float[] deriveRotationAnchorOffsets(Graphics2D graphics2D, String string, TextAnchor textAnchor) {
        float[] fArray = new float[2];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = graphics2D.getFont().getLineMetrics(string, fontRenderContext);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        float f = lineMetrics.getAscent();
        float f2 = f / 2.0f;
        float f3 = lineMetrics.getDescent();
        float f4 = lineMetrics.getLeading();
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (textAnchor == TextAnchor.TOP_LEFT || textAnchor == TextAnchor.CENTER_LEFT || textAnchor == TextAnchor.BOTTOM_LEFT || textAnchor == TextAnchor.BASELINE_LEFT || textAnchor == TextAnchor.HALF_ASCENT_LEFT) {
            f5 = 0.0f;
        } else if (textAnchor == TextAnchor.TOP_CENTER || textAnchor == TextAnchor.CENTER || textAnchor == TextAnchor.BOTTOM_CENTER || textAnchor == TextAnchor.BASELINE_CENTER || textAnchor == TextAnchor.HALF_ASCENT_CENTER) {
            f5 = (float)rectangle2D.getWidth() / 2.0f;
        } else if (textAnchor == TextAnchor.TOP_RIGHT || textAnchor == TextAnchor.CENTER_RIGHT || textAnchor == TextAnchor.BOTTOM_RIGHT || textAnchor == TextAnchor.BASELINE_RIGHT || textAnchor == TextAnchor.HALF_ASCENT_RIGHT) {
            f5 = (float)rectangle2D.getWidth();
        }
        if (textAnchor == TextAnchor.TOP_LEFT || textAnchor == TextAnchor.TOP_CENTER || textAnchor == TextAnchor.TOP_RIGHT) {
            f6 = f3 + f4 - (float)rectangle2D.getHeight();
        } else if (textAnchor == TextAnchor.CENTER_LEFT || textAnchor == TextAnchor.CENTER || textAnchor == TextAnchor.CENTER_RIGHT) {
            f6 = f3 + f4 - (float)(rectangle2D.getHeight() / 2.0);
        } else if (textAnchor == TextAnchor.HALF_ASCENT_LEFT || textAnchor == TextAnchor.HALF_ASCENT_CENTER || textAnchor == TextAnchor.HALF_ASCENT_RIGHT) {
            f6 = -f2;
        } else if (textAnchor == TextAnchor.BASELINE_LEFT || textAnchor == TextAnchor.BASELINE_CENTER || textAnchor == TextAnchor.BASELINE_RIGHT) {
            f6 = 0.0f;
        } else if (textAnchor == TextAnchor.BOTTOM_LEFT || textAnchor == TextAnchor.BOTTOM_CENTER || textAnchor == TextAnchor.BOTTOM_RIGHT) {
            f6 = lineMetrics.getDescent() + lineMetrics.getLeading();
        }
        fArray[0] = f5;
        fArray[1] = f6;
        return fArray;
    }

    public static void drawRotatedShape(Shape shape, Graphics2D graphics2D, float f, float f2, double d) {
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d, f, f2);
        graphics2D.transform(affineTransform2);
        graphics2D.draw(shape);
        graphics2D.setTransform(affineTransform);
    }

    public static Point2D getPointInRectangle(double d, double d2, Rectangle2D rectangle2D) {
        d = Math.max(rectangle2D.getMinX(), Math.min(d, rectangle2D.getMaxX()));
        d2 = Math.max(rectangle2D.getMinY(), Math.min(d2, rectangle2D.getMaxY()));
        return new Point2D.Double(d, d2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

