/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.logging.Logger;
import org.jboss.services.binding.DuplicateServiceException;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.ServiceConfig;
import org.jboss.services.binding.ServicesStore;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLServicesStore
implements ServicesStore {
    private final Logger log = Logger.getLogger(this.getClass());
    private Map servers = Collections.synchronizedMap(new HashMap());

    public void addService(String serverName, ObjectName serviceName, ServiceConfig config) throws DuplicateServiceException {
        throw new UnsupportedOperationException("XMLServiceStore is read-only");
    }

    public ServiceConfig getService(String serverName, ObjectName serviceName) {
        Map serverMap = (Map)this.servers.get(serverName);
        ServiceConfig config = null;
        if (serverMap != null) {
            config = (ServiceConfig)serverMap.get(serviceName);
        }
        return config;
    }

    public void removeService(String serverName, ObjectName serviceName) {
        throw new UnsupportedOperationException("XMLServiceStore is read-only");
    }

    public void load(URL cfgURL) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        InputStream cfgIS = cfgURL.openStream();
        Document configDoc = parser.parse(cfgIS, cfgURL.toString());
        Element serviceBindings = configDoc.getDocumentElement();
        NodeList servers = serviceBindings.getElementsByTagName("server");
        int length = servers.getLength();
        for (int s = 0; s < length; ++s) {
            Element server = (Element)servers.item(s);
            this.parseServer(server);
        }
    }

    public void store(URL cfgURL) throws Exception {
    }

    private void parseServer(Element server) throws Exception {
        String serverName = server.getAttribute("name");
        HashMap<ObjectName, ServiceConfig> serverConfigurations = new HashMap<ObjectName, ServiceConfig>();
        NodeList serviceConfigs = server.getElementsByTagName("service-config");
        int length = serviceConfigs.getLength();
        for (int c = 0; c < length; ++c) {
            Element config = (Element)serviceConfigs.item(c);
            ServiceConfig serviceConfig = new ServiceConfig();
            ObjectName serviceObjectName = this.parseConfig(config, serviceConfig);
            serverConfigurations.put(serviceObjectName, serviceConfig);
        }
        this.servers.put(serverName, serverConfigurations);
    }

    private ObjectName parseConfig(Element config, ServiceConfig serviceConfig) throws Exception {
        String serviceName = config.getAttribute("name");
        ObjectName serviceObjectName = new ObjectName(serviceName);
        serviceConfig.setServiceName(serviceName);
        String delegateClass = config.getAttribute("delegateClass");
        if (delegateClass.length() == 0) {
            delegateClass = "org.jboss.services.binding.AttributeMappingDelegate";
        }
        Element delegateConfig = null;
        NodeList delegateConfigs = config.getElementsByTagName("delegate-config");
        if (delegateConfigs.getLength() > 0) {
            delegateConfig = (Element)delegateConfigs.item(0);
        }
        serviceConfig.setServiceConfigDelegateClassName(delegateClass);
        serviceConfig.setServiceConfigDelegateConfig(delegateConfig);
        ArrayList<ServiceBinding> bindingsArray = new ArrayList<ServiceBinding>();
        NodeList bindings = config.getElementsByTagName("binding");
        int length = bindings.getLength();
        for (int b = 0; b < length; ++b) {
            Element binding = (Element)bindings.item(b);
            ServiceBinding sb = this.parseBinding(binding);
            bindingsArray.add(sb);
        }
        ServiceBinding[] tmp = new ServiceBinding[bindingsArray.size()];
        bindingsArray.toArray(tmp);
        serviceConfig.setBindings(tmp);
        return serviceObjectName;
    }

    private ServiceBinding parseBinding(Element binding) throws Exception {
        String portStr;
        String hostName;
        String name = binding.getAttribute("name");
        if (name != null) {
            name = StringPropertyReplacer.replaceProperties((String)name);
        }
        if ((hostName = binding.getAttribute("host")) != null) {
            hostName = StringPropertyReplacer.replaceProperties((String)hostName);
        }
        if (hostName.length() == 0) {
            hostName = null;
        }
        if ((portStr = binding.getAttribute("port")) != null) {
            portStr = StringPropertyReplacer.replaceProperties((String)portStr);
        }
        if (portStr.length() == 0) {
            portStr = "0";
        }
        this.log.debug((Object)("parseBinding, name='" + name + "', host='" + hostName + "'" + ", port='" + portStr + "'"));
        int port = Integer.parseInt(portStr);
        ServiceBinding sb = new ServiceBinding(name, hostName, port);
        return sb;
    }
}

