/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import java.io.StringReader;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.ServiceConfig;
import org.jboss.services.binding.ServicesConfigDelegate;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSLTConfigDelegate
implements ServicesConfigDelegate {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$services$binding$XSLTConfigDelegate == null ? (class$org$jboss$services$binding$XSLTConfigDelegate = XSLTConfigDelegate.class$("org.jboss.services.binding.XSLTConfigDelegate")) : class$org$jboss$services$binding$XSLTConfigDelegate));
    static /* synthetic */ Class class$org$jboss$services$binding$XSLTConfigDelegate;

    public void applyConfig(ServiceConfig config, MBeanServer server) throws Exception {
        Element delegateConfig = (Element)config.getServiceConfigDelegateConfig();
        if (delegateConfig == null) {
            throw new IllegalArgumentException("ServiceConfig.ServiceConfigDelegateConfig is null");
        }
        Element xslConfigElement = (Element)delegateConfig.getElementsByTagName("xslt-config").item(0);
        String configName = xslConfigElement.getAttribute("configName");
        Node xslContent = xslConfigElement.getFirstChild();
        if (configName.length() == 0) {
            throw new IllegalArgumentException("No valid configName attribute found");
        }
        ObjectName serviceName = new ObjectName(config.getServiceName());
        Element mbeanConfig = (Element)server.getAttribute(serviceName, configName);
        if (mbeanConfig == null) {
            log.debug((Object)("No value found for config attribute: " + configName));
            return;
        }
        String xslText = xslContent.getNodeValue();
        log.trace((Object)("XSL text:" + xslText));
        StreamSource xslSource = new StreamSource(new StringReader(xslText));
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(xslSource);
        ServiceBinding[] bindings = config.getBindings();
        if (bindings != null && bindings.length > 0) {
            int port = bindings[0].getPort();
            String host = bindings[0].getHostName();
            if (host != null) {
                transformer.setParameter("host", host);
                log.debug((Object)("set host parameter to:" + host));
            }
            transformer.setParameter("port", new Integer(port));
            log.debug((Object)("set port parameter to:" + port));
            NodeList attributes = delegateConfig.getElementsByTagName("xslt-param");
            for (int a = 0; a < attributes.getLength(); ++a) {
                Element attr = (Element)attributes.item(a);
                String name = attr.getAttribute("name");
                if (name.length() == 0) {
                    throw new IllegalArgumentException("attribute element #" + a + " has no name attribute");
                }
                String attrExp = MetaData.getElementContent((Element)attr);
                String attrValue = StringPropertyReplacer.replaceProperties((String)attrExp);
                transformer.setParameter(name, attrValue);
                log.debug((Object)("set " + name + " parameter to:" + attrValue));
            }
            DOMSource src = new DOMSource(mbeanConfig);
            DOMResult result = new DOMResult();
            transformer.transform(src, result);
            Document newMbeanDoc = (Document)result.getNode();
            Element newMbeanConfig = newMbeanDoc.getDocumentElement();
            log.debug((Object)("Updating DOM attribute to: " + newMbeanConfig));
            Attribute mbeanConfigAttr = new Attribute(configName, newMbeanConfig);
            server.setAttribute(serviceName, mbeanConfigAttr);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

