/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.encoding.ser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.jboss.axis.encoding.Serializer;
import org.jboss.axis.encoding.SerializerFactory;
import org.jboss.axis.encoding.ser.BaseFactory;
import org.jboss.axis.utils.Messages;

public abstract class BaseSerializerFactory
extends BaseFactory
implements SerializerFactory {
    static transient Vector mechanisms = null;
    protected Class serClass = null;
    protected QName xmlType = null;
    protected Class javaType = null;
    protected transient Serializer ser = null;
    protected transient Constructor serClassConstructor = null;
    protected transient Method getSerializer = null;

    public BaseSerializerFactory(Class serClass) {
        this.serClass = serClass;
    }

    public BaseSerializerFactory(Class serClass, QName xmlType, Class javaType) {
        this(serClass);
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.xml.rpc.encoding.Serializer getSerializerAs(String mechanismType) throws JAXRPCException {
        BaseSerializerFactory baseSerializerFactory = this;
        synchronized (baseSerializerFactory) {
            if (this.ser == null) {
                this.ser = this.getSerializerAsInternal(mechanismType);
            }
            return this.ser;
        }
    }

    protected Serializer getSerializerAsInternal(String mechanismType) throws JAXRPCException {
        Serializer serializer = this.getSpecialized(mechanismType);
        if (serializer == null) {
            serializer = this.getGeneralPurpose(mechanismType);
        }
        try {
            if (serializer == null) {
                serializer = (Serializer)this.serClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new JAXRPCException(Messages.getMessage("CantGetSerializer", this.serClass.getName()), (Throwable)e);
        }
        return serializer;
    }

    protected Serializer getGeneralPurpose(String mechanismType) {
        Constructor serClassConstructor;
        if (this.javaType != null && this.xmlType != null && (serClassConstructor = this.getSerClassConstructor()) != null) {
            try {
                return (Serializer)serClassConstructor.newInstance(this.javaType, this.xmlType);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private Constructor getConstructor(Class clazz) {
        try {
            return clazz.getConstructor(Class.class, QName.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected Serializer getSpecialized(String mechanismType) {
        if (this.javaType != null && this.xmlType != null && this.getSerializer != null) {
            try {
                return (Serializer)this.getSerializer.invoke(null, mechanismType, this.javaType, this.xmlType);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    public Iterator getSupportedMechanismTypes() {
        if (mechanisms == null) {
            mechanisms = new Vector();
            mechanisms.add("Axis SAX Mechanism");
        }
        return mechanisms.iterator();
    }

    public QName getXMLType() {
        return this.xmlType;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public static SerializerFactory createFactory(Class factory, Class javaType, QName xmlType) {
        SerializerFactory sf = null;
        try {
            Method method = factory.getMethod("create", Class.class, QName.class);
            sf = (SerializerFactory)method.invoke(null, javaType, xmlType);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (sf == null) {
            try {
                Constructor constructor = factory.getConstructor(Class.class, QName.class);
                sf = (SerializerFactory)constructor.newInstance(javaType, xmlType);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (sf == null) {
            try {
                sf = (SerializerFactory)factory.newInstance();
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return sf;
    }

    protected Method getGetSerializer() {
        if (this.getSerializer == null) {
            this.getSerializer = this.getMethod(this.javaType, "getSerializer");
        }
        return this.getSerializer;
    }

    protected Constructor getSerClassConstructor() {
        if (this.serClassConstructor == null) {
            this.serClassConstructor = this.getConstructor(this.serClass);
        }
        return this.serClassConstructor;
    }
}

