#!/bin/sh
USERADD_PROC="/usr/sbin/useradd"
EXPECT_PROC="/usr/bin/expect"
PASSWD_PROC="/usr/bin/passwd"

##
## 引数格納
##
while [ $# -gt 0 ] 
do
#echo $1
case $1 in
  -u)
    shift
    uid="-u $1" 
    ;;
  -p)
    shift
    pass=$1 
    ;;
  -g)
    shift
    group="-g $1" 
    ;;
  -G)
    shift
    secondarygroup="-G $1" 
    ;;
  -s)
    shift
    shell="-s $1" 
    ;;
  -d)
    shift
    home="-d $1" 
    ;;
  *)
    username=$1
    ;;
esac

shift 


done

##
## ユーザ登録
##
echo "$USERADD_PROC $uid $group $secondarygroup $shell $home $username"
$USERADD_PROC $uid $group $secondarygroup $shell $home $username
if [ $? -ne 0 ] ; then
    exit 3
fi

##
##　パスワード設定
##
if [ ${#pass} -eq 0 ] ; then
    exit 1
fi

$EXPECT_PROC -c "
    spawn -noecho $PASSWD_PROC $username
    expect *password:
    send_user \r
    send $pass\r
    expect *password:
    send_user \r
    send $pass\r
    expect {
	eof	{exit}
	timeout {exit 2}
    } 2&> /dev/null
"
#echo "passret $?"
exit

