/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.view;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.composite.RealtimeGraphComposite;
import com.clustercontrol.performance.composite.action.RealtimeSetGraphSelectionChangedListener;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.RealtimeCollectThread;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.view.ScopeListBaseView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jfree.data.time.TimeSeries;

public class RealtimeGraphView
extends ScopeListBaseView {
    public static final String ID = "com.clustercontrol.performance.view.RealtimeGraphView";
    private Composite parent;
    public RealtimeGraphComposite graphComposite = null;
    public RealtimeCollectorInfo collectorInfo;
    public RealtimeCollectorItemInfo collectorItemInfo;
    static boolean isRequestCollectorToRun = false;
    public static RealtimeCollectThread collector = null;
    private boolean check = true;

    public RealtimeGraphView() {
        this.initialize();
    }

    private void initialize() {
        this.collectorInfo = new RealtimeCollectorInfo();
        this.collectorItemInfo = new RealtimeCollectorItemInfo();
        this.collectorInfo.setGraphPlotNum(12);
        this.collectorItemInfo.setItemInfo(0, "00000000", "NonDisplay", "0", "0", null, true);
        this.collectorItemInfo.setItemInfo(1, "00000000", "NonDisplay", "0", "0", null, true);
        this.collectorItemInfo.setItemInfo(2, "00000000", "NonDisplay", "0", "0", null, true);
        this.collectorItemInfo.setItemInfo(3, "00000000", "NonDisplay", "0", "0", null, true);
        String[] itemCodeList = CollectorItemCodeFactory.getCodeAll();
        int itemCodeNum = 0;
        int i = 0;
        while (i < itemCodeList.length) {
            if (!CollectorItemCodeFactory.isDeviceSupport(itemCodeList[i])) {
                ++itemCodeNum;
            }
            ++i;
        }
        int j = 0;
        this.collectorItemInfo.createItemInfoForCollector(itemCodeNum);
        int i2 = 0;
        while (i2 < itemCodeList.length) {
            if (!CollectorItemCodeFactory.isDeviceSupport(itemCodeList[i2])) {
                boolean isDetailed = true;
                List factorySubItemCodeList = CollectorItemCodeFactory.getSubItemCode(itemCodeList[i2]);
                if (factorySubItemCodeList == null || factorySubItemCodeList.size() == 0) {
                    isDetailed = false;
                }
                this.collectorItemInfo.setItemInfoForCollector(j, itemCodeList[i2], "0", "0", null, isDetailed);
                ++j;
            }
            ++i2;
        }
    }

    protected Composite createListContents(Composite parent) {
        this.parent = parent;
        GridLayout layout = new GridLayout(1, true);
        this.parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        super.getScopeTreeComposite().getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)new RealtimeSetGraphSelectionChangedListener());
        this.update();
        return this.graphComposite;
    }

    protected void doSelectTreeItem(FacilityTreeItem item) {
        if (!(item.getData().getFacilityId() == null || "".equals(item.getData().getFacilityId()) || this.collectorInfo.getFacilityId() != null && this.collectorInfo.getFacilityId().equals(item.getData().getFacilityId()))) {
            int i;
            this.collectorInfo.setFacilityId(item.getData().getFacilityId());
            this.collectorInfo.setSubScopeNum(item.getChildren().length);
            List itemList = CollectorItemCodeFactory.getAvailableCollectorItemList(item.getData().getFacilityId());
            if (itemList != null) {
                this.collectorItemInfo.createItemInfoForCollector(itemList.size());
                i = 0;
                while (i < itemList.size()) {
                    CollectorItemInfo itemInfo = (CollectorItemInfo)itemList.get(i);
                    boolean isDetailed = true;
                    List factorySubItemCodeList = CollectorItemCodeFactory.getSubItemCode(itemInfo.getCollectorItemCode());
                    if (factorySubItemCodeList == null || factorySubItemCodeList.size() == 0) {
                        isDetailed = false;
                    }
                    this.collectorItemInfo.setItemInfoForCollector(i, itemInfo.getCollectorItemCode(), Integer.toString(itemInfo.getDeviceIndex()), Integer.toString(itemInfo.getCollectorItemID()), itemInfo.getDeviceName(), isDetailed);
                    ++i;
                }
            }
            i = 0;
            while (i < this.collectorInfo.getGraphNum()) {
                if (this.collectorItemInfo.getDeviceName(i) != null) {
                    boolean found = false;
                    int j = 0;
                    while (j < this.collectorItemInfo.getItemNumForCollector()) {
                        if (this.collectorItemInfo.getItemCode(i).equals(this.collectorItemInfo.getItemCodeForCollector(j)) && this.collectorItemInfo.getDeviceName(i).equals(this.collectorItemInfo.getDeviceNameForCollector(j))) {
                            this.collectorItemInfo.setItemId(i, Integer.toString(j));
                            found = true;
                            if (this.collectorItemInfo.hasDevice(i)) break;
                            this.collectorItemInfo.setHasDevice(i, true);
                            this.collectorItemInfo.setItemId(i, Integer.toString(j));
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        this.collectorItemInfo.setHasDevice(i, false);
                    }
                }
                ++i;
            }
            FacilityTreeItem[] childrenList = item.getChildren();
            Arrays.sort(childrenList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof FacilityTreeItem && o2 instanceof FacilityTreeItem) {
                        String object1 = ((FacilityTreeItem)o1).getData().getFacilityId();
                        String object2 = ((FacilityTreeItem)o2).getData().getFacilityId();
                        return object1.compareTo(object2);
                    }
                    return 0;
                }
            });
            if (item.getChildren().length > 0) {
                ArrayList<String> subScopeFacilityId = new ArrayList<String>();
                ArrayList<String> subScopeFacilityName = new ArrayList<String>();
                int i2 = 0;
                while (i2 < childrenList.length) {
                    subScopeFacilityId.add(childrenList[i2].getData().getFacilityId());
                    subScopeFacilityName.add(childrenList[i2].getData().getFacilityName());
                    ++i2;
                }
                this.collectorInfo.setSubScopeFacilityId(subScopeFacilityId);
                this.collectorInfo.setSubScopeFacilityName(subScopeFacilityName);
            }
            this.update();
        }
    }

    public synchronized void update() {
        Date timestamp = new Date(System.currentTimeMillis());
        int timestampId = this.collectorInfo.setCurrentCollect(timestamp);
        this.prepareToUpdate(timestamp, timestampId);
    }

    private void prepareToUpdate(Date timestamp, int timestampId) {
        if (this.collectorInfo.isCurrentCollect(timestamp, timestampId)) {
            this.graphUpdate(timestamp, timestampId);
        }
    }

    private void graphUpdate(Date timestamp, int timestampId) {
        int interval = this.collectorInfo.getInterval();
        isRequestCollectorToRun = false;
        if (interval != 0 && this.collectorInfo.getFacilityId() != null) {
            boolean isXRangeAuto = false;
            if (this.collectorInfo.getGraphPlotNum() == 0) {
                isXRangeAuto = true;
            }
            if (this.graphComposite != null) {
                this.graphComposite.dispose();
            }
            this.graphComposite = new RealtimeGraphComposite(this.parent, 0);
            this.graphComposite.setCollectorInfo(this.collectorInfo);
            this.graphComposite.setCollectorItemInfo(this.collectorItemInfo);
            GridData baseGridData = new GridData();
            baseGridData.horizontalAlignment = 4;
            baseGridData.verticalAlignment = 4;
            baseGridData.grabExcessHorizontalSpace = true;
            baseGridData.grabExcessVerticalSpace = true;
            this.graphComposite.setLayoutData(baseGridData);
            GridLayout baseLayout = new GridLayout(1, true);
            this.graphComposite.setLayout((Layout)baseLayout);
            baseLayout.marginHeight = 0;
            baseLayout.marginWidth = 0;
            int graphNum = this.collectorInfo.getGraphNum();
            String facilityId = this.collectorInfo.getFacilityId();
            int i = 0;
            while (i < graphNum) {
                String itemCode = this.collectorItemInfo.getItemCode(i);
                String itemId = this.collectorItemInfo.getItemId(i);
                String deviceName = this.collectorItemInfo.getDeviceName(i);
                String displayType = this.collectorItemInfo.getDisplayType(i);
                int graphPlotNum = this.collectorInfo.getGraphPlotNum();
                int deviceIndex = Integer.valueOf(this.collectorItemInfo.getDeviceIndex(i));
                this.graphComposite.addGraph(i, itemCode, deviceName, this.collectorInfo.getSubScopeNum(), displayType, interval, isXRangeAuto, graphPlotNum);
                this.collectorItemInfo.setIsCollect(i, this.graphComposite.isCollect());
                if (this.graphComposite.isCollect()) {
                    this.setCollector(timestamp, timestampId, itemCode, itemId, deviceIndex, displayType, interval, facilityId);
                }
                ++i;
            }
            if (!isRequestCollectorToRun) {
                // empty if block
            }
            SashForm treeSash = this.getTreeSash();
            treeSash.setWeights(new int[]{29, 71});
            treeSash.setWeights(new int[]{30, 70});
        }
    }

    private void setCollector(Date timestamp, int collectTimestampId, String itemCode, String itemId, int deviceIndex, String displayType, int interval, String facilityId) {
        int requestInterval = this.collectorInfo.getRequestInterval();
        TimeSeries[] cfr_ignored_0 = this.graphComposite.m_timeseries;
        collector = new RealtimeCollectThread(timestamp, collectTimestampId, this.graphComposite.m_timeseries, itemCode, itemId, deviceIndex, displayType, interval, requestInterval, facilityId, this.check, this.graphComposite);
        collector.setCollectorInfo(this.collectorInfo);
        collector.start();
    }

    public void dispose() {
        super.dispose();
    }

    public void setEnabledAction(int type, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.performance.view.action.RealtimeSetGraphAction", selection);
        super.setEnabledAction("com.clustercontrol.performance.view.action.RealtimeSetGraphAction2", selection);
        super.setEnabledAction("com.clustercontrol.performance.view.action.RealtimeSetGraphAction", false);
        super.setEnabledAction("com.clustercontrol.performance.view.action.RealtimeSetGraphAction2", false);
        if (type != 2) {
            if (type == 0) {
                super.setEnabledAction("com.clustercontrol.performance.view.action.RealtimeSetGraphAction", true);
                super.setEnabledAction("com.clustercontrol.performance.view.action.RealtimeSetGraphAction2", true);
            } else if (type == 1) {
                super.setEnabledAction("com.clustercontrol.performance.view.action.RealtimeSetGraphAction", true);
                super.setEnabledAction("com.clustercontrol.performance.view.action.RealtimeSetGraphAction2", true);
            }
        }
    }
}

