/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.action.GetFacilityTree;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.FacilityTreeContentProvider;
import com.clustercontrol.composite.FacilityTreeLabelProvider;
import com.clustercontrol.composite.FacilityTreeViewerSorter;
import com.clustercontrol.etc.action.UpdateFacilityTreeTask;
import com.clustercontrol.util.UpdateRepositoryInfoReceiveTopic;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class FacilityTreeComposite
extends Composite {
    protected TreeViewer treeViewer = null;
    protected FacilityTreeItem selectItem = null;
    protected int subScopeNumber;
    protected boolean scopeOnly;
    protected UpdateRepositoryInfoReceiveTopic updateRepository = null;

    public FacilityTreeComposite(Composite parent, int style) {
        super(parent, style);
        this.scopeOnly = false;
        this.createContents();
    }

    public FacilityTreeComposite(Composite parent, int style, boolean scopeOnly) {
        super(parent, style);
        this.scopeOnly = scopeOnly;
        this.createContents();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public Tree getTree() {
        return this.treeViewer.getTree();
    }

    public FacilityTreeItem getSelectItem() {
        return this.selectItem;
    }

    public int getSubScopeNumber() {
        return this.subScopeNumber;
    }

    protected void createContents() {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Tree tree = new Tree((Composite)this, 2052);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)layoutData);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new FacilityTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new FacilityTreeLabelProvider());
        this.treeViewer.setSorter((ViewerSorter)new FacilityTreeViewerSorter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                FacilityTreeComposite.this.selectItem = (FacilityTreeItem)selection.getFirstElement();
                if (FacilityTreeComposite.this.selectItem instanceof FacilityTreeItem) {
                    FacilityTreeComposite.this.subScopeNumber = FacilityTreeComposite.this.selectItem.getChildren().length;
                }
            }
        });
        this.updateRepository = new UpdateRepositoryInfoReceiveTopic(this.getDisplay(), new UpdateFacilityTreeTask(this));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FacilityTreeComposite.this.updateRepository != null) {
                    FacilityTreeComposite.this.updateRepository.terminate();
                }
            }
        });
        this.update();
    }

    public void update() {
        GetFacilityTree getFacilityTree = new GetFacilityTree();
        FacilityTreeItem treeItem = getFacilityTree.getTreeItem(this.scopeOnly);
        if (treeItem != null) {
            this.treeViewer.setInput((Object)treeItem);
            FacilityTreeItem[] selectItem = treeItem.getChildren();
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)selectItem[0]), true);
        }
        this.treeViewer.expandToLevel(2);
    }

    public void setExpand(boolean isExpand) {
        if (isExpand) {
            this.treeViewer.setAutoExpandLevel(-1);
        }
    }

    public void setScopeTree(FacilityTreeItem treeItem) {
        try {
            this.treeViewer.setInput((Object)treeItem);
            this.treeViewer.setAutoExpandLevel(-1);
        }
        catch (Exception exception) {}
    }

    public void setScopeTreeWithSelection(FacilityTreeItem treeItem, String facilityID) {
        this.setScopeTree(treeItem);
        FacilityTreeItem[] tmpItem = treeItem.getChildren();
        int i = 0;
        while (i < tmpItem.length) {
            this.setScopeTreeWithSelectionSub(tmpItem[i], facilityID);
            if (facilityID.equals(tmpItem[i].getData().getFacilityId())) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)tmpItem[i]), true);
            }
            ++i;
        }
    }

    public void setScopeTreeWithSelectionSub(FacilityTreeItem treeItem, String facilityID) {
        FacilityTreeItem[] tmpItem = treeItem.getChildren();
        int i = 0;
        while (i < tmpItem.length) {
            this.setScopeTreeWithSelectionSub(tmpItem[i], facilityID);
            if (facilityID.equals(tmpItem[i].getData().getFacilityId())) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)tmpItem[i]), true);
            }
            ++i;
        }
    }
}

