/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.util;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.repository.message.UpdateRepositoryInfo;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingContextFactory;

public class UpdateRepositoryInfoReceiveTopic
implements MessageListener,
ExceptionListener {
    private static final String TOPIC_CON_FACTORY = "ConnectionFactory";
    private static final String KEY_EJB_URL = "ejbUrl";
    private static final String VALUE_EJB_URL = "jnp://localhost:1099";
    private static final long RETRY_INTERVAL = 10000L;
    private TopicConnectionFactory m_factory;
    protected TopicConnection m_con;
    protected Topic m_topic;
    protected TopicSession m_session;
    protected TopicSubscriber m_subscriber;
    protected Runnable m_repositoryUpdate;
    protected Display m_display;
    private boolean m_errFlg = false;
    protected Timer m_timer = new Timer(true);

    public UpdateRepositoryInfoReceiveTopic(Display display, Runnable repositoryUpdate) {
        this.m_display = display;
        this.m_repositoryUpdate = repositoryUpdate;
        this.initial();
    }

    public void onMessage(Message message) {
        Serializable obj;
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            try {
                obj = objectMessage.getObject();
            }
            catch (JMSException jMSException) {
                return;
            }
            if (!(obj instanceof UpdateRepositoryInfo)) {
                return;
            }
        } else {
            return;
        }
        UpdateRepositoryInfo cfr_ignored_0 = (UpdateRepositoryInfo)obj;
        this.m_display.syncExec(this.m_repositoryUpdate);
    }

    public void onException(JMSException arg0) {
        this.setErrFlg(true);
    }

    private synchronized void setErrFlg(boolean errFlg) {
        if (!this.m_errFlg && errFlg) {
            this.m_timer.schedule((TimerTask)new ReSetupTask(), 10000L, 10000L);
        }
        this.m_errFlg = errFlg;
    }

    private synchronized boolean isErrFlg() {
        return this.m_errFlg;
    }

    private synchronized boolean reInitial() {
        boolean ret = false;
        this.terminate();
        if (this.initial()) {
            ret = true;
            this.setErrFlg(false);
        }
        return ret;
    }

    public void terminate() {
        this.terminateSumscriber();
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
        catch (JMSException jMSException) {}
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (JMSException jMSException) {}
    }

    private void terminateSumscriber() {
        try {
            if (this.m_subscriber != null) {
                this.m_subscriber.close();
            }
        }
        catch (JMSException jMSException) {}
    }

    private boolean initial() {
        NamingContext con = null;
        try {
            try {
                String url = this.getUrl();
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("java.naming.provider.url", url);
                NamingContextFactory ncf = new NamingContextFactory();
                con = (NamingContext)ncf.getInitialContext(props);
                this.m_factory = (TopicConnectionFactory)con.lookup(TOPIC_CON_FACTORY);
                this.m_con = this.m_factory.createTopicConnection();
                this.m_session = this.m_con.createTopicSession(false, 1);
                this.m_topic = (Topic)con.lookup("topic/clustercontrol/Repository/update");
                this.m_con.setExceptionListener((ExceptionListener)this);
                this.m_con.start();
                this.initialTopic();
            }
            catch (Exception exception) {
                this.setErrFlg(true);
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception exception2) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception exception) {}
        return true;
    }

    private String getUrl() {
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        String url = store.getString(KEY_EJB_URL);
        if (url.compareTo("") == 0) {
            url = VALUE_EJB_URL;
        }
        return url;
    }

    private boolean initialTopic() {
        this.terminateSumscriber();
        try {
            this.m_subscriber = this.m_session.createSubscriber(this.m_topic);
            this.m_subscriber.setMessageListener((MessageListener)this);
        }
        catch (Exception exception) {
            this.setErrFlg(true);
            return false;
        }
        return true;
    }

    protected class ReSetupTask
    extends TimerTask {
        protected ReSetupTask() {
        }

        public void run() {
            if (UpdateRepositoryInfoReceiveTopic.this.reInitial()) {
                this.cancel();
            }
        }
    }
}

