/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.internal.operations.PatchCleaner;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IFeatureOperation;

public abstract class FeatureOperation
extends Operation
implements IFeatureOperation {
    protected IFeature feature;
    protected IFeature oldFeature;
    protected IConfiguredSite targetSite;

    public FeatureOperation(IConfiguredSite targetSite, IFeature feature) {
        this.feature = feature;
        this.targetSite = targetSite;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public IFeature getOldFeature() {
        return this.oldFeature;
    }

    public IConfiguredSite getTargetSite() {
        return this.targetSite;
    }

    public void setTargetSite(IConfiguredSite targetSite) {
        this.targetSite = targetSite;
    }

    static boolean unconfigure(IFeature feature, IConfiguredSite site) throws CoreException {
        IInstallConfiguration config = SiteManager.getLocalSite().getCurrentConfiguration();
        if (site == null) {
            site = UpdateUtils.getConfigSite(feature, config);
        }
        if (site != null) {
            PatchCleaner cleaner = new PatchCleaner(site, feature);
            boolean result = site.unconfigure(feature);
            cleaner.dispose();
            return result;
        }
        return false;
    }
}

