/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmp;

import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SnmpPlugin
extends AbstractUIPlugin {
    private static SnmpPlugin plugin;
    private ResourceBundle resourceBundle = null;

    public static SnmpPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = SnmpPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getResourceString(String key, Object[] arguments) {
        ResourceBundle bundle = SnmpPlugin.getDefault().getResourceBundle();
        try {
            String message = bundle != null ? bundle.getString(key) : key;
            return MessageFormat.format(message, arguments);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static void log(String message, Exception e) {
        Status status = new Status(4, SnmpPlugin.getPluginId(), 4, message, (Throwable)e);
        SnmpPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        SnmpPlugin.log(message, null);
    }

    public static void log(Exception e) {
        StringWriter stringWriter = new StringWriter();
        String message = stringWriter.getBuffer().toString();
        SnmpPlugin.log(message, e);
    }

    public static String getPluginId() {
        return SnmpPlugin.getDefault().getBundle().getSymbolicName();
    }

    public SnmpPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.clustercontrol.snmp.SnmpPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

