/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil2.msgs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.il.uil2.msgs.BaseMsg;

public class ReceiveMsg
extends BaseMsg {
    private int subscriberID;
    private long wait;
    private SpyMessage msg;

    public ReceiveMsg() {
        this(0, 0L);
    }

    public ReceiveMsg(int subscriberID, long wait) {
        super(13);
        this.subscriberID = subscriberID;
        this.wait = wait;
    }

    public int getSubscriberID() {
        return this.subscriberID;
    }

    public long getWait() {
        return this.wait;
    }

    public SpyMessage getMessage() {
        return this.msg;
    }

    public void setMessage(SpyMessage msg) {
        this.msg = msg;
    }

    public void write(ObjectOutputStream out) throws IOException {
        super.write(out);
        out.writeInt(this.subscriberID);
        out.writeLong(this.wait);
        out.writeByte(this.msg != null ? 1 : 0);
        if (this.msg != null) {
            SpyMessage.writeMessage(this.msg, out);
        }
    }

    public void read(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.read(in);
        this.subscriberID = in.readInt();
        this.wait = in.readLong();
        byte hasMsg = in.readByte();
        if (hasMsg == 1) {
            this.msg = SpyMessage.readMessage(in);
        }
    }
}

