/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecorationBuilder;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;
import org.eclipse.ui.internal.decorators.OverlayCache;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.Util;

class LightweightDecoratorManager {
    private LightweightRunnable runnable = new LightweightRunnable();
    private LightweightDecoratorDefinition[] lightweightDefinitions;
    private static final LightweightDecoratorDefinition[] EMPTY_LIGHTWEIGHT_DEF = new LightweightDecoratorDefinition[0];
    private OverlayCache overlayCache = new OverlayCache();

    LightweightDecoratorManager(LightweightDecoratorDefinition[] definitions) {
        this.lightweightDefinitions = definitions;
    }

    LightweightDecoratorDefinition[] getDefinitions() {
        return this.lightweightDefinitions;
    }

    public boolean addDecorator(LightweightDecoratorDefinition decorator) {
        if (this.getLightweightDecoratorDefinition(decorator.getId()) == null) {
            LightweightDecoratorDefinition[] oldDefs = this.lightweightDefinitions;
            this.lightweightDefinitions = new LightweightDecoratorDefinition[this.lightweightDefinitions.length + 1];
            System.arraycopy(oldDefs, 0, this.lightweightDefinitions, 0, oldDefs.length);
            this.lightweightDefinitions[oldDefs.length] = decorator;
            return true;
        }
        return false;
    }

    public boolean removeDecorator(LightweightDecoratorDefinition decorator) {
        int idx = this.getLightweightDecoratorDefinitionIdx(decorator.getId());
        if (idx != -1) {
            Object[] oldDefs = this.lightweightDefinitions;
            this.lightweightDefinitions = new LightweightDecoratorDefinition[this.lightweightDefinitions.length - 1];
            Util.arrayCopyWithRemoval(oldDefs, this.lightweightDefinitions, idx);
            return true;
        }
        return false;
    }

    private LightweightDecoratorDefinition getLightweightDecoratorDefinition(String decoratorId) {
        int idx = this.getLightweightDecoratorDefinitionIdx(decoratorId);
        if (idx != -1) {
            return this.lightweightDefinitions[idx];
        }
        return null;
    }

    private int getLightweightDecoratorDefinitionIdx(String decoratorId) {
        int i = 0;
        while (i < this.lightweightDefinitions.length) {
            if (this.lightweightDefinitions[i].getId().equals(decoratorId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    LightweightDecoratorDefinition[] enabledDefinitions() {
        ArrayList<LightweightDecoratorDefinition> result = new ArrayList<LightweightDecoratorDefinition>();
        int i = 0;
        while (i < this.lightweightDefinitions.length) {
            if (this.lightweightDefinitions[i].isEnabled()) {
                result.add(this.lightweightDefinitions[i]);
            }
            ++i;
        }
        LightweightDecoratorDefinition[] returnArray = new LightweightDecoratorDefinition[result.size()];
        result.toArray(returnArray);
        return returnArray;
    }

    boolean hasEnabledDefinitions() {
        int i = 0;
        while (i < this.lightweightDefinitions.length) {
            if (this.lightweightDefinitions[i].isEnabled()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void reset() {
        this.runnable.clearReferences();
    }

    void shutdown() {
        int i = 0;
        while (i < this.lightweightDefinitions.length) {
            if (this.lightweightDefinitions[i].isEnabled()) {
                this.lightweightDefinitions[i].setEnabled(false);
            }
            ++i;
        }
        this.overlayCache.disposeAll();
    }

    LightweightDecoratorDefinition getDecoratorDefinition(String decoratorId) {
        int i = 0;
        while (i < this.lightweightDefinitions.length) {
            if (this.lightweightDefinitions[i].getId().equals(decoratorId)) {
                return this.lightweightDefinitions[i];
            }
            ++i;
        }
        return null;
    }

    LightweightDecoratorDefinition[] getDecoratorsFor(Object element) {
        if (element == null) {
            return EMPTY_LIGHTWEIGHT_DEF;
        }
        Collection decorators = DecoratorManager.getDecoratorsFor(element, this.enabledDefinitions());
        LightweightDecoratorDefinition[] decoratorArray = EMPTY_LIGHTWEIGHT_DEF;
        if (decorators.size() > 0) {
            decoratorArray = new LightweightDecoratorDefinition[decorators.size()];
            decorators.toArray(decoratorArray);
        }
        return decoratorArray;
    }

    void getDecorations(Object element, DecorationBuilder decoration, boolean adaptableDecoration) {
        LightweightDecoratorDefinition[] decorators = this.getDecoratorsFor(element);
        int i = 0;
        while (i < decorators.length) {
            if (!adaptableDecoration || decorators[i].isAdaptable()) {
                decoration.setCurrentDefinition(decorators[i]);
                this.decorate(element, decoration, decorators[i]);
            }
            ++i;
        }
    }

    private void decorate(Object element, DecorationBuilder decoration, LightweightDecoratorDefinition decorator) {
        this.runnable.setValues(element, decoration, decorator);
        Platform.run((ISafeRunnable)this.runnable);
    }

    OverlayCache getOverlayCache() {
        return this.overlayCache;
    }

    private class LightweightRunnable
    implements ISafeRunnable {
        private Object element;
        private DecorationBuilder decoration;
        private LightweightDecoratorDefinition decorator;

        LightweightRunnable() {
        }

        void setValues(Object object, DecorationBuilder builder, LightweightDecoratorDefinition definition) {
            this.element = object;
            this.decoration = builder;
            this.decorator = definition;
        }

        public void handleException(Throwable exception) {
            IStatus status = StatusUtil.newStatus(4, exception.getMessage(), exception);
            WorkbenchPlugin.log("Exception in Decorator", status);
            if (this.decorator != null) {
                this.decorator.crashDisable();
            }
        }

        public void run() throws Exception {
            this.decorator.decorate(this.element, this.decoration);
        }

        void clearReferences() {
            this.decorator = null;
        }
    }
}

