/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IDEWorkspacePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button autoBuildButton;
    private Button autoSaveAllButton;
    private IntegerFieldEditor saveInterval;
    private Button autoRefreshButton;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.ide.workspace_preference_page_context");
        Composite composite = this.createComposite(parent);
        PreferenceLinkArea area = new PreferenceLinkArea(composite, 0, "org.eclipse.ui.preferencePages.Startup", IDEWorkbenchMessages.IDEWorkspacePreferencePage_WorkbenchPreference_relatedLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData data = new GridData(768);
        area.getControl().setLayoutData((Object)data);
        Label space = new Label(composite, 0);
        space.setLayoutData((Object)new GridData());
        this.createAutoBuildPref(composite);
        this.createSaveAllBeforeBuildPref(composite);
        IDEWorkspacePreferencePage.createSpace(composite);
        this.createSaveIntervalGroup(composite);
        IDEWorkspacePreferencePage.createSpace(composite);
        this.createAutoRefreshControls(composite);
        this.applyDialogFont(composite);
        return composite;
    }

    protected void createSaveAllBeforeBuildPref(Composite composite) {
        this.autoSaveAllButton = new Button(composite, 32);
        this.autoSaveAllButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_savePriorToBuilding);
        this.autoSaveAllButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_savePriorToBuildingToolTip);
        this.autoSaveAllButton.setSelection(this.getIDEPreferenceStore().getBoolean("SAVE_ALL_BEFORE_BUILD"));
    }

    protected void createAutoBuildPref(Composite composite) {
        this.autoBuildButton = new Button(composite, 32);
        this.autoBuildButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_autobuild);
        this.autoBuildButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_autobuildToolTip);
        this.autoBuildButton.setSelection(ResourcesPlugin.getWorkspace().isAutoBuilding());
    }

    private void createSaveIntervalGroup(Composite composite) {
        Composite groupComposite = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        groupComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupComposite.setLayoutData((Object)gd);
        this.saveInterval = new IntegerFieldEditor("saveInterval", IDEWorkbenchMessages.WorkbenchPreference_saveInterval, groupComposite);
        this.saveInterval.setPreferenceStore(this.getIDEPreferenceStore());
        this.saveInterval.setPage((DialogPage)this);
        this.saveInterval.setTextLimit(Integer.toString(9999).length());
        this.saveInterval.setErrorMessage(NLS.bind((String)IDEWorkbenchMessages.WorkbenchPreference_saveIntervalError, (Object)new Integer(9999)));
        this.saveInterval.setValidateStrategy(0);
        this.saveInterval.setValidRange(1, 9999);
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        long interval = description.getSnapshotInterval() / 60000L;
        this.saveInterval.setStringValue(Long.toString(interval));
        this.saveInterval.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    IDEWorkspacePreferencePage.this.setValid(IDEWorkspacePreferencePage.this.saveInterval.isValid());
                }
            }
        });
    }

    private void createAutoRefreshControls(Composite parent) {
        this.autoRefreshButton = new Button(parent, 32);
        this.autoRefreshButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_RefreshButtonText);
        this.autoRefreshButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_RefreshButtonToolTip);
        boolean autoRefresh = ResourcesPlugin.getPlugin().getPluginPreferences().getBoolean("refresh.enabled");
        this.autoRefreshButton.setSelection(autoRefresh);
    }

    protected IPreferenceStore getIDEPreferenceStore() {
        return IDEWorkbenchPlugin.getDefault().getPreferenceStore();
    }

    protected static void createSpace(Composite parent) {
        Label vfiller = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        vfiller.setLayoutData((Object)gridData);
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        boolean autoBuild = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultBoolean("description.autobuilding");
        this.autoBuildButton.setSelection(autoBuild);
        IPreferenceStore store = this.getIDEPreferenceStore();
        this.autoSaveAllButton.setSelection(store.getDefaultBoolean("SAVE_ALL_BEFORE_BUILD"));
        this.saveInterval.loadDefault();
        boolean autoRefresh = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultBoolean("refresh.enabled");
        this.autoRefreshButton.setSelection(autoRefresh);
        super.performDefaults();
    }

    public boolean performOk() {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        if (this.autoBuildButton.getSelection() != ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            try {
                description.setAutoBuilding(this.autoBuildButton.getSelection());
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Error changing auto build workspace setting.", e.getStatus());
            }
        }
        IPreferenceStore store = this.getIDEPreferenceStore();
        store.setValue("SAVE_ALL_BEFORE_BUILD", this.autoSaveAllButton.getSelection());
        long oldSaveInterval = description.getSnapshotInterval() / 60000L;
        long newSaveInterval = new Long(this.saveInterval.getStringValue());
        if (oldSaveInterval != newSaveInterval) {
            try {
                description.setSnapshotInterval(newSaveInterval * 60000L);
                ResourcesPlugin.getWorkspace().setDescription(description);
                store.firePropertyChangeEvent("saveInterval", (Object)new Integer((int)oldSaveInterval), (Object)new Integer((int)newSaveInterval));
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Error changing save interval preference", e.getStatus());
            }
        }
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        boolean autoRefresh = this.autoRefreshButton.getSelection();
        preferences.setValue("refresh.enabled", autoRefresh);
        return super.performOk();
    }
}

