/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.headerfooter;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfPageNumber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfHeaderFooter
extends HeaderFooter
implements RtfBasicElement {
    public static final int TYPE_HEADER = 1;
    public static final int TYPE_FOOTER = 2;
    public static final int DISPLAY_FIRST_PAGE = 0;
    public static final int DISPLAY_ALL_PAGES = 1;
    public static final int DISPLAY_LEFT_PAGES = 2;
    public static final int DISPLAY_RIGHT_PAGES = 4;
    private static final byte[] HEADER_ALL = "\\header".getBytes();
    private static final byte[] HEADER_FIRST = "\\headerf".getBytes();
    private static final byte[] HEADER_LEFT = "\\headerl".getBytes();
    private static final byte[] HEADER_RIGHT = "\\headerr".getBytes();
    private static final byte[] FOOTER_ALL = "\\footer".getBytes();
    private static final byte[] FOOTER_FIRST = "\\footerf".getBytes();
    private static final byte[] FOOTER_LEFT = "\\footerl".getBytes();
    private static final byte[] FOOTER_RIGHT = "\\footerr".getBytes();
    private RtfDocument document = null;
    private Object content = null;
    private int type = 1;
    private int displayAt = 1;

    protected RtfHeaderFooter(RtfDocument doc, HeaderFooter headerFooter, int type, int displayAt) {
        super(new Phrase(""), false);
        this.document = doc;
        this.type = type;
        this.displayAt = displayAt;
        Paragraph par = new Paragraph();
        par.setAlignment(headerFooter.alignment());
        if (headerFooter.getBefore() != null) {
            par.add(headerFooter.getBefore());
        }
        if (headerFooter.isNumbered()) {
            par.add(new RtfPageNumber(this.document));
        }
        if (headerFooter.getAfter() != null) {
            par.add(headerFooter.getAfter());
        }
        try {
            if (this.document != null) {
                this.content = this.document.getMapper().mapElement(par);
                ((RtfBasicElement)this.content).setInHeader(true);
            } else {
                this.content = par;
            }
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
    }

    protected RtfHeaderFooter(RtfDocument doc, RtfHeaderFooter headerFooter, int displayAt) {
        super(new Phrase(""), false);
        this.document = doc;
        this.content = headerFooter.getContent();
        this.displayAt = displayAt;
        if (this.content instanceof Element) {
            try {
                this.content = this.document.getMapper().mapElement((Element)this.content);
            }
            catch (DocumentException de) {
                de.printStackTrace();
            }
        }
        ((RtfBasicElement)this.content).setInHeader(true);
    }

    protected RtfHeaderFooter(RtfDocument doc, HeaderFooter headerFooter) {
        super(new Phrase(""), false);
        this.document = doc;
        Paragraph par = new Paragraph();
        par.setAlignment(headerFooter.alignment());
        if (headerFooter.getBefore() != null) {
            par.add(headerFooter.getBefore());
        }
        if (headerFooter.isNumbered()) {
            par.add(new RtfPageNumber(this.document));
        }
        if (headerFooter.getAfter() != null) {
            par.add(headerFooter.getAfter());
        }
        try {
            this.content = doc.getMapper().mapElement(par);
            ((RtfBasicElement)this.content).setInHeader(true);
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
    }

    public RtfHeaderFooter(Element element) {
        super(new Phrase(""), false);
        this.content = element;
    }

    public void setRtfDocument(RtfDocument doc) {
        this.document = doc;
        if (this.document != null) {
            try {
                if (this.content instanceof Element) {
                    this.content = this.document.getMapper().mapElement((Element)this.content);
                    ((RtfBasicElement)this.content).setInHeader(true);
                } else if (this.content instanceof RtfBasicElement) {
                    ((RtfBasicElement)this.content).setRtfDocument(this.document);
                    ((RtfBasicElement)this.content).setInHeader(true);
                }
            }
            catch (DocumentException de) {
                de.printStackTrace();
            }
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(RtfBasicElement.OPEN_GROUP);
            if (this.type == 1) {
                if (this.displayAt == 1) {
                    result.write(HEADER_ALL);
                } else if (this.displayAt == 0) {
                    result.write(HEADER_FIRST);
                } else if (this.displayAt == 2) {
                    result.write(HEADER_LEFT);
                } else if (this.displayAt == 4) {
                    result.write(HEADER_RIGHT);
                }
            } else if (this.displayAt == 1) {
                result.write(FOOTER_ALL);
            } else if (this.displayAt == 0) {
                result.write(FOOTER_FIRST);
            } else if (this.displayAt == 2) {
                result.write(FOOTER_LEFT);
            } else if (this.displayAt == 4) {
                result.write(FOOTER_RIGHT);
            }
            result.write(RtfBasicElement.DELIMITER);
            if (this.content instanceof RtfBasicElement) {
                result.write(((RtfBasicElement)this.content).write());
            }
            result.write(RtfBasicElement.CLOSE_GROUP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public void setDisplayAt(int displayAt) {
        this.displayAt = displayAt;
    }

    public void setType(int type) {
        this.type = type;
    }

    private Object getContent() {
        return this.content;
    }

    public void setInTable(boolean inTable) {
    }

    public void setInHeader(boolean inHeader) {
    }
}

