/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferFileInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferFileInfoUtil;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoUtil;
import com.clustercontrol.logtransfer.factory.DeleteLogTransfer;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyLogTransfer {
    protected static Log m_log = LogFactory.getLog(ModifyLogTransfer.class);

    public boolean modify(LogTransferInfo info, String user) throws CreateException, FinderException, RemoveException, NamingException {
        AccessLock.lock((String)"LOG_TRANSFER");
        try {
            LogTransferInfoLocal logTransfer = LogTransferInfoUtil.getLocalHome().findByPrimaryKey(info.getTransferId());
            if (logTransfer != null) {
                logTransfer.setDescription(info.getDescription());
                logTransfer.setFacilityId(info.getFacilityId());
                logTransfer.setValidFlg(info.getValid());
                logTransfer.setUpdateDate(new Timestamp(new Date().getTime()));
                logTransfer.setUpdateUser(user);
            }
            Collection ct = logTransfer.getLogTransferFileInfo();
            DeleteLogTransfer delete = new DeleteLogTransfer();
            delete.deleteFiles(ct);
            ArrayList fileList = info.getFileInfo();
            ArrayList<LogTransferFileInfoLocal> fileLocalList = new ArrayList<LogTransferFileInfoLocal>();
            LogTransferFileInfo file = null;
            for (int index = 0; index < fileList.size(); ++index) {
                file = (LogTransferFileInfo)fileList.get(index);
                if (file == null) continue;
                LogTransferFileInfoLocal local = LogTransferFileInfoUtil.getLocalHome().create(info.getTransferId(), file.getFilePath(), file.getRunInterval(), file.getExistenceFlg(), file.getValid());
                fileLocalList.add(local);
            }
            if (fileLocalList != null) {
                ct.addAll(fileLocalList);
                logTransfer.setLogTransferFileInfo(ct);
            }
            try {
                SendQueue queue = new SendQueue("queue/clustercontrol/Logtransfer/LogTransferFileManage");
                queue.put((Serializable)info);
            }
            catch (Exception e) {
                m_log.debug((Object)("modify() : \u66f4\u65b0\u60c5\u5831\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
            }
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{info.getTransferId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{info.getTransferId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{info.getTransferId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{info.getTransferId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        return true;
    }
}

