/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.factory;

import com.clustercontrol.calendar.ejb.session.CalendarControllerLocal;
import com.clustercontrol.calendar.ejb.session.CalendarControllerUtil;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.jobmanagement.bean.DelayNotifyConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeMasterLocal;
import com.clustercontrol.jobmanagement.factory.CreateFileJob;
import com.clustercontrol.jobmanagement.factory.EndJudgment;
import com.clustercontrol.jobmanagement.factory.Notice;
import com.clustercontrol.jobmanagement.factory.OperateMaintenanceOfJob;
import com.clustercontrol.jobmanagement.factory.OperateSkipOfJob;
import com.clustercontrol.jobmanagement.factory.OperateStopOfJob;
import com.clustercontrol.jobmanagement.factory.OperateSuspendOfJob;
import com.clustercontrol.jobmanagement.factory.OperateWaitOfJob;
import com.clustercontrol.jobmanagement.message.RunInfo;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.jobmanagement.util.ParameterUtil;
import com.clustercontrol.jobmanagement.util.SendTopic;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.sql.Time;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OperationJob {
    protected static Log m_log = LogFactory.getLog(OperationJob.class);
    protected static Integer m_messageRetry = null;
    protected static Integer m_messageTimeout = null;

    public OperationJob() {
        if (m_messageRetry == null || m_messageTimeout == null) {
            Properties properties = new Properties();
            String homedir = System.getProperty("jboss.server.home.dir");
            String propertyFile = homedir + File.separator + "conf" + File.separator + "jobmanagement.properties";
            if (m_messageRetry == null) {
                try {
                    properties.load(new FileInputStream(propertyFile));
                    String retry = properties.getProperty("message.retry", "false");
                    m_messageRetry = Integer.valueOf(retry);
                }
                catch (Exception e) {
                    m_log.error((Object)("OperationJob():" + e.getMessage()));
                    m_messageRetry = 5;
                }
            }
            if (m_messageTimeout == null) {
                try {
                    properties.load(new FileInputStream(propertyFile));
                    String timeout = properties.getProperty("message.timeout", "false");
                    m_messageTimeout = Integer.valueOf(timeout);
                }
                catch (Exception e) {
                    m_log.error((Object)("SelectJob():" + e.getMessage()));
                    m_messageTimeout = 60;
                }
            }
        }
    }

    public void runJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("runJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        sessionJob.setStatus(100);
        sessionJob.setStart_date(new Date());
        new Notice().notify(sessionId, jobId, 3);
        JobInfoLocal job = sessionJob.getJobInfo();
        int type = job.getJob_type();
        sessionJob = null;
        job = null;
        if (type == 0) {
            this.startJob(sessionId, jobId);
        } else {
            this.startJobMain1(sessionId, jobId, null);
        }
    }

    public void runJob() throws FinderException, NamingException {
        m_log.debug((Object)"runJob()");
        Collection collection = JobSessionJobUtil.getLocalHome().findByStatus(100);
        if (collection != null && collection.size() > 0) {
            for (JobSessionJobLocal sessionJob : collection) {
                String sessionId = sessionJob.getSession_id();
                String jobId = sessionJob.getJob_id();
                JobInfoLocal job = sessionJob.getJobInfo();
                int type = job.getJob_type();
                job = null;
                if (type == 0) {
                    if (this.checkJobNetEnd(sessionId, jobId)) {
                        sessionJob.setStatus(300);
                        sessionJob.setEnd_date(new Date());
                        sessionJob = null;
                        Integer endStatus = this.checkEndStatus(sessionId, jobId);
                        this.setEndStaus(sessionId, jobId, 300, endStatus, null);
                        new Notice().notify(sessionId, jobId, endStatus);
                        continue;
                    }
                    sessionJob = null;
                    this.startJob(sessionId, jobId);
                    continue;
                }
                sessionJob = null;
                this.startJobMain1(sessionId, jobId, null);
            }
        }
    }

    public void runWaitJob() throws FinderException, NamingException {
        m_log.debug((Object)"runWaitJob()");
        Collection collection = JobSessionJobUtil.getLocalHome().findByStatus(0);
        if (collection != null && collection.size() > 0) {
            for (JobSessionJobLocal sessionJob : collection) {
                String sessionId = sessionJob.getSession_id();
                String jobId = sessionJob.getJob_id();
                JobInfoLocal job = sessionJob.getJobInfo();
                int type = job.getJob_type();
                job = null;
                if (type == 0) {
                    try {
                        m_log.debug((Object)("runWaitJob() : RUN WAIT JOB : sessionId=" + sessionId + ", jobId=" + jobId));
                        this.runJob(sessionId, jobId);
                    }
                    catch (Exception e) {
                        m_log.debug((Object)("runWaitJob() : RUN WAIT JOB ERROR : sessionId=" + sessionId + ", jobId=" + jobId));
                        sessionJob.setStatus(400);
                    }
                }
                Object var3_3 = null;
            }
        }
    }

    public void checkStoppingJob() throws FinderException, NamingException {
        m_log.debug((Object)"runStoppingJob()");
        Collection collection = JobSessionNodeUtil.getLocalHome().findByStatus(101);
        if (collection != null && collection.size() > 0) {
            for (JobSessionNodeLocal sessionNode : collection) {
                String sessionId = sessionNode.getSession_id();
                String jobId = sessionNode.getJob_id();
                String facilityId = sessionNode.getFacility_id();
                sessionNode = null;
                this.checkStopTimeout(sessionId, jobId, facilityId);
            }
        }
    }

    protected void startJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("startJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        Collection collection = JobRelationInfoUtil.getLocalHome().findByStartStatus(sessionId, jobId);
        if (collection != null && collection.size() > 0) {
            for (JobRelationInfoLocal relation : collection) {
                JobSessionJobLocal sessionJob = relation.getJobSessionJob();
                String startSessionId = sessionJob.getSession_id();
                String startJobId = sessionJob.getJob_id();
                sessionJob = null;
                this.startJobMain1(startSessionId, startJobId, null);
            }
        }
    }

    protected void startJobMain1(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
        m_log.debug((Object)("startJobMain1() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob.getStatus() == 0) {
            sessionJob = null;
            if (this.checkStartCondition(sessionId, jobId)) {
                if (this.checkCalendar(sessionId, jobId)) {
                    this.startJobMain2(sessionId, jobId, facilityId);
                }
            } else {
                this.checkStartDelayMain(sessionId, jobId);
            }
        } else if (sessionJob.getStatus() == 100) {
            JobInfoLocal job = sessionJob.getJobInfo();
            int type = job.getJob_type();
            job = null;
            if (type == 2) {
                if (this.checkJobEnd(sessionJob)) {
                    Integer endStatus = this.checkEndStatus(sessionId, jobId);
                    sessionJob.setEnd_date(new Date());
                    sessionJob = null;
                    this.setEndStaus(sessionId, jobId, 300, endStatus, "");
                    new Notice().notify(sessionId, jobId, endStatus);
                    this.endJob(sessionId, jobId);
                } else if (!this.checkEndDelay(sessionId, jobId)) {
                    sessionJob = null;
                    this.startNode(sessionId, jobId, null);
                }
            } else if (this.checkJobNetEnd(sessionId, jobId)) {
                sessionJob.setStatus(300);
                sessionJob.setEnd_date(new Date());
                sessionJob = null;
                Integer endStatus = this.checkEndStatus(sessionId, jobId);
                this.setEndStaus(sessionId, jobId, 300, endStatus, null);
                new Notice().notify(sessionId, jobId, endStatus);
                this.endJob(sessionId, jobId);
            } else if (!this.checkEndDelay(sessionId, jobId)) {
                sessionJob = null;
                this.startJob(sessionId, jobId);
            }
        } else if (sessionJob.getStatus() == 2 && this.checkStartCondition(sessionId, jobId)) {
            sessionJob.setStatus(300);
            sessionJob.setEnd_date(new Date());
            sessionJob = null;
            this.endJob(sessionId, jobId);
        }
    }

    protected void startJobMain2(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
        m_log.debug((Object)("startJobMain2() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        sessionJob.setStatus(100);
        sessionJob.setStart_date(new Date());
        JobInfoLocal job = sessionJob.getJobInfo();
        int type = job.getJob_type();
        sessionJob = null;
        job = null;
        new Notice().notify(sessionId, jobId, 3);
        if (type == 2) {
            this.startNode(sessionId, jobId, facilityId);
        } else {
            this.startJob(sessionId, jobId);
        }
    }

    protected boolean checkStartCondition(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("checkStartCondition() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobStartInfoLocal start = job.getJobStartInfo();
        Collection startJobs = start.getJobStartJobInfo();
        JobStartTimeInfoLocal startTime = start.getJobStartTimeInfo();
        ArrayList<Boolean> jobResult = new ArrayList<Boolean>();
        boolean statusCheck = true;
        boolean startCheck = true;
        if (startJobs != null && startJobs.size() > 0 || startTime != null) {
            for (JobStartJobInfoLocal startJob : startJobs) {
                JobSessionJobLocal targetSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionJob.getSession_id(), startJob.getTarget_job_id()));
                if (targetSessionJob.getStatus() == 300 || targetSessionJob.getStatus() == 301) {
                    if (startJob.getTarget_job_type() == 0) {
                        Integer endStatus = this.getEndStatus(targetSessionJob);
                        if (endStatus instanceof Integer) {
                            if (endStatus.compareTo(startJob.getTarget_job_end_value()) == 0) {
                                jobResult.add(new Boolean(true));
                                continue;
                            }
                            jobResult.add(new Boolean(false));
                            continue;
                        }
                        jobResult.add(new Boolean(false));
                        continue;
                    }
                    if (startJob.getTarget_job_type() == 1) {
                        Integer endValue = targetSessionJob.getEnd_value();
                        if (endValue instanceof Integer) {
                            if (endValue.compareTo(startJob.getTarget_job_end_value()) == 0) {
                                jobResult.add(new Boolean(true));
                                continue;
                            }
                            jobResult.add(new Boolean(false));
                            continue;
                        }
                        jobResult.add(new Boolean(false));
                        continue;
                    }
                    jobResult.add(new Boolean(false));
                    continue;
                }
                statusCheck = false;
                startCheck = false;
                break;
            }
            if (statusCheck) {
                int i;
                if (start.getCondition_type() == 0) {
                    startCheck = true;
                    for (i = 0; i < jobResult.size(); ++i) {
                        if (((Boolean)jobResult.get(i)).booleanValue()) continue;
                        startCheck = false;
                        break;
                    }
                } else {
                    startCheck = false;
                    for (i = 0; i < jobResult.size(); ++i) {
                        if (!((Boolean)jobResult.get(i)).booleanValue()) continue;
                        startCheck = true;
                        break;
                    }
                }
                if (startCheck && startTime != null) {
                    JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
                    Date sessionDate = session.getSchedule_date();
                    session = null;
                    Date now = new Date();
                    Calendar work = Calendar.getInstance();
                    Calendar time = Calendar.getInstance();
                    work.setTime(startTime.getStart_time());
                    work.getTime();
                    time.set(11, work.get(11));
                    time.set(12, work.get(12));
                    time.set(13, work.get(13));
                    time.set(14, 0);
                    Date startDate = time.getTime();
                    startCheck = startDate.after(sessionDate) && startDate.before(now);
                }
            }
        }
        if (!startCheck) {
            boolean possibility = true;
            if (start.getCondition_type() == 0) {
                if (statusCheck) {
                    possibility = false;
                }
            } else if (statusCheck && startTime == null) {
                possibility = false;
            }
            if (!possibility && start.getUnmatch_end_flg() == 1) {
                sessionJob.setStatus(300);
                sessionJob.setEnd_value(start.getUnmatch_end_value());
                sessionJob.setEnd_date(new Date());
                this.endJob(sessionJob.getSession_id(), sessionJob.getJob_id());
            }
        }
        return startCheck;
    }

    protected void checkStartDelayMain(String sessionId, String jobId) throws FinderException, NamingException {
        Collection collection;
        m_log.debug((Object)("checkStartDelayMain() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob.getStatus() == 0) {
            sessionJob = null;
            this.checkStartDelay(sessionId, jobId);
        }
        if ((collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId)) != null && collection.size() > 0) {
            for (JobRelationInfoLocal relation : collection) {
                JobSessionJobLocal childSessionJob = relation.getJobSessionJob();
                String childSessionId = childSessionJob.getSession_id();
                String childJobId = childSessionJob.getJob_id();
                childSessionJob = null;
                this.checkStartDelayMain(childSessionId, childJobId);
            }
        }
    }

    protected void checkStartDelay(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("checkStartDelay() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobStartInfoLocal start = job.getJobStartInfo();
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        boolean delayCheck = true;
        if (start != null && start.getStart_delay() == 1) {
            JobSessionLocal session;
            Date sessionDate = null;
            if (start.getStart_delay_session() == 1) {
                session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
                sessionDate = session.getSchedule_date();
                Date now = new Date();
                Calendar work = Calendar.getInstance();
                work.setTime(sessionDate);
                work.getTime();
                work.add(12, start.getStart_delay_session_value());
                Date check = work.getTime();
                if (now.after(check)) {
                    result.add(new Boolean(true));
                } else {
                    result.add(new Boolean(false));
                }
            }
            if (start.getStart_delay_time() == 1) {
                if (start.getStart_delay_time_value() instanceof Time) {
                    if (sessionDate == null) {
                        session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
                        sessionDate = session.getSchedule_date();
                    }
                    Date now = new Date();
                    Calendar work = Calendar.getInstance();
                    Calendar time = Calendar.getInstance();
                    work.setTime(start.getStart_delay_time_value());
                    work.getTime();
                    time.set(11, work.get(11));
                    time.set(12, work.get(12));
                    time.set(13, work.get(13));
                    time.set(14, 0);
                    Date startDate = time.getTime();
                    if (startDate.after(sessionDate) && startDate.before(now)) {
                        result.add(new Boolean(true));
                    } else {
                        result.add(new Boolean(false));
                    }
                } else {
                    result.add(new Boolean(false));
                }
            }
            if (result.size() > 0) {
                if (start.getStart_delay_condition_type() == 0) {
                    delayCheck = true;
                    for (int i = 0; i < result.size(); ++i) {
                        if (((Boolean)result.get(i)).booleanValue()) continue;
                        delayCheck = false;
                        break;
                    }
                } else {
                    delayCheck = false;
                    for (int i = 0; i < result.size(); ++i) {
                        if (!((Boolean)result.get(i)).booleanValue()) continue;
                        delayCheck = true;
                        break;
                    }
                }
            } else {
                delayCheck = false;
            }
            if (delayCheck) {
                int flg;
                int notifyFlg;
                if (start.getStart_delay_notify() == 1 && ((notifyFlg = DelayNotifyConstant.getNotify(flg = sessionJob.getDelay_notify_flg().intValue())) == 0 || notifyFlg == 2)) {
                    new Notice().delayNotify(sessionId, jobId, true);
                    if (notifyFlg == 0) {
                        sessionJob.setDelay_notify_flg(1);
                    } else if (notifyFlg == 2) {
                        sessionJob.setDelay_notify_flg(3);
                    }
                }
                if (start.getStart_delay_operation() == 1) {
                    int type = start.getStart_delay_operation_type();
                    if (type == 4) {
                        new OperateSkipOfJob().skipJob(sessionId, jobId, start.getStart_delay_operation_end_value());
                    } else if (type == 6) {
                        new OperateWaitOfJob().waitJob(sessionId, jobId);
                    }
                }
            }
        }
        sessionJob = null;
    }

    protected boolean checkEndDelay(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("checkEndDelay() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobStartInfoLocal start = job.getJobStartInfo();
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        boolean delayCheck = true;
        boolean operation = false;
        if (start != null && start.getEnd_delay() == 1) {
            Date check;
            Calendar work;
            Date now;
            JobSessionLocal session;
            Date sessionDate = null;
            if (start.getEnd_delay_session() == 1) {
                session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
                sessionDate = session.getSchedule_date();
                now = new Date();
                work = Calendar.getInstance();
                work.setTime(sessionDate);
                work.getTime();
                work.add(12, start.getEnd_delay_session_value());
                check = work.getTime();
                if (now.after(check)) {
                    result.add(true);
                } else {
                    result.add(false);
                }
            }
            if (start.getEnd_delay_job() == 1) {
                Date startDate = sessionJob.getStart_date();
                now = new Date();
                work = Calendar.getInstance();
                work.setTime(startDate);
                work.getTime();
                work.add(12, start.getEnd_delay_job_value());
                check = work.getTime();
                if (now.after(check)) {
                    result.add(true);
                } else {
                    result.add(false);
                }
            }
            if (start.getEnd_delay_time() == 1) {
                if (start.getEnd_delay_time_value() instanceof Time) {
                    if (sessionDate == null) {
                        session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
                        sessionDate = session.getSchedule_date();
                    }
                    Date now2 = new Date();
                    Calendar work2 = Calendar.getInstance();
                    Calendar time = Calendar.getInstance();
                    work2.setTime(start.getEnd_delay_time_value());
                    work2.getTime();
                    time.set(11, work2.get(11));
                    time.set(12, work2.get(12));
                    time.set(13, work2.get(13));
                    time.set(14, 0);
                    Date startDate = time.getTime();
                    if (startDate.after(sessionDate) && startDate.before(now2)) {
                        result.add(true);
                    } else {
                        result.add(false);
                    }
                } else {
                    result.add(false);
                }
            }
            if (result.size() > 0) {
                if (start.getEnd_delay_condition_type() == 0) {
                    delayCheck = true;
                    for (int i = 0; i < result.size(); ++i) {
                        if (((Boolean)result.get(i)).booleanValue()) continue;
                        delayCheck = false;
                        break;
                    }
                } else {
                    delayCheck = false;
                    for (int i = 0; i < result.size(); ++i) {
                        if (!((Boolean)result.get(i)).booleanValue()) continue;
                        delayCheck = true;
                        break;
                    }
                }
            } else {
                delayCheck = false;
            }
            if (delayCheck) {
                int flg;
                int notifyFlg;
                if (start.getEnd_delay_notify() == 1 && ((notifyFlg = DelayNotifyConstant.getNotify(flg = sessionJob.getDelay_notify_flg().intValue())) == 0 || notifyFlg == 1)) {
                    new Notice().delayNotify(sessionId, jobId, false);
                    if (notifyFlg == 0) {
                        sessionJob.setDelay_notify_flg(2);
                    } else if (notifyFlg == 1) {
                        sessionJob.setDelay_notify_flg(3);
                    }
                }
                if (start.getEnd_delay_operation() == 1) {
                    int type = start.getEnd_delay_operation_type();
                    int flg2 = sessionJob.getDelay_notify_flg();
                    if (type == 0) {
                        int notifyFlg2 = DelayNotifyConstant.addOperation(flg2, 10);
                        sessionJob.setDelay_notify_flg(notifyFlg2);
                        new OperateStopOfJob().stopJob(sessionId, jobId, null);
                    } else if (type == 2) {
                        int operationFlg = DelayNotifyConstant.getOperation(flg2);
                        if (operationFlg != 20) {
                            int notifyFlg3 = DelayNotifyConstant.addOperation(flg2, 20);
                            sessionJob.setDelay_notify_flg(notifyFlg3);
                            new OperateSuspendOfJob().suspendJob(sessionId, jobId);
                        }
                    } else if (type == 10) {
                        int notifyFlg4 = DelayNotifyConstant.addOperation(flg2, 30);
                        sessionJob.setDelay_notify_flg(notifyFlg4);
                        new OperateStopOfJob().stopJob(sessionId, jobId, null);
                    }
                    operation = true;
                }
            }
        }
        return operation;
    }

    protected Integer getEndStatus(JobSessionJobLocal sessionJob) throws FinderException, NamingException {
        JobInfoLocal job;
        Collection collection;
        m_log.debug((Object)("getEndStatus() : sessionId=" + sessionJob.getSession_id() + ", jobId=" + sessionJob.getJob_id()));
        Integer status = null;
        if (sessionJob.getEnd_value() instanceof Integer && (collection = (job = sessionJob.getJobInfo()).getJobEndInfo()) != null && collection.size() > 0) {
            for (JobEndInfoLocal end : collection) {
                if (end.getEnd_value().compareTo(sessionJob.getEnd_value()) != 0) continue;
                status = end.getEnd_status();
                break;
            }
        }
        return status;
    }

    protected boolean startNode(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
        m_log.debug((Object)("startNode() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
        this.checkTimeout(sessionId, jobId);
        boolean startCommand = false;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobCommandInfoLocal command = job.getJobCommandInfo();
        Collection collection = sessionJob.getJobSessionNode();
        if (collection != null && collection.size() > 0) {
            boolean run = true;
            if (command.getProcess_mode() == 1) {
                for (JobSessionNodeLocal sessionNode : collection) {
                    if (sessionNode.getStatus() != 100) continue;
                    run = false;
                    startCommand = true;
                }
            }
            if (run) {
                for (JobSessionNodeLocal sessionNode : collection) {
                    if ((facilityId == null || facilityId != null && facilityId.compareTo(sessionNode.getFacility_id()) == 0) && sessionNode.getStatus() == 0) {
                        sessionNode.setStatus(100);
                        RunInstructionInfo info = new RunInstructionInfo();
                        info.setSessionId(sessionJob.getSession_id());
                        info.setJobId(sessionJob.getJob_id());
                        info.setFacilityId(sessionNode.getFacility_id());
                        info.setCommandType(3);
                        sessionNode.setAgent_check(1);
                        sessionNode.setCheck_date(new Date());
                        try {
                            m_log.debug((Object)("startNode() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30af\u9001\u4fe1 : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + sessionNode.getFacility_id()));
                            SendTopic send = new SendTopic("topic/clustercontrol/JobManagement/execute");
                            send.put(info);
                            startCommand = true;
                        }
                        catch (Exception e) {
                            m_log.debug((Object)("startNode() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30af\u9001\u4fe1\u30a8\u30e9\u30fc : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + sessionNode.getFacility_id() + ", " + e.getMessage()));
                        }
                        sessionNode = null;
                        if (command.getProcess_mode() == 1) break;
                    }
                    sessionNode = null;
                }
            }
        }
        return startCommand;
    }

    protected void checkTimeout(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("checkTimeout() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        Collection collection = sessionJob.getJobSessionNode();
        if (collection != null && collection.size() > 0) {
            for (JobSessionNodeLocal sessionNode : collection) {
                if (sessionNode.getStatus() == 100) {
                    String facilityId = sessionNode.getFacility_id();
                    Boolean retry = null;
                    Calendar checkTime = Calendar.getInstance();
                    checkTime.setTime(sessionNode.getCheck_date());
                    checkTime.add(13, m_messageTimeout);
                    Date now = new Date();
                    if (sessionNode.getAgent_check() == 1) {
                        if (now.after(checkTime.getTime())) {
                            retry = sessionNode.getRetry_count().compareTo(m_messageRetry) >= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
                        }
                    } else if (sessionNode.getAgent_check() == 2 && sessionNode.getStart_date() == null && now.after(checkTime.getTime())) {
                        retry = sessionNode.getRetry_count().compareTo(m_messageRetry) >= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    }
                    if (retry != null) {
                        RunInfo info;
                        if (retry.booleanValue()) {
                            info = new RunInstructionInfo();
                            info.setSessionId(sessionJob.getSession_id());
                            info.setJobId(sessionJob.getJob_id());
                            info.setFacilityId(sessionNode.getFacility_id());
                            info.setCommandType(3);
                            sessionNode.setAgent_check(1);
                            sessionNode.setCheck_date(checkTime.getTime());
                            int retryCount = sessionNode.getRetry_count();
                            sessionNode.setRetry_count(++retryCount);
                            sessionNode = null;
                            try {
                                m_log.debug((Object)("checkTimeout() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30af\u9001\u4fe1 : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", retry=" + retryCount));
                                SendTopic send = new SendTopic("topic/clustercontrol/JobManagement/execute");
                                send.put((RunInstructionInfo)info);
                            }
                            catch (Exception e) {
                                m_log.debug((Object)("checkTimeout() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30af\u9001\u4fe1\u30a8\u30e9\u30fc : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", " + e.getMessage()));
                            }
                        } else {
                            sessionNode.setAgent_check(3);
                            m_log.debug((Object)("checkTimeout() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30afNG : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
                            info = new RunResultInfo();
                            info.setSessionId(sessionJob.getSession_id());
                            info.setJobId(sessionJob.getJob_id());
                            info.setFacilityId(sessionNode.getFacility_id());
                            info.setCommand("");
                            info.setCommandType(0);
                            ((RunResultInfo)info).setStatus(2);
                            ((RunResultInfo)info).setMessage("Agent Timeout Error");
                            ((RunResultInfo)info).setErrorMessage("");
                            sessionNode = null;
                            try {
                                m_log.debug((Object)("checkTimeout() : \u5b9f\u884c\u7d50\u679c\u9001\u4fe1 : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
                                SendQueue queue = new SendQueue("queue/clustercontrol/JobManagement/status");
                                queue.put((Serializable)info);
                            }
                            catch (Exception e) {
                                m_log.debug((Object)("checkTimeout() : \u5b9f\u884c\u7d50\u679c\u9001\u4fe1\u30a8\u30e9\u30fc : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", " + e.getMessage()));
                            }
                        }
                    }
                }
                sessionNode = null;
            }
        }
    }

    protected void checkStopTimeout(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
        m_log.debug((Object)("checkStoppTimeout() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
        JobSessionNodeLocal sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(new JobSessionNodePK(sessionId, jobId, facilityId));
        if (sessionNode.getStatus() == 101) {
            Boolean retry = null;
            Calendar checkTime = Calendar.getInstance();
            checkTime.setTime(sessionNode.getCheck_date());
            checkTime.add(13, m_messageTimeout);
            Date now = new Date();
            if (sessionNode.getStart_date() == null && now.after(checkTime.getTime())) {
                retry = sessionNode.getRetry_count().compareTo(m_messageRetry) >= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
            if (retry != null) {
                if (retry.booleanValue()) {
                    JobCommandInfoLocal command = JobCommandInfoUtil.getLocalHome().findByPrimaryKey(new JobCommandInfoPK(sessionId, jobId));
                    RunInstructionInfo info = new RunInstructionInfo();
                    info.setSessionId(sessionId);
                    info.setJobId(jobId);
                    info.setFacilityId(facilityId);
                    String stopCommand = ParameterUtil.replaceSessionParameterValue(sessionId, command.getStop_command());
                    info.setCommand(stopCommand);
                    info.setUser(command.getEffective_user());
                    info.setCommandType(1);
                    command = null;
                    sessionNode.setCheck_date(checkTime.getTime());
                    int retryCount = sessionNode.getRetry_count();
                    sessionNode.setRetry_count(++retryCount);
                    sessionNode = null;
                    try {
                        m_log.debug((Object)("checkStoppTimeout() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30af\u9001\u4fe1 : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", retry=" + retryCount));
                        SendTopic send = new SendTopic("topic/clustercontrol/JobManagement/execute");
                        send.put(info);
                    }
                    catch (Exception e) {
                        m_log.debug((Object)("checkStoppTimeout() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30af\u9001\u4fe1\u30a8\u30e9\u30fc : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", " + e.getMessage()));
                    }
                } else {
                    sessionNode.setAgent_check(3);
                    m_log.debug((Object)("checkStoppTimeout() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30afNG : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
                    RunResultInfo info = new RunResultInfo();
                    info.setSessionId(sessionId);
                    info.setJobId(jobId);
                    info.setFacilityId(facilityId);
                    info.setCommand("");
                    info.setCommandType(1);
                    info.setStatus(2);
                    info.setMessage("Agent Timeout Error");
                    info.setErrorMessage("");
                    sessionNode = null;
                    try {
                        m_log.debug((Object)("checkStoppTimeout() : \u5b9f\u884c\u7d50\u679c\u9001\u4fe1 : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
                        SendQueue queue = new SendQueue("queue/clustercontrol/JobManagement/status");
                        queue.put((Serializable)info);
                    }
                    catch (Exception e) {
                        m_log.debug((Object)("checkStoppTimeout() : \u5b9f\u884c\u7d50\u679c\u9001\u4fe1\u30a8\u30e9\u30fc : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", " + e.getMessage()));
                    }
                }
            }
        }
        sessionNode = null;
    }

    protected void endJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("endJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        Collection collection = JobStartJobInfoUtil.getLocalHome().findByTargetJobId(sessionId, jobId);
        if (collection != null && collection.size() > 0) {
            for (JobStartJobInfoLocal startJob : collection) {
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(startJob.getSession_id(), startJob.getJob_id()));
                String startSessionId = sessionJob.getSession_id();
                String startJobId = sessionJob.getJob_id();
                int status = sessionJob.getStatus();
                sessionJob = null;
                startJob = null;
                if (status == 300 || status == 301) {
                    this.endJob(startSessionId, startJobId);
                    continue;
                }
                this.startJobMain1(startSessionId, startJobId, null);
            }
        } else {
            JobSessionJobLocal parentSessionJob;
            JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
            JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
            String parentJobId = relation.getParent_job_id();
            relation = null;
            boolean endAll = true;
            Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, parentJobId);
            for (JobRelationInfoLocal relation1 : sameHierarchy) {
                JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
                if (sessionJob1.getStatus() == 300 || sessionJob1.getStatus() == 301) continue;
                endAll = false;
                break;
            }
            if (endAll && parentJobId.compareTo("TOP") != 0 && (parentSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, parentJobId))).getStatus() == 100) {
                parentSessionJob = null;
                Integer endStatus = this.checkEndStatus(sessionId, parentJobId);
                this.setEndStaus(sessionId, parentJobId, 300, endStatus, null);
                new Notice().notify(sessionId, parentJobId, endStatus);
                this.endJob(sessionId, parentJobId);
            }
        }
    }

    protected Integer checkEndStatus(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("checkEndStatus() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobEndInfoLocal endInfoNormal = JobEndInfoUtil.getLocalHome().findByPrimaryKey(new JobEndInfoPK(sessionId, jobId, 0));
        JobEndInfoLocal endInfoWarning = JobEndInfoUtil.getLocalHome().findByPrimaryKey(new JobEndInfoPK(sessionId, jobId, 1));
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        if (sessionJob.getJobInfo().getJob_type() == 2) {
            JobInfoLocal job = sessionJob.getJobInfo();
            JobCommandInfoLocal command = job.getJobCommandInfo();
            Collection collection = sessionJob.getJobSessionNode();
            for (JobSessionNodeLocal sessionNode : collection) {
                Integer endValue = sessionNode.getEnd_value();
                if (!(endValue instanceof Integer)) continue;
                Integer status = null;
                if (endValue.compareTo(endInfoNormal.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoNormal.getEnd_value_to()) <= 0) {
                    status = 0;
                    statusList.add(status);
                } else if (endValue.compareTo(endInfoWarning.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoWarning.getEnd_value_to()) <= 0) {
                    status = 1;
                    statusList.add(status);
                } else {
                    status = 2;
                    statusList.add(status);
                }
                if (command.getProcess_mode() != 1 || status != 0) continue;
                statusList.clear();
                statusList.add(0);
                break;
            }
            if (collection.size() == 0) {
                statusList.clear();
                statusList.add(2);
            }
        } else {
            Integer endStatusCheck = sessionJob.getEnd_staus_check_flg();
            if (endStatusCheck == null || endStatusCheck != null && endStatusCheck == 0) {
                Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
                for (JobRelationInfoLocal relation : collection) {
                    JobSessionJobLocal childSessionJob = relation.getJobSessionJob();
                    Collection targetJobList = JobStartJobInfoUtil.getLocalHome().findByTargetJobId(sessionId, childSessionJob.getJob_id());
                    if (targetJobList != null && (targetJobList == null || targetJobList.size() != 0)) continue;
                    Integer endValue = childSessionJob.getEnd_value();
                    if (endValue.compareTo(endInfoNormal.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoNormal.getEnd_value_to()) <= 0) {
                        statusList.add(0);
                        continue;
                    }
                    if (endValue.compareTo(endInfoWarning.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoWarning.getEnd_value_to()) <= 0) {
                        statusList.add(1);
                        continue;
                    }
                    statusList.add(2);
                }
                if (collection.size() == 0) {
                    statusList.clear();
                    statusList.add(2);
                }
            } else {
                Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
                for (JobRelationInfoLocal relation : collection) {
                    JobSessionJobLocal childSessionJob = relation.getJobSessionJob();
                    Integer endValue = childSessionJob.getEnd_value();
                    if (endValue.compareTo(endInfoNormal.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoNormal.getEnd_value_to()) <= 0) {
                        statusList.add(0);
                        continue;
                    }
                    if (endValue.compareTo(endInfoWarning.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoWarning.getEnd_value_to()) <= 0) {
                        statusList.add(1);
                        continue;
                    }
                    statusList.add(2);
                }
                if (collection.size() == 0) {
                    statusList.clear();
                    statusList.add(2);
                }
            }
        }
        Integer endStatus = EndJudgment.judgment(statusList);
        return endStatus;
    }

    protected void setEndStaus(String sessionId, String jobId, Integer status, Integer endStatus, String result) throws FinderException, NamingException {
        m_log.debug((Object)("setEndStaus() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobEndInfoLocal endInfoNormal = JobEndInfoUtil.getLocalHome().findByPrimaryKey(new JobEndInfoPK(sessionId, jobId, 0));
        JobEndInfoLocal endInfoWarning = JobEndInfoUtil.getLocalHome().findByPrimaryKey(new JobEndInfoPK(sessionId, jobId, 1));
        JobEndInfoLocal endInfoAbnormal = JobEndInfoUtil.getLocalHome().findByPrimaryKey(new JobEndInfoPK(sessionId, jobId, 2));
        sessionJob.setStatus(status);
        sessionJob.setEnd_status(endStatus);
        if (endInfoNormal.getEnd_status().compareTo(endStatus) == 0) {
            sessionJob.setEnd_value(endInfoNormal.getEnd_value());
        } else if (endInfoWarning.getEnd_status().compareTo(endStatus) == 0) {
            sessionJob.setEnd_value(endInfoWarning.getEnd_value());
        } else if (endInfoAbnormal.getEnd_status().compareTo(endStatus) == 0) {
            sessionJob.setEnd_value(endInfoAbnormal.getEnd_value());
        }
        sessionJob.setEnd_date(new Date());
        sessionJob.setResult(result);
    }

    public void endNode(RunResultInfo info) throws FinderException, NamingException {
        SendQueue queue;
        RunInstructionInfo instructionInfo;
        m_log.debug((Object)("endNode() : sessionId=" + info.getSessionId() + ", jobId=" + info.getJobId() + ", facilityId=" + info.getFacilityId()));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(info.getSessionId(), info.getJobId()));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobCommandInfoLocal command = job.getJobCommandInfo();
        JobSessionNodeLocal sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(new JobSessionNodePK(info.getSessionId(), info.getJobId(), info.getFacilityId()));
        if (info.getCommandType() == 3) {
            if (sessionNode.getStatus() == 100) {
                if (sessionNode.getAgent_check() == 1) {
                    JobSessionJobLocal argumentSessionJob;
                    sessionNode.setAgent_check(2);
                    sessionNode.setCheck_date(new Date());
                    instructionInfo = new RunInstructionInfo();
                    instructionInfo.setSessionId(sessionJob.getSession_id());
                    instructionInfo.setJobId(sessionJob.getJob_id());
                    instructionInfo.setFacilityId(sessionNode.getFacility_id());
                    String startCommand = ParameterUtil.replaceSessionParameterValue(info.getSessionId(), command.getStart_command());
                    instructionInfo.setCommand(startCommand);
                    instructionInfo.setUser(command.getEffective_user());
                    instructionInfo.setCommandType(0);
                    if (instructionInfo.getCommand().equals("addPublicKey") || instructionInfo.getCommand().equals("deletePublicKey")) {
                        argumentSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(info.getSessionId(), command.getArgument_job_id()));
                        String result = argumentSessionJob.getResult();
                        argumentSessionJob = null;
                        instructionInfo.setPublicKey(result);
                    } else if (instructionInfo.getCommand().equals("getFileList")) {
                        instructionInfo.setFilePath(command.getArgument());
                    } else if (instructionInfo.getCommand().equals("getCheckSum")) {
                        instructionInfo.setFilePath(command.getArgument());
                    } else if (instructionInfo.getCommand().equals("checkCheckSum")) {
                        argumentSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(info.getSessionId(), command.getArgument_job_id()));
                        String result = argumentSessionJob.getResult();
                        argumentSessionJob = null;
                        instructionInfo.setCheckSum(result);
                        instructionInfo.setFilePath(command.getArgument());
                    }
                    try {
                        SendTopic send = new SendTopic("topic/clustercontrol/JobManagement/execute");
                        send.put(instructionInfo);
                    }
                    catch (Exception e) {
                        m_log.debug((Object)("endNode() : \u5b9f\u884c\u6307\u793a\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                    }
                }
            } else if (sessionNode.getStatus() != 300 && sessionNode.getStatus() != 301 && sessionNode.getStatus() != 400 && sessionNode.getStatus() != 201 && sessionNode.getStatus() != 200) {
                try {
                    m_log.debug((Object)"endNode() : \u5b9f\u884c\u7d50\u679c\u3092Queue\u306e\u6700\u5f8c\u306b\u307e\u308f\u3059");
                    queue = new SendQueue("queue/clustercontrol/JobManagement/status");
                    queue.put((Serializable)info);
                }
                catch (Exception e) {
                    m_log.debug((Object)("endNode() : \u5b9f\u884c\u7d50\u679c\u3092\u518d\u53d7\u4fe1 : " + e.getMessage()));
                }
            }
        } else if (info.getCommandType() == 0 || info.getCommandType() == 1) {
            if (info.getStatus() == 0) {
                if (sessionNode.getStart_date() == null) {
                    sessionNode.setStart_date(info.getTime());
                    if (sessionNode.getAgent_check() != 2) {
                        m_log.debug((Object)("agent check OK : status=" + info.getStatus() + ", sessionId=" + info.getSessionId() + ", jobId=" + info.getJobId() + ", facilityId=" + info.getFacilityId()));
                        sessionNode.setAgent_check(2);
                        sessionNode.setCheck_date(new Date());
                    }
                } else {
                    m_log.debug((Object)("endNode() : \u53d7\u4fe1\u6e08\u307f\u306e\u5b9f\u884c\u958b\u59cb\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002 \u7834\u68c4\u3057\u307e\u3059\u3002 sessionId=" + info.getSessionId() + ", jobId=" + info.getJobId() + ", facilityId=" + info.getFacilityId()));
                }
            } else {
                if (info.getStatus() == 1) {
                    if (sessionJob.getStart_date() instanceof Date || sessionNode.getStart_date() instanceof Date) {
                        if (sessionJob.getEnd_date() == null || sessionJob.getStatus() == 100 || sessionJob.getStatus() == 200 || sessionJob.getStatus() == 101) {
                            if (sessionNode.getStatus() == 100) {
                                sessionNode.setStatus_buffer(300);
                                sessionNode.setEnd_date(info.getTime());
                            } else if (sessionNode.getStatus() == 101) {
                                if (info.getCommandType() == 0 && sessionNode.getStatus_buffer() != 201) {
                                    sessionNode.setStatus_buffer(101);
                                } else if (info.getCommandType() == 1) {
                                    sessionNode.setStatus_buffer(201);
                                }
                            }
                            sessionNode.setEnd_value(info.getEndValue());
                            sessionNode.setMessage(info.getMessage() + info.getErrorMessage());
                            if (info.getCommand().equals("getPublicKey")) {
                                sessionNode.setResult(info.getPublicKey());
                            } else if (info.getCommand().equals("getCheckSum")) {
                                sessionNode.setResult(info.getCheckSum());
                            }
                        } else {
                            m_log.debug((Object)("endNode() : \u53d7\u4fe1\u6e08\u307f\u306e\u5b9f\u884c\u7d42\u4e86\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002 \u7834\u68c4\u3057\u307e\u3059\u3002 sessionId=" + info.getSessionId() + ", jobId=" + info.getJobId() + ", facilityId=" + info.getFacilityId()));
                        }
                    } else {
                        try {
                            m_log.debug((Object)"endNode() : \u5b9f\u884c\u7d50\u679c\u3092Queue\u306e\u6700\u5f8c\u306b\u307e\u308f\u3059");
                            queue = new SendQueue("queue/clustercontrol/JobManagement/status");
                            queue.put((Serializable)info);
                        }
                        catch (Exception e) {
                            m_log.debug((Object)("endNode() : \u5b9f\u884c\u7d50\u679c\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                        }
                    }
                } else if (info.getStatus() == 2) {
                    if (sessionNode.getStatus() == 100) {
                        if (command.getError_end_flg() == 1) {
                            sessionNode.setStatus_buffer(300);
                            sessionNode.setEnd_date(new Date());
                            sessionNode.setEnd_value(command.getError_end_value());
                        } else {
                            sessionNode.setStatus_buffer(400);
                        }
                    } else if (sessionNode.getStatus() == 101) {
                        sessionNode.setStatus_buffer(201);
                    }
                    sessionNode.setMessage(info.getMessage() + info.getErrorMessage());
                }
                if (sessionNode.getAgent_check() == 2) {
                    m_log.debug((Object)("send delete history : status=" + info.getStatus() + ", sessionId=" + info.getSessionId() + ", jobId=" + info.getJobId() + ", facilityId=" + info.getFacilityId()));
                    instructionInfo = new RunInstructionInfo();
                    instructionInfo.setSessionId(sessionJob.getSession_id());
                    instructionInfo.setJobId(sessionJob.getJob_id());
                    instructionInfo.setFacilityId(sessionNode.getFacility_id());
                    instructionInfo.setCommand("");
                    if (info.getCommandType() == 0) {
                        instructionInfo.setCommandType(4);
                    } else if (info.getCommandType() == 1) {
                        instructionInfo.setCommandType(5);
                    }
                    try {
                        SendTopic send = new SendTopic("topic/clustercontrol/JobManagement/execute");
                        send.put(instructionInfo);
                    }
                    catch (Exception e) {
                        m_log.debug((Object)("endNode() : \u5c65\u6b74\u524a\u9664\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                    }
                } else {
                    m_log.debug((Object)("set status buffer : status=" + info.getStatus() + ", sessionId=" + info.getSessionId() + ", jobId=" + info.getJobId() + ", facilityId=" + info.getFacilityId()));
                    sessionNode.setStatus(sessionNode.getStatus_buffer());
                }
            }
        } else if (info.getCommandType() == 4 || info.getCommandType() == 5) {
            sessionNode.setStatus(sessionNode.getStatus_buffer());
        }
        if (sessionNode.getStatus() == 201) {
            sessionNode = null;
            if (sessionJob.getStatus() == 101 && this.checkAllNodeStop(sessionJob)) {
                sessionJob.setStatus(201);
                new OperateStopOfJob().stopJob(info.getSessionId(), info.getJobId());
                JobStartInfoLocal start = job.getJobStartInfo();
                int flg = sessionJob.getDelay_notify_flg();
                int operationFlg = DelayNotifyConstant.getOperation(flg);
                if (operationFlg == 30) {
                    new OperateMaintenanceOfJob().maintenanceJob(info.getSessionId(), info.getJobId(), null, start.getEnd_delay_operation_end_value());
                }
            }
        } else {
            String result = sessionNode.getResult();
            sessionNode = null;
            if (sessionJob.getStatus() != 200 && this.checkJobEnd(sessionJob)) {
                sessionJob = null;
                Integer endStatus = this.checkEndStatus(info.getSessionId(), info.getJobId());
                if (endStatus == 0 && info.getCommand().equals("getFileList")) {
                    new CreateFileJob().createFileJobNet(info.getSessionId(), info.getJobId(), info.getFileList());
                }
                this.setEndStaus(info.getSessionId(), info.getJobId(), 300, endStatus, result);
                new Notice().notify(info.getSessionId(), info.getJobId(), endStatus);
                this.endJob(info.getSessionId(), info.getJobId());
            }
        }
    }

    protected boolean checkJobNetEnd(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("checkJobNetEnd() : sessionId=" + sessionId + ", jobId=" + jobId));
        boolean endAll = true;
        Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
        for (JobRelationInfoLocal relation1 : sameHierarchy) {
            JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
            if (sessionJob1.getStatus() == 300 || sessionJob1.getStatus() == 301) continue;
            endAll = false;
            break;
        }
        return endAll;
    }

    protected boolean checkJobEnd(JobSessionJobLocal sessionJob) throws FinderException, NamingException {
        m_log.debug((Object)("checkJobEnd() : sessionId=" + sessionJob.getSession_id() + ", jobId=" + sessionJob.getJob_id()));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobCommandInfoLocal command = job.getJobCommandInfo();
        boolean end = false;
        if (command.getProcess_mode() == 1) {
            Integer endStatus = this.checkEndStatus(sessionJob.getSession_id(), sessionJob.getJob_id());
            if (endStatus instanceof Integer && endStatus == 0) {
                end = true;
            } else if (!this.startNode(sessionJob.getSession_id(), sessionJob.getJob_id(), null)) {
                end = true;
                end = this.checkAllNodeEnd(sessionJob);
            }
        } else {
            end = this.checkAllNodeEnd(sessionJob);
        }
        return end;
    }

    protected boolean checkAllNodeEnd(JobSessionJobLocal sessionJob) throws FinderException, NamingException {
        m_log.debug((Object)("checkAllNodeEnd() : sessionId=" + sessionJob.getSession_id() + ", jobId=" + sessionJob.getJob_id()));
        boolean end = false;
        boolean runNode = false;
        Collection collection = sessionJob.getJobSessionNode();
        if (collection != null && collection.size() > 0) {
            for (JobSessionNodeLocal sessionNode : collection) {
                if (sessionNode.getStatus() == 300 || sessionNode.getStatus() == 301) continue;
                runNode = true;
            }
        }
        if (!runNode) {
            end = true;
        }
        return end;
    }

    protected boolean checkAllNodeStop(JobSessionJobLocal sessionJob) throws FinderException, NamingException {
        m_log.debug((Object)("checkAllNodeStop() : sessionId=" + sessionJob.getSession_id() + ", jobId=" + sessionJob.getJob_id()));
        boolean stop = false;
        boolean runNode = false;
        Collection collection = sessionJob.getJobSessionNode();
        if (collection != null && collection.size() > 0) {
            for (JobSessionNodeLocal sessionNode : collection) {
                if (sessionNode.getStatus() != 101 && sessionNode.getStatus() != 100) continue;
                runNode = true;
            }
        }
        if (!runNode) {
            stop = true;
        }
        return stop;
    }

    protected void clearJob(String sessionId, String jobId) throws FinderException, NamingException, EJBException, RemoveException {
        m_log.debug((Object)("clearJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null) {
            JobInfoLocal job = sessionJob.getJobInfo();
            if (job.getJob_type() == 2) {
                int j;
                JobStartInfoLocal start;
                JobFileInfoLocal file;
                JobCommandInfoLocal command;
                JobRelationInfoLocal relation;
                Collection collection = sessionJob.getJobSessionNode();
                if (collection != null && collection.size() > 0) {
                    Object[] sessionNodeArray = collection.toArray();
                    for (int j2 = 0; j2 < sessionNodeArray.length; ++j2) {
                        JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)sessionNodeArray[j2];
                        if (sessionNode == null) continue;
                        sessionNode.remove();
                    }
                }
                if ((relation = sessionJob.getJobRelationInfo()) != null) {
                    relation.remove();
                }
                if ((command = job.getJobCommandInfo()) != null) {
                    command.remove();
                }
                if ((file = job.getJobFileInfo()) != null) {
                    file.remove();
                }
                if ((start = job.getJobStartInfo()) != null) {
                    JobStartTimeInfoLocal startTime;
                    collection = start.getJobStartJobInfo();
                    if (collection != null && collection.size() > 0) {
                        Object[] startJobArray = collection.toArray();
                        for (j = 0; j < startJobArray.length; ++j) {
                            JobStartJobInfoLocal startJob = (JobStartJobInfoLocal)startJobArray[j];
                            if (startJob == null) continue;
                            startJob.remove();
                        }
                    }
                    if ((startTime = start.getJobStartTimeInfo()) != null) {
                        startTime.remove();
                    }
                    start.remove();
                }
                if ((collection = job.getJobNoticeInfo()) != null && collection.size() > 0) {
                    Object[] noticeArray = collection.toArray();
                    for (j = 0; j < noticeArray.length; ++j) {
                        JobNoticeInfoLocal notice = (JobNoticeInfoLocal)noticeArray[j];
                        if (notice == null) continue;
                        notice.remove();
                    }
                }
                if ((collection = job.getJobEndInfo()) != null && collection.size() > 0) {
                    Object[] endArray = collection.toArray();
                    for (j = 0; j < endArray.length; ++j) {
                        JobEndInfoLocal end = (JobEndInfoLocal)endArray[j];
                        if (end == null) continue;
                        end.remove();
                    }
                }
                job.remove();
                sessionJob.remove();
            } else {
                int j;
                JobStartInfoLocal start;
                JobFileInfoLocal file;
                JobCommandInfoLocal command;
                JobRelationInfoLocal relation;
                Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
                if (collection != null && collection.size() > 0) {
                    for (JobRelationInfoLocal relation2 : collection) {
                        this.clearJob(relation2.getSession_id(), relation2.getJob_id());
                    }
                }
                if ((relation = sessionJob.getJobRelationInfo()) != null) {
                    relation.remove();
                }
                if ((command = job.getJobCommandInfo()) != null) {
                    command.remove();
                }
                if ((file = job.getJobFileInfo()) != null) {
                    file.remove();
                }
                if ((start = job.getJobStartInfo()) != null) {
                    JobStartTimeInfoLocal startTime;
                    collection = start.getJobStartJobInfo();
                    if (collection != null && collection.size() > 0) {
                        Object[] startJobArray = collection.toArray();
                        for (j = 0; j < startJobArray.length; ++j) {
                            JobStartJobInfoLocal startJob = (JobStartJobInfoLocal)startJobArray[j];
                            if (startJob == null) continue;
                            startJob.remove();
                        }
                    }
                    if ((startTime = start.getJobStartTimeInfo()) != null) {
                        startTime.remove();
                    }
                    start.remove();
                }
                if ((collection = job.getJobNoticeInfo()) != null && collection.size() > 0) {
                    Object[] noticeArray = collection.toArray();
                    for (j = 0; j < noticeArray.length; ++j) {
                        JobNoticeInfoLocal notice = (JobNoticeInfoLocal)noticeArray[j];
                        if (notice == null) continue;
                        notice.remove();
                    }
                }
                if ((collection = job.getJobEndInfo()) != null && collection.size() > 0) {
                    Object[] endArray = collection.toArray();
                    for (j = 0; j < endArray.length; ++j) {
                        JobEndInfoLocal end = (JobEndInfoLocal)endArray[j];
                        if (end == null) continue;
                        end.remove();
                    }
                }
                job.remove();
                sessionJob.remove();
            }
        }
    }

    protected void setStatus(String sessionId, String jobId, Integer status) throws FinderException, NamingException {
        m_log.debug((Object)("setStatus() : sessionId=" + sessionId + ", jobId=" + jobId + ", status=" + status));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null) {
            sessionJob.setStatus(status);
            JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
            String parentJobId = relation.getParent_job_id();
            relation = null;
            if (parentJobId.compareTo("TOP") != 0) {
                this.setStatus(sessionId, parentJobId, status);
            }
        }
    }

    public String createJobInfo(String jobId, LogOutputInfo info) throws CreateException, FinderException, NamingException {
        m_log.debug((Object)("createJobInfo() : jobId=" + jobId));
        String sessionId = null;
        Date createTime = new Date();
        JobMasterLocal job = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(jobId));
        if (job != null) {
            boolean createFlg = false;
            int i = 0;
            while (!createFlg) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    sessionId = dateFormat.format(createTime);
                    DecimalFormat format = new DecimalFormat("-000");
                    sessionId = sessionId + format.format(i);
                    JobSessionUtil.getLocalHome().create(sessionId, job.getJob_id(), new Date(), 0);
                    createFlg = true;
                }
                catch (DuplicateKeyException e) {
                }
                catch (CreateException e) {
                    if (e.getMessage().indexOf("duplicate") != -1) {
                        throw new DuplicateKeyException();
                    }
                    throw e;
                }
                ++i;
            }
            this.createJobInfo(job, "TOP", sessionId, info);
        }
        return sessionId;
    }

    protected void createJobInfo(JobMasterLocal job, String parentJobId, String sessionId, LogOutputInfo info) throws CreateException, FinderException, NamingException {
        this.createJobInfoData(job, parentJobId, sessionId, info);
        Collection collection = null;
        collection = JobRelationMasterUtil.getLocalHome().findByParentJobId(job.getJob_id());
        if (collection != null && collection.size() > 0) {
            for (JobRelationMasterLocal children : collection) {
                JobMasterLocal childJob = children.getJobMaster();
                this.createJobInfo(childJob, job.getJob_id(), sessionId, null);
            }
        }
    }

    protected void createJobInfoData(JobMasterLocal job, String parentJobId, String sessionId, LogOutputInfo info) throws CreateException, FinderException, NamingException {
        Collection endList;
        Collection noticeList;
        RepositoryControllerLocal repository = null;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(sessionId, job.getJob_id(), null, 0, null, null, null, null, null, 0, 0);
        JobRelationInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), parentJobId);
        JobInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), job.getJob_name(), job.getDescription(), job.getJob_type(), job.getReg_date(), job.getUpdate_date(), job.getReg_user(), job.getUpdate_user());
        JobStartMasterLocal start = null;
        if (parentJobId.compareTo("TOP") != 0 && (job.getJob_type() == 1 || job.getJob_type() == 2 || job.getJob_type() == 3) && (start = job.getJobStartMaster()) != null) {
            JobStartTimeMasterLocal startTime;
            JobStartInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), start.getCondition_type(), start.getSuspend(), start.getSkip(), start.getSkip_end_status(), start.getSkip_end_value(), start.getUnmatch_end_flg(), start.getUnmatch_end_status(), start.getUnmatch_end_value(), start.getCalendar(), start.getCalendar_id(), start.getCalendar_end_value(), start.getStart_delay(), start.getStart_delay_session(), start.getStart_delay_session_value(), start.getStart_delay_time(), start.getStart_delay_time_value(), start.getStart_delay_condition_type(), start.getStart_delay_notify(), start.getStart_delay_notify_priority(), start.getStart_delay_operation(), start.getStart_delay_operation_type(), start.getStart_delay_operation_end_value(), start.getEnd_delay(), start.getEnd_delay_session(), start.getEnd_delay_session_value(), start.getEnd_delay_job(), start.getEnd_delay_job_value(), start.getEnd_delay_time(), start.getEnd_delay_time_value(), start.getEnd_delay_condition_type(), start.getEnd_delay_notify(), start.getEnd_delay_notify_priority(), start.getEnd_delay_operation(), start.getEnd_delay_operation_type(), start.getEnd_delay_operation_end_value());
            Collection startJobList = start.getJobStartJobMaster();
            if (startJobList != null && startJobList.size() > 0) {
                for (JobStartJobMasterLocal startJob : startJobList) {
                    if (startJob == null) continue;
                    JobStartJobInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), startJob.getTarget_job_id(), startJob.getTarget_job_type(), startJob.getTarget_job_end_value());
                }
            }
            if ((startTime = start.getJobStartTimeMaster()) != null) {
                JobStartTimeInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), startTime.getStart_time());
            }
            if (start.getSuspend() == 1) {
                sessionJob.setStatus(1);
            } else if (start.getSkip() == 1) {
                sessionJob.setStatus(2);
                sessionJob.setEnd_value(start.getSkip_end_value());
            }
        }
        if (parentJobId.equals("TOP")) {
            String topJobId = this.getTopJob(job);
            Collection paramList = JobParamMasterUtil.getLocalHome().findByJobId(topJobId);
            if (paramList != null) {
                for (JobParamMasterLocal param : paramList) {
                    if (param == null) continue;
                    String value = null;
                    if (param.getParam_type() == 0) {
                        if (param.getParam_id().equals("START_DATE")) {
                            JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
                            value = DateFormat.getDateTimeInstance().format(session.getSchedule_date());
                        } else {
                            value = ParameterUtil.getParameterValue(param.getParam_id(), info);
                        }
                    } else {
                        value = param.getValue();
                    }
                    JobParamInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), param.getParam_id(), param.getParam_type(), param.getDescription(), value);
                }
            }
        }
        JobCommandMasterLocal command = null;
        if (job.getJob_type() == 2) {
            command = job.getJobCommandMaster();
            if (command != null) {
                JobCommandInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), command.getFacility_id(), command.getProcess_mode(), command.getStart_command(), command.getStop_command(), command.getEffective_user(), command.getError_end_flg(), command.getError_end_value(), command.getArgument_job_id(), command.getArgument());
            }
            if (repository == null) {
                repository = RepositoryControllerUtil.getLocalHome().create();
            }
            String facilityId = null;
            facilityId = command.getFacility_id().equals("${FACILITY_ID}") ? ParameterUtil.getSessionParameterValue(sessionId, "FACILITY_ID") : command.getFacility_id();
            sessionJob.setScope_text(repository.getFacilityPath(facilityId, null));
            ArrayList nodeIdList = null;
            if (repository.isNode(facilityId)) {
                nodeIdList = new ArrayList();
                nodeIdList.add(facilityId);
            } else {
                nodeIdList = repository.getNodeFacilityIdList(facilityId, 0);
            }
            if (nodeIdList instanceof ArrayList) {
                for (int i = 0; i < nodeIdList.size(); ++i) {
                    ArrayList<String> Attribute2 = new ArrayList<String>();
                    Attribute2.add("cn");
                    HashMap map = repository.getNodeDetail((String)nodeIdList.get(i), Attribute2);
                    JobSessionNodeUtil.getLocalHome().create(sessionId, job.getJob_id(), (String)nodeIdList.get(i), (String)map.get("cn"), 0, null, null, null, null, null, null, 0, null, null);
                }
            }
        }
        JobFileMasterLocal file = null;
        if (job.getJob_type() == 3) {
            file = job.getJobFileMaster();
            if (file != null) {
                JobFileInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), file.getProcess_mode(), file.getSrc_facility_id(), file.getDest_facility_id(), file.getSrc_file(), file.getSrc_work_dir(), file.getDest_directory(), file.getDest_work_dir(), file.getCompression_flg(), file.getCheck_flg(), file.getEffective_user());
            }
            new CreateFileJob().createGetFileListJob(job, sessionId);
        }
        if ((noticeList = job.getJobNoticeMaster()) != null) {
            for (JobNoticeMasterLocal notice : noticeList) {
                if (notice == null) continue;
                JobNoticeInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), notice.getNotice_type(), notice.getPriority(), notice.getNotify_id());
            }
        }
        if ((endList = job.getJobEndMaster()) != null) {
            for (JobEndMasterLocal end : endList) {
                if (end == null) continue;
                JobEndInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), end.getEnd_status(), end.getEnd_value(), end.getEnd_value_from(), end.getEnd_value_to());
            }
        }
    }

    protected String getTopJob(JobMasterLocal job) throws FinderException, NamingException {
        JobRelationMasterLocal relation = job.getJobRelationMaster();
        if (relation.getParent_job_id().equals("TOP")) {
            return job.getJob_id();
        }
        JobMasterLocal parentJob = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(relation.getParent_job_id()));
        return this.getTopJob(parentJob);
    }

    protected boolean checkCalendar(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("checkCalendar() : sessionId=" + sessionId + ", jobId=" + jobId));
        boolean check = false;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobSessionLocal session = sessionJob.getJobSession();
        JobInfoLocal job = sessionJob.getJobInfo();
        JobStartInfoLocal start = job.getJobStartInfo();
        if (start.getCalendar() == 1) {
            try {
                CalendarControllerLocal calendar = CalendarControllerUtil.getLocalHome().create();
                if (calendar.isRun(start.getCalendar_id(), session.getSchedule_date()).booleanValue()) {
                    check = true;
                }
            }
            catch (FinderException e) {
            }
            catch (CreateException e) {
            }
            catch (NamingException e) {}
        } else {
            check = true;
        }
        if (!check) {
            sessionJob.setStatus(300);
            sessionJob.setEnd_date(new Date());
            sessionJob.setEnd_value(start.getCalendar_end_value());
            sessionJob = null;
            this.endJob(sessionId, jobId);
        }
        return check;
    }
}

