/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.quartzmanager.ejb.session;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public abstract class QuartzManagerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(QuartzManagerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public void addSchedule(JobDetail job, Trigger trigger) throws NamingException, SchedulerException {
        m_log.debug((Object)"addSchedule() : start");
        Scheduler scheduler = this.getScheduler();
        scheduler.scheduleJob(job, trigger);
    }

    public void deleteSchedule(String jobName, String jobGroup) throws NamingException, SchedulerException {
        m_log.debug((Object)("deleteSchedule() : Job Group =" + jobGroup + "Job Name =" + jobName));
        Scheduler scheduler = this.getScheduler();
        scheduler.deleteJob(jobName, jobGroup);
    }

    public void pauseSchedule(String jobName, String jobGroup) throws NamingException, SchedulerException {
        m_log.debug((Object)("deleteSchedule() : Job Group =" + jobGroup + "Job Name =" + jobName));
        Scheduler scheduler = this.getScheduler();
        scheduler.pauseJob(jobName, jobGroup);
    }

    public JobDetail getJobDetail(String jobName, String jobGroup) throws NamingException, SchedulerException {
        m_log.debug((Object)("getJobDetail() : Job Group =" + jobGroup + "Job Name =" + jobName));
        Scheduler scheduler = this.getScheduler();
        JobDetail jobDetail = scheduler.getJobDetail(jobName, jobGroup);
        return jobDetail;
    }

    public String[] getJobs(String jobGroup) throws NamingException, SchedulerException {
        m_log.debug((Object)("getJobs() : Job Group =" + jobGroup));
        Scheduler scheduler = this.getScheduler();
        String[] jobs = scheduler.getJobNames(jobGroup);
        return jobs;
    }

    public Scheduler getScheduler() throws NamingException {
        InitialContext context = new InitialContext();
        Scheduler scheduler = (Scheduler)context.lookup("Quartz");
        return scheduler;
    }
}

