/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.composite.CommonTableTreeViewer;
import com.clustercontrol.jobmanagement.action.GetJobDetail;
import com.clustercontrol.jobmanagement.action.GetJobDetailTableDefine;
import com.clustercontrol.jobmanagement.composite.action.JobDetailSelectionChangedListener;
import com.clustercontrol.jobmanagement.composite.action.SessionJobDoubleClickListener;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class DetailComposite
extends Composite {
    protected CommonTableTreeViewer m_viewer = null;
    protected String m_sessionId = null;
    protected String m_jobId = null;
    protected Label m_sessionIdLabel = null;

    public DetailComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_sessionIdLabel = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.m_sessionIdLabel.setLayoutData((Object)gridData);
        TableTree tree = new TableTree((Composite)this, 66308);
        Table table = tree.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        tree.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableTreeViewer(tree);
        this.m_viewer.createTableColumn(GetJobDetailTableDefine.get(), 4, 1);
        this.m_viewer.addSelectionChangedListener((ISelectionChangedListener)new JobDetailSelectionChangedListener(this));
        this.m_viewer.addDoubleClickListener((IDoubleClickListener)new SessionJobDoubleClickListener(this));
        this.update(null);
    }

    public void update(String sessionId) {
        GetJobDetail getJobDetail = new GetJobDetail();
        CommonTableTreeItem item = null;
        if (sessionId != null && sessionId.length() > 0) {
            item = getJobDetail.getJobDetail(sessionId);
        }
        this.m_viewer.setInput(item);
        this.m_viewer.expandAll();
        if (this.m_sessionId != null && this.m_sessionId.length() > 0 && sessionId != null && sessionId.length() > 0 && this.m_sessionId.compareTo(sessionId) == 0) {
            this.selectDetail(item);
        } else {
            this.setJobId(null);
        }
        this.m_sessionId = sessionId;
        if (this.m_sessionId != null) {
            this.m_sessionIdLabel.setText(String.valueOf(Messages.getString((String)"session.id")) + " : " + this.m_sessionId);
        } else {
            this.m_sessionIdLabel.setText(String.valueOf(Messages.getString((String)"session.id")) + " : ");
        }
    }

    public void selectDetail(CommonTableTreeItem item) {
        if (this.getJobId() != null && this.getJobId().length() > 0 && this.m_viewer.getSelection().isEmpty()) {
            boolean select = false;
            ArrayList list = item.getData();
            if (list instanceof ArrayList) {
                String jobId = (String)list.get(4);
                if (this.getJobId().compareTo(jobId) == 0) {
                    select = true;
                }
            }
            if (select) {
                this.m_viewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
            } else {
                int i = 0;
                while (i < item.getChildren().length) {
                    CommonTableTreeItem children = item.getChildren()[i];
                    this.selectDetail(children);
                    ++i;
                }
            }
        }
    }

    public TableTreeViewer getTableTreeViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTableTree().getTable();
    }

    public TableTree getTableTree() {
        return this.m_viewer.getTableTree();
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(String sessionId) {
        this.m_sessionId = sessionId;
    }

    public String getJobId() {
        return this.m_jobId;
    }

    public void setJobId(String jobId) {
        this.m_jobId = jobId;
    }
}

