/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.http.ejb.session;

import com.clustercontrol.http.factory.AddMonitorHttp;
import com.clustercontrol.http.factory.AddMonitorHttpString;
import com.clustercontrol.http.factory.DeleteMonitorHttp;
import com.clustercontrol.http.factory.DeleteMonitorHttpString;
import com.clustercontrol.http.factory.ModifyMonitorHttp;
import com.clustercontrol.http.factory.ModifyMonitorHttpString;
import com.clustercontrol.http.factory.SelectMonitorHttp;
import com.clustercontrol.http.factory.SelectMonitorHttpString;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class MonitorHttpControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(MonitorHttpControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public boolean addHttp(MonitorInfo info) throws InvalidTransactionException, IllegalStateException, CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        Object http = null;
        if (info.getMonitorType() == 1) {
            http = new AddMonitorHttp();
        } else if (info.getMonitorType() == 2) {
            http = new AddMonitorHttpString();
        } else {
            return false;
        }
        return http.add(info, pri.getName());
    }

    public boolean modifyHttp(MonitorInfo info) throws InvalidTransactionException, IllegalStateException, CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        Object http = null;
        if (info.getMonitorType() == 1) {
            http = new ModifyMonitorHttp();
        } else if (info.getMonitorType() == 2) {
            http = new ModifyMonitorHttpString();
        } else {
            return false;
        }
        return http.modify(info, pri.getName());
    }

    public boolean deleteHttp(String monitorId, int monitorType) throws InvalidTransactionException, IllegalStateException, FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
        Object http = null;
        if (monitorType == 1) {
            http = new DeleteMonitorHttp();
        } else if (monitorType == 2) {
            http = new DeleteMonitorHttpString();
        } else {
            return false;
        }
        return http.delete("HTTP", monitorId);
    }

    public MonitorInfo getHttpInfo(String monitorId, int monitorType) throws CreateException, FinderException, SchedulerException, NamingException {
        Object http = null;
        if (monitorType == 1) {
            http = new SelectMonitorHttp();
        } else if (monitorType == 2) {
            http = new SelectMonitorHttpString();
        } else {
            return null;
        }
        MonitorInfo info = http.getMonitor("HTTP", monitorId);
        return info;
    }

    public ArrayList getHttpList() throws CreateException, FinderException, SchedulerException, NamingException {
        SelectMonitorHttp http = new SelectMonitorHttp();
        ArrayList list = http.getMonitorList("HTTP");
        return list;
    }

    public ArrayList getHttpListTableDefine(Locale locale) {
        SelectMonitorHttp http = new SelectMonitorHttp();
        ArrayList tableDefine = http.getMonitorListTableDefine(locale);
        return tableDefine;
    }

    public ArrayList getHttpStringValueListTableDefine(Locale locale) {
        SelectMonitorHttpString http = new SelectMonitorHttpString();
        ArrayList tableDefine = http.getStringValueListTableDefine(locale);
        return tableDefine;
    }
}

