/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;

public class ResolverImport {
    private ImportPackageSpecification importPackageSpecification;
    private ResolverExport matchingExport;
    private ResolverBundle bundle;
    private ArrayList unresolvableWirings = new ArrayList();
    private String name = null;

    ResolverImport(ResolverBundle bundle, ImportPackageSpecification ips) {
        this.bundle = bundle;
        this.importPackageSpecification = ips;
    }

    boolean isFromFragment() {
        return this.importPackageSpecification.getBundle().getHost() != null;
    }

    String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.importPackageSpecification.getName();
    }

    void setName(String name) {
        this.name = name;
    }

    ResolverBundle getBundle() {
        return this.bundle;
    }

    BundleDescription getActualBundle() {
        return this.bundle.getBundle();
    }

    boolean isSatisfiedBy(ResolverExport re) {
        if (!this.bundle.getResolver().getPermissionChecker().checkImportPermission(this.importPackageSpecification, re.getExportPackageDescription())) {
            return false;
        }
        return this.importPackageSpecification.isSatisfiedBy(re.getExportPackageDescription());
    }

    ResolverExport getMatchingExport() {
        return this.matchingExport;
    }

    void setMatchingExport(ResolverExport matchingExport) {
        this.matchingExport = matchingExport;
    }

    boolean isOnRootPathSplit(ResolverBundle bundle, ResolverBundle toFind) {
        if (bundle == null) {
            return false;
        }
        BundleConstraint[] requires = bundle.getRequires();
        int i = 0;
        while (i < requires.length) {
            if (requires[i].getMatchingBundle() == toFind) {
                return true;
            }
            if (this.isOnRootPathSplit(requires[i].getMatchingBundle(), toFind)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void addUnresolvableWiring(ResolverBundle module) {
        this.unresolvableWirings.add(module);
    }

    void removeUnresolvableWiring(ResolverBundle module) {
        this.unresolvableWirings.remove(module);
    }

    void clearUnresolvableWirings() {
        this.unresolvableWirings = new ArrayList();
    }

    boolean isNotAnUnresolvableWiring(ResolverExport exp) {
        return !this.unresolvableWirings.contains(exp.getExporter());
    }

    ImportPackageSpecification getImportPackageSpecification() {
        return this.importPackageSpecification;
    }

    boolean isOptional() {
        return "optional".equals(this.importPackageSpecification.getDirective("resolution"));
    }

    boolean isDynamic() {
        return "dynamic".equals(this.importPackageSpecification.getDirective("resolution"));
    }

    public String toString() {
        return this.importPackageSpecification.toString();
    }
}

