/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.util.Log;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class ArrayObjectDescription
extends AbstractObjectDescription {
    static /* synthetic */ Class class$java$lang$Object;

    public ArrayObjectDescription(Class clazz) {
        super(clazz);
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Need an array class");
        }
    }

    public Object createObject() {
        try {
            Integer n = (Integer)this.getParameter("size");
            if (n == null) {
                Object object;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n2 = 0;
                while (this.getParameterDefinition(String.valueOf(n2)) != null && (object = this.getParameter(String.valueOf(n2))) != null) {
                    arrayList.add(object);
                    ++n2;
                }
                object = Array.newInstance(this.getObjectClass().getComponentType(), arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    Array.set(object, i, arrayList.get(i));
                }
                return object;
            }
            Object object = Array.newInstance(this.getObjectClass().getComponentType(), (int)n);
            for (int i = 0; i < n; ++i) {
                Array.set(object, i, this.getParameter(String.valueOf(i)));
            }
            return object;
        }
        catch (Exception exception) {
            Log.warn("Unable to instantiate Object", exception);
            return null;
        }
    }

    public void setParameterFromObject(Object object) throws ObjectFactoryException {
        if (object == null) {
            throw new ObjectFactoryException("Given object is null.");
        }
        if (!object.getClass().isArray()) {
            throw new ObjectFactoryException("Given object is no array");
        }
        if (!this.getObjectClass().isAssignableFrom(object.getClass())) {
            throw new ObjectFactoryException("Given object is incompatible with base class");
        }
        int n = Array.getLength(object);
        this.setParameter("size", new Integer(n));
        for (int i = 0; i < n; ++i) {
            this.setParameter(String.valueOf(i), Array.get(object, i));
        }
    }

    private int parseParameterName(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public Class getParameterDefinition(String string) {
        if (string.equals("size")) {
            return Integer.TYPE;
        }
        int n = this.parseParameterName(string);
        if (n < 0) {
            return null;
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = ArrayObjectDescription.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Iterator getParameterNames() {
        Integer n = (Integer)this.getParameter("size");
        if (n == null) {
            return this.getDefinedParameterNames();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("size");
        for (int i = 0; i < n; ++i) {
            arrayList.add(String.valueOf(i));
        }
        return arrayList.iterator();
    }

    public ObjectDescription getInstance() {
        return new ArrayObjectDescription(this.getObjectClass());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

