/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;

public class ZipLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private ZipFile zipFile;
    private ZipEntry root = new ZipEntry("/");
    private Map children;
    private Map directoryEntryCache = new HashMap();
    private int stripLevel;

    public ZipLeveledStructureProvider(ZipFile sourceFile) {
        this.zipFile = sourceFile;
        this.stripLevel = 0;
    }

    protected void addToChildren(ZipEntry parent, ZipEntry child) {
        ArrayList<ZipEntry> childList = (ArrayList<ZipEntry>)this.children.get(parent);
        if (childList == null) {
            childList = new ArrayList<ZipEntry>();
            this.children.put(parent, childList);
        }
        childList.add(child);
    }

    protected void createContainer(IPath pathname) {
        if (this.directoryEntryCache.containsKey(pathname)) {
            return;
        }
        ZipEntry parent = pathname.segmentCount() == 1 ? this.root : (ZipEntry)this.directoryEntryCache.get(pathname.removeLastSegments(1));
        ZipEntry newEntry = new ZipEntry(pathname.toString());
        this.directoryEntryCache.put(pathname, newEntry);
        this.addToChildren(parent, newEntry);
    }

    protected void createFile(ZipEntry entry) {
        Path pathname = new Path(entry.getName());
        ZipEntry parent = pathname.segmentCount() == 1 ? this.root : (ZipEntry)this.directoryEntryCache.get(pathname.removeLastSegments(1));
        this.addToChildren(parent, entry);
    }

    public List getChildren(Object element) {
        if (this.children == null) {
            this.initialize();
        }
        return (List)this.children.get(element);
    }

    public InputStream getContents(Object element) {
        try {
            return this.zipFile.getInputStream((ZipEntry)element);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String stripPath(String path) {
        String pathOrig = new String(path);
        int i = 0;
        while (i < this.stripLevel) {
            int firstSep = path.indexOf(47);
            if (firstSep == 0) {
                path = path.substring(1);
                firstSep = path.indexOf(47);
            }
            if (firstSep == -1) {
                return pathOrig;
            }
            path = path.substring(firstSep);
            ++i;
        }
        return path;
    }

    public String getFullPath(Object element) {
        return this.stripPath(((ZipEntry)element).getName());
    }

    public String getLabel(Object element) {
        if (element.equals(this.root)) {
            return ((ZipEntry)element).getName();
        }
        return this.stripPath(new Path(((ZipEntry)element).getName()).lastSegment());
    }

    public Object getRoot() {
        return this.root;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    protected void initialize() {
        this.children = new HashMap(1000);
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            IPath path = new Path(entry.getName()).addTrailingSeparator();
            int pathSegmentCount = path.segmentCount();
            int i = 1;
            while (i < pathSegmentCount) {
                this.createContainer(path.uptoSegment(i));
                ++i;
            }
            this.createFile(entry);
        }
    }

    public boolean isFolder(Object element) {
        return ((ZipEntry)element).isDirectory();
    }

    public void setStrip(int level) {
        this.stripLevel = level;
    }

    public int getStrip() {
        return this.stripLevel;
    }
}

