/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.SortUtil;

final class DeferredQueue {
    private static final String SETTING_CONTENTS = Messages.getString("DeferredQueue.setting_contents");
    private static final int MAX_UPDATE = 40;
    private static final int MIN_UPDATE = 1;
    private static final int GROWTH_LIMIT = 20000;
    private Comparator sortOrder;
    private Set visibleItems = new HashSet();
    private Set insertionsAtEnd = new HashSet();
    private Set insertionsInMiddle = new HashSet();
    private Set pendingRemovals = new HashSet();
    private Set pendingChanges = new HashSet();
    private Object lastVisible = null;
    private boolean lastDirty = false;
    private TableViewer viewer;
    private boolean hasPendingChanges = false;

    public DeferredQueue(TableViewer viewer) {
        this.viewer = viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getVisibleItems() {
        Set set = this.visibleItems;
        synchronized (set) {
            return this.visibleItems.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(Collection changes) {
        Iterator iter = changes.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            boolean isVisible = false;
            Set set = this.visibleItems;
            synchronized (set) {
                if (this.visibleItems.contains(next)) {
                    this.visibleItems.remove(next);
                    this.visibleItems.add(next);
                    this.pendingChanges.add(next);
                    isVisible = true;
                    this.hasPendingChanges = true;
                }
            }
            if (isVisible) continue;
            if (this.insertionsInMiddle.contains(next)) {
                this.insertionsInMiddle.remove(next);
                this.insertionsInMiddle.add(next);
                this.hasPendingChanges = true;
                continue;
            }
            if (!this.insertionsAtEnd.contains(next)) continue;
            this.insertionsAtEnd.remove(next);
            this.insertionsAtEnd.add(next);
            this.hasPendingChanges = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Collection newPendingContents, IProgressMonitor mon) {
        mon.beginTask(SETTING_CONTENTS, 100);
        HashSet newInsertions = new HashSet();
        HashSet newPendingRemovals = new HashSet();
        HashSet newInsertionsInMiddle = new HashSet();
        Set newInsertionsAtEnd = this.newEndSet();
        DeferredQueue.addWithProgress(newInsertions, newPendingContents, mon, 5);
        Set set = this.visibleItems;
        synchronized (set) {
            DeferredQueue.addWithProgress(newPendingRemovals, this.visibleItems, mon, 5);
            DeferredQueue.removeWithProgress(newPendingRemovals, newInsertions, mon, 5);
            DeferredQueue.removeWithProgress(newInsertions, this.visibleItems, mon, 5);
        }
        if (newInsertions.isEmpty() && newPendingRemovals.isEmpty()) {
            return;
        }
        SubProgressMonitor sub = new SubProgressMonitor(mon, 80);
        SortUtil.partition(newInsertionsInMiddle, newInsertionsAtEnd, newInsertionsAtEnd, newInsertions, this.sortOrder, this.lastVisible, (IProgressMonitor)sub);
        if (mon.isCanceled()) {
            mon.done();
            return;
        }
        this.hasPendingChanges = true;
        this.lastDirty = false;
        this.insertionsAtEnd.clear();
        this.insertionsAtEnd = newInsertionsAtEnd;
        this.insertionsInMiddle.clear();
        this.insertionsInMiddle = newInsertionsInMiddle;
        this.pendingRemovals.clear();
        this.pendingRemovals = newPendingRemovals;
        mon.done();
    }

    private int nextChange(int maximumToChange) {
        List result = SortUtil.removeFirst(this.pendingChanges, maximumToChange);
        this.viewer.update(result.toArray(), null);
        return result.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextRemoval(int maximumToRemove) {
        ArrayList result = new ArrayList(maximumToRemove);
        int counter = maximumToRemove;
        Iterator iter = this.pendingRemovals.iterator();
        while (iter.hasNext() && counter > 0) {
            Object next = iter.next();
            result.add(next);
            if (this.lastVisible != null && this.lastVisible.equals(next)) {
                this.lastDirty = true;
            }
            iter.remove();
            --counter;
        }
        Set set = this.visibleItems;
        synchronized (set) {
            this.visibleItems.removeAll(result);
        }
        this.viewer.remove(result.toArray());
        if (this.lastDirty) {
            this.lastVisible = this.viewer.getElementAt(this.viewer.getTable().getItemCount() - 1);
        }
        return result.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextInsertionInMiddle(int maximumToInsert) {
        this.refreshQueues((IProgressMonitor)new NullProgressMonitor());
        List result = SortUtil.removeFirst(this.insertionsInMiddle, maximumToInsert);
        Set set = this.visibleItems;
        synchronized (set) {
            this.visibleItems.addAll(result);
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            int insertionPos = this.getInsertPosition(element);
            this.viewer.insert(element, insertionPos);
        }
        return result.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextInsertionAtEnd(int maximumToInsert) {
        this.refreshQueues((IProgressMonitor)new NullProgressMonitor());
        ArrayList<Object> result = new ArrayList<Object>(maximumToInsert);
        Iterator iter = this.insertionsAtEnd.iterator();
        int counter = 0;
        while (counter < maximumToInsert && iter.hasNext()) {
            this.lastVisible = iter.next();
            result.add(this.lastVisible);
            iter.remove();
            ++counter;
        }
        Set set = this.visibleItems;
        synchronized (set) {
            this.visibleItems.addAll(result);
        }
        this.viewer.add(result.toArray());
        return result.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Set set = this.visibleItems;
        synchronized (set) {
            this.visibleItems.removeAll(this.pendingRemovals);
            this.insertionsInMiddle.addAll(this.visibleItems);
            this.lastVisible = null;
            this.lastDirty = true;
            this.visibleItems.clear();
        }
        this.pendingRemovals.clear();
        this.hasPendingChanges = true;
    }

    public boolean hasPendingChanges() {
        return this.hasPendingChanges;
    }

    public int workRemaining() {
        return this.pendingRemovals.size() + this.insertionsAtEnd.size() + this.insertionsInMiddle.size() + this.pendingChanges.size();
    }

    public void cancelPending() {
        this.insertionsAtEnd.clear();
        this.insertionsInMiddle.clear();
        this.pendingRemovals.clear();
        this.hasPendingChanges = false;
    }

    public void setComparator(Comparator c) {
        if (this.sortOrder == c) {
            return;
        }
        this.sortOrder = c;
        this.lastVisible = null;
        this.insertionsInMiddle.addAll(this.insertionsAtEnd);
        this.insertionsAtEnd = this.newEndSet();
        this.lastDirty = true;
        this.reset();
    }

    public void refreshQueues(IProgressMonitor mon) {
        if (this.lastDirty) {
            if (mon.isCanceled()) {
                return;
            }
            HashSet newInsertionsInMiddle = new HashSet();
            SortUtil.partition(newInsertionsInMiddle, this.insertionsAtEnd, this.insertionsAtEnd, this.insertionsInMiddle, this.sortOrder, this.lastVisible, mon);
            if (mon.isCanceled()) {
                this.insertionsInMiddle.removeAll(this.insertionsAtEnd);
            } else {
                this.insertionsInMiddle = newInsertionsInMiddle;
                this.lastDirty = false;
            }
        }
    }

    private int getInsertPosition(Object element) {
        Table table = this.viewer.getTable();
        if (this.sortOrder == null) {
            return table.getItemCount();
        }
        int count = table.getItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = table.getItem(mid).getData();
            int compare = this.sortOrder.compare(data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = table.getItem(mid).getData();
                    compare = this.sortOrder.compare(data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    public int nextUpdate() {
        int pendingRemovalsSize = this.pendingRemovals.size();
        if (pendingRemovalsSize > 0) {
            int currentSize = this.countVisibleItems();
            int finalSize = currentSize - pendingRemovalsSize;
            if (finalSize * finalSize * 2 <= currentSize * currentSize) {
                this.reset();
                this.getViewer().refresh();
                return 0;
            }
            return this.nextRemoval(this.nextUpdateSize());
        }
        if (this.insertionsInMiddle.size() > 0) {
            return this.nextInsertionInMiddle(this.nextUpdateSize());
        }
        if (this.insertionsAtEnd.size() > 0) {
            return this.nextInsertionAtEnd(40);
        }
        if (this.pendingChanges.size() > 0) {
            return this.nextChange(40);
        }
        this.hasPendingChanges = false;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countVisibleItems() {
        Set set = this.visibleItems;
        synchronized (set) {
            return this.visibleItems.size();
        }
    }

    private int nextUpdateSize() {
        int size = 780000 / (20000 + this.countVisibleItems()) + 1;
        return size;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private Set newEndSet() {
        if (this.sortOrder == null) {
            return new HashSet();
        }
        return new TreeSet(this.sortOrder);
    }

    private static void removeWithProgress(Collection target, Collection toRemove, IProgressMonitor mon, int worked) {
        if (mon.isCanceled()) {
            return;
        }
        target.removeAll(toRemove);
        mon.worked(worked);
    }

    private static void addWithProgress(Collection target, Collection toInsert, IProgressMonitor mon, int worked) {
        if (mon.isCanceled()) {
            return;
        }
        target.addAll(toInsert);
        mon.worked(worked);
    }

    public Comparator getSorter() {
        return this.sortOrder;
    }
}

