/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jndi;

import java.security.Principal;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.jnp.interfaces.NamingContextFactory;

public class LoginInitialContextFactory
extends NamingContextFactory {
    public Context getInitialContext(Hashtable env) throws NamingException {
        String protocol = "other";
        Object prop = env.get("java.naming.security.protocol");
        if (prop != null) {
            protocol = prop.toString();
        }
        Object credentials = env.get("java.naming.security.credentials");
        Object principal = env.get("java.naming.security.principal");
        try {
            String username;
            if (principal instanceof Principal) {
                Principal p = (Principal)principal;
                username = p.getName();
            } else {
                username = principal.toString();
            }
            UsernamePasswordHandler handler = new UsernamePasswordHandler(username, credentials);
            LoginContext lc = new LoginContext(protocol, handler);
            lc.login();
        }
        catch (LoginException e) {
            AuthenticationException ex = new AuthenticationException("Failed to login using protocol=" + protocol);
            ex.setRootCause(e);
            throw ex;
        }
        Context iniCtx = super.getInitialContext(env);
        return iniCtx;
    }
}

