/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.composite.PositiveRealNumberVerifyListener;
import com.clustercontrol.composite.RealNumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NumericValueInfoComposite
extends Composite {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    public static final int INPUT_VERIFICATION_INTEGER_NUMBER = 0;
    public static final int INPUT_VERIFICATION_REAL_NUMBER = 1;
    public static final int INPUT_VERIFICATION_POSITIVE_INTEGER = 2;
    public static final int INPUT_VERIFICATION_POSITIVE_REAL = 3;
    private boolean m_rangeFlg = false;
    private String m_itemName1 = null;
    private String m_itemName2 = null;
    private String m_criterion1 = Messages.getString("greater");
    private String m_criterion2 = Messages.getString("less");
    private int m_inputVerifyType1 = 0;
    private int m_inputVerifyType2 = 0;
    private Double m_value1Info = null;
    private Double m_value2Info = null;
    private Double m_value1Warn = null;
    private Double m_value2Warn = null;
    private Text m_textValue1Info = null;
    private Text m_textValue2Info = null;
    private Text m_textValue1Warn = null;
    private Text m_textValue2Warn = null;
    private Combo m_comboFailurePriority = null;
    private VerifyListener m_verifyListener1 = null;
    private VerifyListener m_verifyListener2 = null;

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, int inputVerifyType) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_inputVerifyType1 = inputVerifyType;
        this.m_inputVerifyType2 = inputVerifyType;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, int inputVerifyType1, int inputVerifyType2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_inputVerifyType1 = inputVerifyType1;
        this.m_inputVerifyType2 = inputVerifyType2;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, String criterion1, String criterion2, int inputVerifyType1, int inputVerifyType2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_criterion1 = criterion1;
        this.m_criterion2 = criterion2;
        this.m_inputVerifyType1 = inputVerifyType1;
        this.m_inputVerifyType2 = inputVerifyType2;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, int inputVerifyType, Double inputValue1, Double inputValue2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_inputVerifyType1 = inputVerifyType;
        this.m_inputVerifyType2 = inputVerifyType;
        this.m_value1Info = inputValue1;
        this.m_value1Warn = inputValue1;
        this.m_value2Info = inputValue2;
        this.m_value2Warn = inputValue2;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, int inputVerifyType1, int inputVerifyType2, Double inputValue1Info, Double inputValue2Info, Double inputValue1Warn, Double inputValue2Warn) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_inputVerifyType1 = inputVerifyType1;
        this.m_inputVerifyType2 = inputVerifyType2;
        this.m_value1Info = inputValue1Info;
        this.m_value1Warn = inputValue1Warn;
        this.m_value2Info = inputValue2Info;
        this.m_value2Warn = inputValue2Warn;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, String criterion1, String criterion2, int inputVerifyType1, int inputVerifyType2, Double inputValue1Info, Double inputValue2Info, Double inputValue1Warn, Double inputValue2Warn) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_criterion1 = criterion1;
        this.m_criterion2 = criterion2;
        this.m_inputVerifyType1 = inputVerifyType1;
        this.m_inputVerifyType2 = inputVerifyType2;
        this.m_value1Info = inputValue1Info;
        this.m_value1Warn = inputValue1Warn;
        this.m_value2Info = inputValue2Info;
        this.m_value2Warn = inputValue2Warn;
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("successful.select.value")) + " : ");
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("priority"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_itemName1);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_itemName2);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_verifyListener1 = this.m_inputVerifyType1 == 1 ? new RealNumberVerifyListener() : (this.m_inputVerifyType1 == 2 ? new PositiveNumberVerifyListener() : (this.m_inputVerifyType1 == 3 ? new PositiveRealNumberVerifyListener() : new NumberVerifyListener()));
        this.m_verifyListener2 = this.m_inputVerifyType2 == 1 ? new RealNumberVerifyListener() : (this.m_inputVerifyType2 == 2 ? new PositiveNumberVerifyListener() : (this.m_inputVerifyType2 == 3 ? new PositiveRealNumberVerifyListener() : new NumberVerifyListener()));
        label = this.getLabelPriority(this, Messages.getString("info"), PriorityColorConstant.COLOR_INFO);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textValue1Info = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textValue1Info.addVerifyListener(this.m_verifyListener1);
        this.m_textValue1Info.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_criterion1);
        this.m_textValue2Info = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textValue2Info.addVerifyListener(this.m_verifyListener2);
        this.m_textValue2Info.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_criterion2);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = this.getLabelPriority(this, Messages.getString("warning"), PriorityColorConstant.COLOR_WARNING);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textValue1Warn = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textValue1Warn.addVerifyListener(this.m_verifyListener1);
        this.m_textValue1Warn.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_criterion1);
        this.m_textValue2Warn = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textValue2Warn.addVerifyListener(this.m_verifyListener2);
        this.m_textValue2Warn.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_criterion2);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = this.getLabelPriority(this, Messages.getString("critical"), PriorityColorConstant.COLOR_CRITICAL);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("other.priority"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString("failure.select.value")) + " : ");
        this.m_comboFailurePriority = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboFailurePriority.setLayoutData((Object)gridData);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_WARNING);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_INFO);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboFailurePriority.setText(PriorityConstant.STRING_WARNING);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    public void setInputData(MonitorInfo info) {
        if (info != null) {
            ArrayList list = info.getJudgementInfo();
            if (list != null) {
                int index = 0;
                while (index < list.size()) {
                    MonitorNumericValueInfo numericValueInfo = (MonitorNumericValueInfo)list.get(index);
                    if (numericValueInfo != null) {
                        String upper;
                        String lower;
                        if (3 == numericValueInfo.getPriority()) {
                            lower = "";
                            upper = "";
                            lower = this.m_inputVerifyType1 == 0 || this.m_inputVerifyType1 == 2 ? Long.toString(Double.valueOf(numericValueInfo.getThresholdLowerLimit()).longValue()) : Double.toString(numericValueInfo.getThresholdLowerLimit());
                            upper = this.m_inputVerifyType2 == 0 || this.m_inputVerifyType2 == 2 ? Long.toString(Double.valueOf(numericValueInfo.getThresholdUpperLimit()).longValue()) : Double.toString(numericValueInfo.getThresholdUpperLimit());
                            this.m_textValue1Info.setText(lower);
                            this.m_textValue2Info.setText(upper);
                        } else if (2 == numericValueInfo.getPriority()) {
                            lower = "";
                            upper = "";
                            lower = this.m_inputVerifyType1 == 0 || this.m_inputVerifyType1 == 2 ? Long.toString(Double.valueOf(numericValueInfo.getThresholdLowerLimit()).longValue()) : Double.toString(numericValueInfo.getThresholdLowerLimit());
                            upper = this.m_inputVerifyType2 == 0 || this.m_inputVerifyType2 == 2 ? Long.toString(Double.valueOf(numericValueInfo.getThresholdUpperLimit()).longValue()) : Double.toString(numericValueInfo.getThresholdUpperLimit());
                            this.m_textValue1Warn.setText(lower);
                            this.m_textValue2Warn.setText(upper);
                        }
                    }
                    ++index;
                }
            }
            this.m_comboFailurePriority.setText(PriorityConstant.typeToString(info.getFailurePriority()));
        }
    }

    public ValidateResult createInputData(MonitorInfo info) {
        ArrayList<MonitorNumericValueInfo> valueList = new ArrayList<MonitorNumericValueInfo>();
        String lowerText = null;
        String upperText = null;
        Double lower = null;
        Double upper = null;
        MonitorNumericValueInfo valueInfo = this.getDefaultValueInfo(info, 3);
        lowerText = this.m_textValue1Info.getText();
        upperText = this.m_textValue2Info.getText();
        if (lowerText != null && !"".equals(lowerText.trim())) {
            try {
                lower = Double.valueOf(lowerText);
                if (this.m_value1Info != null && this.m_value2Info != null) {
                    if (lower < this.m_value1Info || lower > this.m_value2Info) {
                        Object[] args = new String[]{this.m_itemName1, this.m_value1Info.toString(), this.m_value2Info.toString()};
                        return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.19", args));
                    }
                } else if (this.m_value1Info != null && this.m_value2Info == null) {
                    if (lower < this.m_value1Info) {
                        Object[] args = new String[]{this.m_itemName1, this.m_value1Info.toString()};
                        return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.20", args));
                    }
                } else if (this.m_value1Info == null && this.m_value2Info != null && lower > this.m_value2Info) {
                    Object[] args = new String[]{this.m_itemName1, this.m_value2Info.toString()};
                    return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.21", args));
                }
                valueInfo.setThresholdLowerLimit(lower);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] args = new String[]{this.m_itemName1};
                return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.3", args));
            }
        } else {
            Object[] args = new String[]{this.m_itemName1};
            return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.3", args));
        }
        if (upperText != null && !"".equals(upperText.trim())) {
            try {
                upper = Double.valueOf(upperText);
                if (this.m_value1Warn != null && this.m_value2Warn != null) {
                    if (upper < this.m_value1Warn || upper > this.m_value2Warn) {
                        Object[] args = new String[]{this.m_itemName2, this.m_value1Warn.toString(), this.m_value2Warn.toString()};
                        return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.19", args));
                    }
                } else if (this.m_value1Warn != null && this.m_value2Warn == null) {
                    if (upper < this.m_value1Warn) {
                        Object[] args = new String[]{this.m_itemName2, this.m_value1Warn.toString()};
                        return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.20", args));
                    }
                } else if (this.m_value1Warn == null && this.m_value2Warn != null && upper > this.m_value2Warn) {
                    Object[] args = new String[]{this.m_itemName2, this.m_value2Warn.toString()};
                    return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.21", args));
                }
                valueInfo.setThresholdUpperLimit(upper);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] args = new String[]{this.m_itemName2};
                return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.4", args));
            }
        } else {
            Object[] args = new String[]{this.m_itemName2};
            return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.4", args));
        }
        if (this.m_rangeFlg && upper < lower) {
            return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.7"));
        }
        valueList.add(valueInfo);
        MonitorNumericValueInfo valueWarn = this.getDefaultValueInfo(info, 2);
        lowerText = this.m_textValue1Warn.getText();
        upperText = this.m_textValue2Warn.getText();
        if (lowerText != null && !"".equals(lowerText.trim())) {
            try {
                lower = Double.valueOf(lowerText);
                if (this.m_value1Info != null && this.m_value2Info != null) {
                    if (lower < this.m_value1Info || lower > this.m_value2Info) {
                        Object[] args = new String[]{this.m_itemName1, this.m_value1Info.toString(), this.m_value2Info.toString()};
                        return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.22", args));
                    }
                } else if (this.m_value1Info != null && this.m_value2Info == null) {
                    if (lower < this.m_value1Info) {
                        Object[] args = new String[]{this.m_itemName1, this.m_value1Info.toString()};
                        return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.23", args));
                    }
                } else if (this.m_value1Info == null && this.m_value2Info != null && lower > this.m_value2Info) {
                    Object[] args = new String[]{this.m_itemName1, this.m_value2Info.toString()};
                    return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.24", args));
                }
                valueWarn.setThresholdLowerLimit(lower);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] args = new String[]{this.m_itemName1};
                return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.5", args));
            }
        } else {
            Object[] args = new String[]{this.m_itemName1};
            return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.5", args));
        }
        if (this.m_textValue2Warn.getText() != null && !"".equals(this.m_textValue2Warn.getText().trim())) {
            try {
                upper = Double.valueOf(upperText);
                if (this.m_value1Warn != null && this.m_value2Warn != null) {
                    if (upper < this.m_value1Warn || upper > this.m_value2Warn) {
                        Object[] args = new String[]{this.m_itemName2, this.m_value1Warn.toString(), this.m_value2Warn.toString()};
                        return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.22", args));
                    }
                } else if (this.m_value1Warn != null && this.m_value2Warn == null) {
                    if (upper < this.m_value1Warn) {
                        Object[] args = new String[]{this.m_itemName2, this.m_value1Warn.toString()};
                        return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.23", args));
                    }
                } else if (this.m_value1Warn == null && this.m_value2Warn != null && upper > this.m_value2Warn) {
                    Object[] args = new String[]{this.m_itemName2, this.m_value2Warn.toString()};
                    return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.24", args));
                }
                valueWarn.setThresholdUpperLimit(upper);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] args = new String[]{this.m_itemName2};
                return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.6", args));
            }
        } else {
            Object[] args = new String[]{this.m_itemName2};
            return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.6", args));
        }
        if (this.m_rangeFlg && upper < lower) {
            return this.setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.8"));
        }
        valueList.add(valueWarn);
        MonitorNumericValueInfo valueCritical = this.getDefaultValueInfo(info, 0);
        valueCritical.setThresholdLowerLimit(0.0);
        valueCritical.setThresholdUpperLimit(0.0);
        valueList.add(valueCritical);
        MonitorNumericValueInfo valueUnknown = this.getDefaultValueInfo(info, 1);
        valueUnknown.setThresholdLowerLimit(0.0);
        valueUnknown.setThresholdUpperLimit(0.0);
        valueList.add(valueUnknown);
        info.setJudgementInfo(valueList);
        info.setFailurePriority(PriorityConstant.stringToType(this.m_comboFailurePriority.getText()));
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.m_textValue1Info.setEnabled(enabled);
        this.m_textValue2Info.setEnabled(enabled);
        this.m_textValue1Warn.setEnabled(enabled);
        this.m_textValue2Warn.setEnabled(enabled);
        this.m_comboFailurePriority.setEnabled(enabled);
    }

    protected Label getLabelPriority(Composite parent, String text, Color background) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(text) + " : ");
        label.setBackground(background);
        return label;
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }

    protected MonitorNumericValueInfo getDefaultValueInfo(MonitorInfo info, int priority) {
        MonitorNumericValueInfo value = new MonitorNumericValueInfo();
        value.setMonitorId(info.getMonitorId());
        value.setMonitorTypeId(info.getMonitorTypeId());
        value.setPriority(priority);
        return value;
    }

    public void setInputRange1(int low, int high) {
        if (this.m_verifyListener1 instanceof PositiveNumberVerifyListener) {
            ((PositiveNumberVerifyListener)this.m_verifyListener1).setLow(low);
            ((PositiveNumberVerifyListener)this.m_verifyListener1).setHigh(high);
        } else if (this.m_verifyListener1 instanceof NumberVerifyListener) {
            ((NumberVerifyListener)this.m_verifyListener1).setLow(low);
            ((NumberVerifyListener)this.m_verifyListener1).setHigh(high);
        } else if (this.m_verifyListener1 instanceof PositiveRealNumberVerifyListener) {
            ((PositiveRealNumberVerifyListener)this.m_verifyListener1).setLow(Double.valueOf(low));
            ((PositiveRealNumberVerifyListener)this.m_verifyListener1).setHigh(Double.valueOf(high));
        } else if (this.m_verifyListener1 instanceof RealNumberVerifyListener) {
            ((RealNumberVerifyListener)this.m_verifyListener1).setLow(Double.valueOf(low));
            ((RealNumberVerifyListener)this.m_verifyListener1).setHigh(Double.valueOf(high));
        }
    }

    public void setInputRange1(double low, double high) {
        if (this.m_verifyListener1 instanceof PositiveRealNumberVerifyListener) {
            ((PositiveRealNumberVerifyListener)this.m_verifyListener1).setLow(low);
            ((PositiveRealNumberVerifyListener)this.m_verifyListener1).setHigh(high);
        } else if (this.m_verifyListener1 instanceof RealNumberVerifyListener) {
            ((RealNumberVerifyListener)this.m_verifyListener1).setLow(low);
            ((RealNumberVerifyListener)this.m_verifyListener1).setHigh(high);
        }
    }

    public void setInputRange2(int low, int high) {
        if (this.m_verifyListener2 instanceof PositiveNumberVerifyListener) {
            ((PositiveNumberVerifyListener)this.m_verifyListener2).setLow(low);
            ((PositiveNumberVerifyListener)this.m_verifyListener2).setHigh(high);
        } else if (this.m_verifyListener2 instanceof NumberVerifyListener) {
            ((NumberVerifyListener)this.m_verifyListener2).setLow(low);
            ((NumberVerifyListener)this.m_verifyListener2).setHigh(high);
        } else if (this.m_verifyListener2 instanceof PositiveRealNumberVerifyListener) {
            ((PositiveRealNumberVerifyListener)this.m_verifyListener2).setLow(Double.valueOf(low));
            ((PositiveRealNumberVerifyListener)this.m_verifyListener2).setHigh(Double.valueOf(high));
        } else if (this.m_verifyListener2 instanceof RealNumberVerifyListener) {
            ((RealNumberVerifyListener)this.m_verifyListener2).setLow(Double.valueOf(low));
            ((RealNumberVerifyListener)this.m_verifyListener2).setHigh(Double.valueOf(high));
        }
    }

    public void setInputRange2(double low, double high) {
        if (this.m_verifyListener2 instanceof PositiveRealNumberVerifyListener) {
            ((PositiveRealNumberVerifyListener)this.m_verifyListener2).setLow(low);
            ((PositiveRealNumberVerifyListener)this.m_verifyListener2).setHigh(high);
        } else if (this.m_verifyListener2 instanceof RealNumberVerifyListener) {
            ((RealNumberVerifyListener)this.m_verifyListener2).setLow(low);
            ((RealNumberVerifyListener)this.m_verifyListener2).setHigh(high);
        }
    }
}

