/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.util;

import com.clustercontrol.util.Messages;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;

public class ReportGenerator {
    protected String m_jasperPath;
    protected int m_outputForm;
    static /* synthetic */ Class class$0;

    public ReportGenerator(String path, int form) {
        this.m_jasperPath = path;
        this.m_outputForm = form;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(String destPath, Map paramMap, Collection collectionData) {
        Thread cur = Thread.currentThread();
        ClassLoader save = cur.getContextClassLoader();
        try {
            cur.setContextClassLoader(JasperCompileManager.class.getClassLoader());
            if (paramMap == null) {
                paramMap = new HashMap();
            }
            paramMap.put("REPORT_RESOURCE_BUNDLE", Messages.getBundle());
            paramMap.put("REPORT_LOCALE", (ResourceBundle)((Object)Locale.getDefault()));
            JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(collectionData);
            JasperPrint print = JasperFillManager.fillReport((String)this.m_jasperPath, paramMap, (JRDataSource)ds);
            if (this.m_outputForm == 0) {
                JasperExportManager.exportReportToPdfFile((JasperPrint)print, (String)destPath);
                return true;
            }
            if (this.m_outputForm != 1) return true;
            JRCsvExporter exporter = new JRCsvExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)destPath);
            exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)System.getProperty("file.encoding"));
            exporter.exportReport();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            cur.setContextClassLoader(save);
            return false;
        }
        finally {
            cur.setContextClassLoader(save);
        }
    }
}

