/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferFileInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferFileInfoUtil;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddLogTransfer {
    protected static Log m_log = LogFactory.getLog(AddLogTransfer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(LogTransferInfo info, String user) throws CreateException, NamingException {
        AccessLock.lock((String)"LOG_TRANSFER");
        try {
            Timestamp now = new Timestamp(new Date().getTime());
            LogTransferInfoLocal logTransfer = LogTransferInfoUtil.getLocalHome().create(info.getTransferId(), info.getDescription(), info.getFacilityId(), info.getValid(), now, now, user, user);
            Collection ct = logTransfer.getLogTransferFileInfo();
            ArrayList fileList = info.getFileInfo();
            ArrayList<LogTransferFileInfoLocal> fileLocalList = new ArrayList<LogTransferFileInfoLocal>();
            LogTransferFileInfo file = null;
            for (int index = 0; index < fileList.size(); ++index) {
                file = (LogTransferFileInfo)fileList.get(index);
                if (file == null) continue;
                LogTransferFileInfoLocal local = LogTransferFileInfoUtil.getLocalHome().create(info.getTransferId(), file.getFilePath(), file.getRunInterval(), file.getExistenceFlg(), file.getValid());
                fileLocalList.add(local);
            }
            if (fileLocalList != null) {
                ct.addAll(fileLocalList);
                logTransfer.setLogTransferFileInfo(ct);
            }
            SendQueue queue = null;
            try {
                queue = new SendQueue("queue/clustercontrol/Logtransfer/LogTransferFileManage");
                queue.put((Serializable)info);
            }
            catch (Exception e) {
                m_log.debug((Object)("add() : \u767b\u9332\u60c5\u5831\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
            }
            finally {
                if (queue != null) {
                    try {
                        queue.terminate();
                    }
                    catch (JMSException e) {
                        m_log.error((Object)("Terminate SendQueue Failed : " + e.getMessage()));
                    }
                }
            }
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{info.getTransferId()};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("add():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{info.getTransferId()};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("add():" + e.getMessage()));
            throw e;
        }
        return true;
    }
}

