/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.dialog;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.snmptrap.action.GetSnmpTrapModifyProperty;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.util.ArrayList;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SnmpTrapModifyDialog
extends CommonDialog {
    protected PropertySheet viewer = null;
    private Shell shell = null;
    private MonitorSnmpTrapOidInfo oidInfo = null;

    public SnmpTrapModifyDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected void customizeDialog(Composite parent) {
        this.shell = this.getShell();
        parent.getShell().setText(Messages.getString((String)"dialog.snmptrap.modify.definition"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        Label tableTitle = new Label(parent, 0);
        tableTitle.setText(String.valueOf(Messages.getString((String)"attribute")) + " : ");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        tableTitle.setLayoutData((Object)gridData);
        TableTree table = new TableTree(parent, 68354);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.viewer = new PropertySheet(table);
        this.viewer.setInput(new GetSnmpTrapModifyProperty().getProperty());
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = this.shell.getDisplay();
        this.shell.setLocation((display.getBounds().width - this.shell.getSize().x) / 2, (display.getBounds().height - this.shell.getSize().y) / 2);
        this.reflectOidInfo();
        this.viewer.expandAll();
    }

    private void reflectOidInfo() {
        Property property = null;
        if (this.oidInfo instanceof MonitorSnmpTrapOidInfo) {
            property = new GetSnmpTrapModifyProperty().getProperty();
            ArrayList propertyList = PropertyUtil.getProperty((Property)property, (String)"mib");
            Property mib = (Property)propertyList.get(0);
            mib.setValue((Object)this.oidInfo.getMib());
            propertyList = PropertyUtil.getProperty((Property)property, (String)"trapName");
            Property trapName = (Property)propertyList.get(0);
            trapName.setValue((Object)this.oidInfo.getTrapName());
            propertyList = PropertyUtil.getProperty((Property)property, (String)"trapOid");
            Property trapOid = (Property)propertyList.get(0);
            trapOid.setValue((Object)this.oidInfo.getTrapOid());
            propertyList = PropertyUtil.getProperty((Property)property, (String)"genericId");
            Property genericId = (Property)propertyList.get(0);
            genericId.setValue((Object)Integer.toString(this.oidInfo.getGenericId()));
            propertyList = PropertyUtil.getProperty((Property)property, (String)"specificId");
            Property specificId = (Property)propertyList.get(0);
            specificId.setValue((Object)Integer.toString(this.oidInfo.getSpecificId()));
            propertyList = PropertyUtil.getProperty((Property)property, (String)"valid");
            Property valid = (Property)propertyList.get(0);
            valid.setValue((Object)new Boolean(YesNoConstant.typeToBoolean((int)this.oidInfo.getValidFlg())));
            propertyList = PropertyUtil.getProperty((Property)property, (String)"priority");
            Property priority = (Property)propertyList.get(0);
            priority.setValue((Object)PriorityConstant.typeToString((int)this.oidInfo.getPriority()));
            propertyList = PropertyUtil.getProperty((Property)property, (String)"logmsg");
            Property logmsg = (Property)propertyList.get(0);
            logmsg.setValue((Object)this.oidInfo.getLogmsg());
            propertyList = PropertyUtil.getProperty((Property)property, (String)"descr");
            Property descr = (Property)propertyList.get(0);
            descr.setValue((Object)this.oidInfo.getDescr());
            this.viewer.setInput(property);
            this.viewer.refresh();
        }
    }

    private ValidateResult createOidInfo() {
        if (this.oidInfo instanceof MonitorSnmpTrapOidInfo) {
            Property property = (Property)this.viewer.getInput();
            ArrayList values = PropertyUtil.getPropertyValue((Property)property, (String)"valid");
            Boolean valid = (Boolean)values.get(0);
            this.oidInfo.setValidFlg(YesNoConstant.booleanToType((boolean)valid));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"priority");
            String priority = (String)values.get(0);
            this.oidInfo.setPriority(PriorityConstant.stringToType((String)priority));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"logmsg");
            String logmsg = (String)values.get(0);
            this.oidInfo.setLogmsg(logmsg);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"descr");
            String descr = (String)values.get(0);
            this.oidInfo.setDescr(descr);
        }
        return null;
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    public void setInputData(MonitorSnmpTrapOidInfo oidInfo) {
        this.oidInfo = oidInfo;
    }

    public MonitorSnmpTrapOidInfo getInputData() {
        return this.oidInfo;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createOidInfo();
        if (result != null) {
            return result;
        }
        return null;
    }
}

