/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view;

import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.JobListComposite;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.composite.action.JobListSelectionChangedListener;
import com.clustercontrol.jobmanagement.composite.action.JobTreeSelectionChangedListener;
import com.clustercontrol.jobmanagement.view.action.CopyJobAction;
import com.clustercontrol.jobmanagement.view.action.PasteJobAction;
import com.clustercontrol.view.CommonViewPart;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;

public class JobListView
extends CommonViewPart {
    public static final String ID = "com.clustercontrol.jobmanagement.view.JobListView";
    protected SashForm m_sash = null;
    protected JobTreeComposite m_jobTree = null;
    protected JobListComposite m_jobList = null;
    protected JobTreeItem m_copyJobTreeItem = null;
    protected boolean m_update = false;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_sash = new SashForm(parent, 256);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_sash.setLayoutData((Object)gridData);
        this.m_jobTree = new JobTreeComposite((Composite)this.m_sash, 0);
        this.m_jobList = new JobListComposite((Composite)this.m_sash, 0);
        this.m_sash.setWeights(new int[]{30, 70});
        this.m_jobTree.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)new JobTreeSelectionChangedListener(this.m_jobTree, this.m_jobList));
        this.m_jobList.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)new JobListSelectionChangedListener(this.m_jobList));
        this.createContextMenu();
        this.update();
        this.m_jobTree.getTreeViewer().expandToLevel(2);
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JobListView.this.fillContextMenu(manager);
            }
        });
        Menu treeMenu = menuManager.createContextMenu((Control)this.m_jobTree.getTree());
        this.m_jobTree.getTree().setMenu(treeMenu);
        Menu listMenu = menuManager.createContextMenu((Control)this.m_jobList.getTable());
        this.m_jobList.getTable().setMenu(listMenu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem createJobUnitAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction");
        ActionContributionItem createJobNetAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction");
        ActionContributionItem createJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.CreateJobAction");
        ActionContributionItem createFileJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction");
        ActionContributionItem deleteJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.DeleteJobAction");
        ActionContributionItem modifyJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.ModifyJobAction");
        ActionContributionItem runJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.RunJobAction");
        CopyJobAction copyJobAction = new CopyJobAction((IViewPart)this);
        manager.add((IAction)copyJobAction);
        PasteJobAction pasteJobAction = new PasteJobAction((IViewPart)this);
        manager.add((IAction)pasteJobAction);
        manager.add((IContributionItem)new Separator());
        manager.add(createJobUnitAction.getAction());
        manager.add(createJobNetAction.getAction());
        manager.add(createJobAction.getAction());
        manager.add(createFileJobAction.getAction());
        manager.add(modifyJobAction.getAction());
        manager.add(deleteJobAction.getAction());
        manager.add(runJobAction.getAction());
        JobTreeItem select = this.getSelectJobTreeItem();
        if (select instanceof JobTreeItem) {
            if (select.getData().getType() == -1) {
                copyJobAction.setEnabled(false);
            } else {
                copyJobAction.setEnabled(true);
            }
            if (this.m_copyJobTreeItem != null && this.m_copyJobTreeItem instanceof JobTreeItem) {
                pasteJobAction.setEnabled(true);
            } else {
                pasteJobAction.setEnabled(false);
            }
        }
    }

    public void update() {
        this.m_jobTree.update();
        JobTreeItem item = this.getJobTreeComposite().getSelectItem();
        this.m_jobList.update(item);
        this.m_update = false;
    }

    public void setEnabledAction(int type, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", selection);
        if (type == -1) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", false);
        } else if (type == 0) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", true);
        } else if (type == 1) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", true);
        } else if (type == 2) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", true);
        } else if (type == 3) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", true);
        } else {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", false);
        }
    }

    public JobTreeComposite getJobTreeComposite() {
        return this.m_jobTree;
    }

    public JobListComposite getJobListComposite() {
        return this.m_jobList;
    }

    public void show() {
        this.m_sash.setMaximizedControl(null);
    }

    public void hide() {
        this.m_sash.setMaximizedControl((Control)this.m_jobList);
    }

    public JobTreeItem getSelectJobTreeItem() {
        JobTreeItem select = null;
        if (this.m_jobTree.getTree().isFocusControl()) {
            select = this.m_jobTree.getSelectItem();
        } else if (this.m_jobList.getTable().isFocusControl()) {
            select = this.m_jobList.getSelectJobTreeItem();
        }
        return select;
    }

    public JobTreeItem getCopyJobTreeItem() {
        return this.m_copyJobTreeItem;
    }

    public void setCopyJobTreeItem(JobTreeItem copy) {
        this.m_copyJobTreeItem = copy;
    }

    public boolean isUpdate() {
        return this.m_update;
    }

    public void setUpdate(boolean update) {
        this.m_update = update;
    }
}

