/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.view;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.composite.ScopeListComposite;
import com.clustercontrol.repository.composite.action.FacilityTreeSelectionChangedListener;
import com.clustercontrol.repository.composite.action.ScopeListSelectionChangedListener;
import com.clustercontrol.view.ScopeListBaseView;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class ScopeListView
extends ScopeListBaseView {
    public static final String ID = "com.clustercontrol.repository.view.ScopeListView";
    protected ScopeListComposite composite = null;

    protected Composite createListContents(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite = new ScopeListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData(gridData);
        this.createContextMenu();
        super.getScopeTreeComposite().getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)new FacilityTreeSelectionChangedListener());
        this.composite.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)new ScopeListSelectionChangedListener(this.composite));
        this.update();
        return this.composite;
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ScopeListView.this.fillContextMenu(manager);
            }
        });
        Menu treeMenu = menuManager.createContextMenu((Control)this.getScopeTreeComposite().getTree());
        this.getScopeTreeComposite().getTree().setMenu(treeMenu);
        Menu listMenu = menuManager.createContextMenu((Control)this.composite.getTable());
        this.composite.getTable().setMenu(listMenu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem scopeAddAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.ScopeAddAction");
        ActionContributionItem scopeModifyAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.ScopeModifyAction");
        ActionContributionItem scopeDeleteAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.ScopeDeleteAction");
        ActionContributionItem nodeAssignAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.NodeAllocateAction");
        ActionContributionItem nodeReleaseAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.NodeReleaseAction");
        manager.add(scopeAddAction.getAction());
        manager.add(scopeModifyAction.getAction());
        manager.add(scopeDeleteAction.getAction());
        manager.add(nodeAssignAction.getAction());
        manager.add(nodeReleaseAction.getAction());
    }

    protected void doSelectTreeItem(FacilityTreeItem item) {
        this.composite.update(item);
    }

    public void update() {
        FacilityTreeItem item = this.getScopeTreeComposite().getSelectItem();
        this.composite.update(item);
    }

    public Object getAdapter(Class cls) {
        if (cls.isInstance((Object)this)) {
            return this;
        }
        return super.getAdapter(cls);
    }

    public void setEnabledAction(boolean builtin, int type, ISelection selection) {
        if (builtin) {
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeAddAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeModifyAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeDeleteAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeAllocateAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeReleaseAction", false);
        } else if (this.getScopeTreeComposite().getTree().isFocusControl() || this.composite.getTable().isFocusControl()) {
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeAddAction", selection);
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeModifyAction", selection);
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeDeleteAction", selection);
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeAllocateAction", selection);
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeReleaseAction", selection);
            if (type == 2) {
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeAddAction", true);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeModifyAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeDeleteAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.NodeAllocateAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.NodeReleaseAction", false);
            } else if (type == 0) {
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeAddAction", true);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeModifyAction", true);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeDeleteAction", true);
                super.setEnabledAction("com.clustercontrol.repository.view.action.NodeAllocateAction", true);
                super.setEnabledAction("com.clustercontrol.repository.view.action.NodeReleaseAction", true);
            } else if (type == 1) {
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeAddAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeModifyAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeDeleteAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.NodeAllocateAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.NodeReleaseAction", false);
            }
        }
    }
}

