/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.MultiplexingOutputStream;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.StoppableThread;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class Protocol {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$Protocol == null ? (class$org$jboss$remoting$transport$multiplex$Protocol = Protocol.class$("org.jboss.remoting.transport.multiplex.Protocol")) : class$org$jboss$remoting$transport$multiplex$Protocol);
    public static final int MP_CONNECT = 0;
    public static final int MP_CONNECTED = 1;
    public static final int MP_INPUT_SHUTDOWN = 2;
    public static final int MP_OUTPUT_SHUTDOWN = 3;
    public static final int MP_DISCONNECT = 4;
    public static final int MP_SERVER_SOCKET_QUERY = 5;
    public static final int MP_REGISTER_REMOTE_SERVER = 6;
    public static final int MP_UNREGISTER_REMOTE_SERVER = 7;
    public static final int MP_SHUTDOWN_MANAGER = 8;
    public static final int MP_ERROR = 9;
    public static final int MP_TRUE = 10;
    public static final int MP_FALSE = 11;
    private MultiplexingManager manager;
    private DataInputStream inputStreamForConnect;
    private DataOutputStream outputStreamForConnect;
    private DataInputStream inputStreamForAcceptConnect;
    private DataOutputStream outputStreamForAnswerConnect;
    private DataInputStream backChannelInputStream;
    private DataOutputStream backChannelOutputStream;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$Protocol;

    public Protocol(MultiplexingManager manager) throws IOException {
        this.manager = manager;
        Socket socket = manager.getSocket();
        this.inputStreamForConnect = new DataInputStream(manager.getAnInputStream(SocketId.PROTOCOL_SOCKET_ID, null));
        this.outputStreamForAnswerConnect = new DataOutputStream(new MultiplexingOutputStream(manager, SocketId.PROTOCOL_SOCKET_ID));
        if (MultiplexingManager.isOnClient()) {
            this.outputStreamForConnect = new DataOutputStream(socket.getOutputStream());
            this.inputStreamForAcceptConnect = new DataInputStream(manager.getAnInputStream(SocketId.SERVER_SOCKET_ID, null));
        } else {
            this.outputStreamForConnect = new DataOutputStream(new MultiplexingOutputStream(manager, SocketId.SERVER_SOCKET_ID));
            this.inputStreamForAcceptConnect = new DataInputStream(socket.getInputStream());
        }
        this.backChannelOutputStream = new DataOutputStream(new MultiplexingOutputStream(manager, SocketId.BACKCHANNEL_SOCKET_ID));
        this.backChannelInputStream = new DataInputStream(manager.getAnInputStream(SocketId.BACKCHANNEL_SOCKET_ID, null));
    }

    public SocketId connect(SocketId socketId) throws IOException {
        this.outputStreamForConnect.write(0);
        log.info("Protocol.connect(): wrote: CONNECT (0)");
        this.outputStreamForConnect.writeInt(socketId.getPort());
        log.info("Protocol.connect(): wrote port: " + socketId.getPort());
        int messageType = this.inputStreamForConnect.read();
        log.info("Protocol.connect(): read message type: " + messageType);
        switch (messageType) {
            case 1: {
                int remotePort = this.inputStreamForConnect.readInt();
                log.info("Protocol.connect(): read port: " + remotePort);
                return new SocketId(remotePort);
            }
        }
        log.error("Protocol.connect(): expecting a CONNECTED message: received: " + messageType);
        throw new IOException("Protocol.connect(): expecting a CONNECTED message: received: " + messageType);
    }

    public static SocketId acceptConnect(DataInputStream is) throws IOException {
        int messageType = is.read();
        log.info("Protocol.acceptConnect(): read message type: " + messageType);
        switch (messageType) {
            case 0: {
                int remotePort = is.readInt();
                log.info("Protocol.acceptConnect(): read port: " + remotePort);
                return new SocketId(remotePort);
            }
        }
        log.error("Protocol.acceptConnect: expecting a CONNECT message: received: " + messageType);
        throw new IOException("Protocol.acceptConnect: expecting a CONNECT message: received: " + messageType);
    }

    public SocketId acceptConnect() throws IOException {
        log.debug("acceptConnect(): available bytes: " + this.inputStreamForAcceptConnect.available());
        int messageType = this.inputStreamForAcceptConnect.read();
        log.info("Protocol.acceptConnect(): read message type: " + messageType);
        switch (messageType) {
            case 0: {
                int remotePort = this.inputStreamForAcceptConnect.readInt();
                log.info("Protocol.acceptConnect(): read port: " + remotePort);
                return new SocketId(remotePort);
            }
        }
        log.error("Protocol.acceptConnect: expecting a CONNECT message: received: " + messageType);
        throw new IOException("Protocol.acceptConnect: expecting a CONNECT message: received: " + messageType);
    }

    public void answerConnect(int port) throws IOException {
        this.outputStreamForAnswerConnect.write(1);
        log.info("Protocol.answerConnect(): wrote: CONNECTED (1)");
        this.outputStreamForAnswerConnect.writeInt(port);
        log.info("Protocol.answerConnect(): wrote port: " + port);
    }

    public void notifyInputShutdown(SocketId socketId) {
        int port = socketId.getPort();
        try {
            this.backChannelOutputStream.write(2);
            this.backChannelOutputStream.writeInt(port);
            log.info("Protocol.disconnect(): wrote: INPUT_SHUTDOWN (2) for port: " + port);
        }
        catch (IOException ignored) {
            log.error("Protocol.disconnect(): unable to send MP_INPUT_SHUTDOWN message to port: " + port);
        }
    }

    public void notifyOutputShutdown(SocketId socketId) {
        int port = socketId.getPort();
        try {
            this.backChannelOutputStream.write(3);
            this.backChannelOutputStream.writeInt(port);
            log.info("Protocol.disconnect(): wrote: OUTPUT_SHUTDOWN (3) for port: " + port);
        }
        catch (IOException ignored) {
            log.error("Protocol.disconnect(): unable to send MP_OUTPUT_SHUTDOWN message to port: " + port);
        }
    }

    public boolean isRemoteServerSocketRegistered() throws IOException {
        this.backChannelOutputStream.write(5);
        int b = this.inputStreamForConnect.read();
        return b == 10;
    }

    public void disconnect(SocketId socketId) {
        int port = socketId.getPort();
        try {
            this.backChannelOutputStream.write(4);
            this.backChannelOutputStream.writeInt(port);
            log.info("Protocol.disconnect(): wrote: DISCONNECT (1) for port: " + port);
        }
        catch (IOException ignored) {
            log.error("Protocol.disconnect(): unable to send DISCONNECT message to port: " + port);
        }
    }

    public void registerRemoteServerSocket() {
        try {
            this.backChannelOutputStream.write(6);
            log.info("Protocol.disconnect(): wrote: REGISTER_REMOTE_SERVER (6)");
        }
        catch (IOException ignored) {
            log.error("Protocol.notifyOfServerSocketShutdown(): unable to send REGISTER_REMOTE_SERVER");
        }
    }

    public void unregisterRemoteServerSocket() {
        try {
            this.backChannelOutputStream.write(7);
            log.info("Protocol.disconnect(): wrote: UNREGISTER_REMOTE_SERVER (7)");
        }
        catch (IOException ignored) {
            log.error("Protocol.notifyOfServerSocketShutdown(): unable to send UNREGISTER_REMOTE_SERVER");
        }
    }

    public void notifyOfManagerShutdown() {
        try {
            this.backChannelOutputStream.write(8);
            log.info("Protocol.disconnect(): wrote: SHUTDOWN_MANAGER (7)");
        }
        catch (IOException ignored) {
            log.error("Protocol.notifyOfServerSocketShutdown(): unable to send SHUTDOWN_MANAGER");
        }
    }

    public BackChannelThread getBackChannelThread() {
        return new BackChannelThread(this.manager, this.backChannelInputStream);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class BackChannelThread
    extends StoppableThread {
        private MultiplexingManager manager;
        private DataInputStream is;

        public BackChannelThread(MultiplexingManager manager, DataInputStream is) {
            this.manager = manager;
            this.is = is;
        }

        public void shutdown() {
            log.debug("back channel thread: beginning shut down");
            super.shutdown();
            this.interrupt();
        }

        protected void doInit() {
            log.info("back channel thread starting");
        }

        protected void doRun() {
            try {
                int messageType = this.is.read();
                log.info("back channel thread: read message type: " + messageType);
                switch (messageType) {
                    case 5: {
                        boolean answer = this.manager.isServerSocketRegistered();
                        Protocol.this.outputStreamForAnswerConnect.write(answer ? 10 : 11);
                        break;
                    }
                    case 2: {
                        int port = this.is.readInt();
                        log.info("back channel thread: read INPUT_SHUTDOWN for port: " + port);
                        VirtualSocket socket = this.manager.getSocketByLocalPort(new SocketId(port));
                        if (socket == null) {
                            log.info("back channel thread (INPUT_SHUTDOWN): unable to retrieve socket at port: " + port);
                            break;
                        }
                        socket.handleRemoteInputShutDown();
                        break;
                    }
                    case 3: {
                        int port = this.is.readInt();
                        log.info("back channel thread: read OUTPUT_SHUTDOWN for port: " + port);
                        VirtualSocket socket = this.manager.getSocketByLocalPort(new SocketId(port));
                        if (socket == null) {
                            log.info("back channel thread (OUTPUT_SHUTDOWN): unable to retrieve socket at port: " + port);
                            break;
                        }
                        socket.handleRemoteOutputShutDown();
                        break;
                    }
                    case 4: {
                        int port = this.is.readInt();
                        log.info("back channel thread: read DISCONNECT for port: " + port);
                        VirtualSocket socket = this.manager.getSocketByLocalPort(new SocketId(port));
                        if (socket == null) {
                            log.info("back channel thread (DISCONNECT): unable to retrieve socket at port: " + port);
                            break;
                        }
                        socket.handleRemoteDisconnect();
                        break;
                    }
                    case 6: {
                        log.info("back channel thread: read REGISTER_REMOTE_SERVER");
                        this.manager.registerRemoteServerSocket();
                        break;
                    }
                    case 7: {
                        log.info("back channel thread: read UNREGISTER_REMOTE_SERVER");
                        this.manager.unRegisterRemoteServerSocket();
                        break;
                    }
                    case 8: {
                        log.info("back channel thread: read SHUTDOWN_MANAGER");
                        this.manager.shutdown();
                        break;
                    }
                    default: {
                        log.error("unexpected message type in back channel thread: " + messageType);
                        break;
                    }
                }
            }
            catch (InterruptedIOException e) {
                if (this.isRunning()) {
                    log.error("back channel thread: i/o interruption");
                } else {
                    log.debug("back channel thread: i/o interruption");
                }
            }
            catch (IOException e) {
                if (this.isRunning()) {
                    log.error("back channel thread: i/o error");
                    this.running = false;
                }
                log.debug("back channel thread: i/o error");
            }
        }

        protected void doShutDown() {
            log.info("back channel thread shutting down");
        }
    }
}

