/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.operations.OperationsManager;

public class RestartDialog
extends MessageDialog {
    private static final int CONTINUE = 2;
    private static final String[] yesNo = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
    private static final String[] yesNoApply = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, UpdateUIMessages.ApplyChanges};
    private int buttonId = 0;

    public RestartDialog(Shell parent, String title, String message, boolean restartNeeded) {
        super(parent, title, null, message, 3, restartNeeded ? yesNo : yesNoApply, 0);
    }

    public static boolean openQuestion(Shell parent, boolean restartIsReallyNeeded) {
        String title = UpdateUIMessages.RestartTitle;
        String message = restartIsReallyNeeded ? UpdateUIMessages.RestartMessage : UpdateUIMessages.OptionalRestartMessage;
        RestartDialog dialog = new RestartDialog(parent, title, message, restartIsReallyNeeded);
        int button = dialog.open();
        if (button == 2) {
            OperationsManager.applyChangesNow();
        }
        return button == 0;
    }

    protected void buttonPressed(int id) {
        if (id == 2) {
            this.buttonId = 2;
        }
        super.buttonPressed(id);
    }

    public int getResult() {
        return this.buttonId;
    }
}

