/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.ejb.session;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.commons.ejb.UsedFacilityException;
import com.clustercontrol.commons.ejb.session.CheckFacility;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoUtil;
import com.clustercontrol.snmptrap.factory.AddMonitorInfo;
import com.clustercontrol.snmptrap.factory.DeleteMonitorInfo;
import com.clustercontrol.snmptrap.factory.ModifyMonitorInfo;
import com.clustercontrol.snmptrap.factory.SelectMonitorInfo;
import com.clustercontrol.util.Messages;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MonitorSnmpTrapControllerBean
implements SessionBean,
CheckFacility {
    protected static Log m_log = LogFactory.getLog(MonitorSnmpTrapControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public boolean addMonitor(MonitorSnmpTrapInfo info) throws InvalidTransactionException, CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, NamingException, FinderException {
        Principal pri = this.m_context.getCallerPrincipal();
        AddMonitorInfo add = new AddMonitorInfo();
        return add.add(info, pri.getName());
    }

    public boolean modifyMonitor(MonitorSnmpTrapInfo info) throws InvalidTransactionException, CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, NamingException, FinderException, RemoveException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyMonitorInfo modify = new ModifyMonitorInfo();
        return modify.modify(info, pri.getName());
    }

    public boolean deleteMonitor(String monitorId) throws InvalidTransactionException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, NamingException, FinderException, RemoveException {
        DeleteMonitorInfo delete = new DeleteMonitorInfo();
        return delete.delete(monitorId);
    }

    public ArrayList<String> getMibList() throws FinderException, NamingException {
        SelectMonitorInfo select = new SelectMonitorInfo();
        ArrayList<String> list = select.getMibList();
        return list;
    }

    public ArrayList<SnmpTrapMasterInfo> getMasterList(String mib) throws FinderException, NamingException {
        SelectMonitorInfo select = new SelectMonitorInfo();
        ArrayList<SnmpTrapMasterInfo> list = select.getMasterList(mib);
        return list;
    }

    public MonitorSnmpTrapInfo getMonitorInfo(String monitorId) throws CreateException, FinderException, NamingException {
        SelectMonitorInfo select = new SelectMonitorInfo();
        MonitorSnmpTrapInfo info = select.getMonitorInfo(monitorId);
        return info;
    }

    public ArrayList getMonitorList() throws CreateException, FinderException, NamingException {
        SelectMonitorInfo select = new SelectMonitorInfo();
        ArrayList list = select.getMonitorList();
        return list;
    }

    public ArrayList getMonitorListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"monitor.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 200, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"snmptrap.records", (Locale)locale), -1, 100, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"scope", (Locale)locale), 2, 200, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"valid", (Locale)locale) + "/" + Messages.getString((String)"invalid", (Locale)locale), 4, 80, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 130, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 130, 16384));
        return tableDefine;
    }

    public void isUseFacilityId(String facilityId) throws UsedFacilityException {
        try {
            Collection ct = SnmpTrapInfoUtil.getLocalHome().findByFacilityId(facilityId);
            if (ct != null && ct.size() > 0) {
                throw new UsedFacilityException(18);
            }
        }
        catch (FinderException e) {
            m_log.debug((Object)("isUseFacilityId() : " + e.getMessage()));
        }
        catch (NamingException e) {
            m_log.debug((Object)("isUseFacilityId() : " + e.getMessage()));
        }
    }
}

