/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmp.ejb.session;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.snmp.factory.AddMonitorSnmp;
import com.clustercontrol.snmp.factory.AddMonitorSnmpString;
import com.clustercontrol.snmp.factory.DeleteMonitorSnmp;
import com.clustercontrol.snmp.factory.DeleteMonitorSnmpString;
import com.clustercontrol.snmp.factory.ModifyMonitorSnmp;
import com.clustercontrol.snmp.factory.ModifyMonitorSnmpString;
import com.clustercontrol.snmp.factory.SelectMonitorSnmp;
import com.clustercontrol.snmp.factory.SelectMonitorSnmpString;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class MonitorSnmpControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(MonitorSnmpControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public boolean addSnmp(MonitorInfo info) throws CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        Object snmp = null;
        if (info.getMonitorType() == 1) {
            snmp = new AddMonitorSnmp();
        } else if (info.getMonitorType() == 2) {
            snmp = new AddMonitorSnmpString();
        } else {
            return false;
        }
        return snmp.add(info, pri.getName());
    }

    public boolean modifySnmp(MonitorInfo info) throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        Object snmp = null;
        if (info.getMonitorType() == 1) {
            snmp = new ModifyMonitorSnmp();
        } else if (info.getMonitorType() == 2) {
            snmp = new ModifyMonitorSnmpString();
        } else {
            return false;
        }
        return snmp.modify(info, pri.getName());
    }

    public boolean deleteSnmp(String monitorId, int monitorType) throws FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        Object snmp = null;
        if (monitorType == 1) {
            snmp = new DeleteMonitorSnmp();
        } else if (monitorType == 2) {
            snmp = new DeleteMonitorSnmpString();
        } else {
            return false;
        }
        return snmp.delete("SNMP", monitorId);
    }

    public MonitorInfo getSnmp(String monitorId, int monitorType) throws CreateException, FinderException, SchedulerException, NamingException {
        Object snmp = null;
        if (monitorType == 1) {
            snmp = new SelectMonitorSnmp();
        } else if (monitorType == 2) {
            snmp = new SelectMonitorSnmpString();
        } else {
            return null;
        }
        MonitorInfo info = snmp.getMonitor("SNMP", monitorId);
        return info;
    }

    public ArrayList getSnmpList() throws CreateException, FinderException, SchedulerException, NamingException {
        SelectMonitorSnmp snmp = new SelectMonitorSnmp();
        ArrayList list = snmp.getMonitorList("SNMP");
        return list;
    }

    public ArrayList getSnmpListTableDefine(Locale locale) {
        SelectMonitorSnmp snmp = new SelectMonitorSnmp();
        ArrayList tableDefine = snmp.getMonitorListTableDefine(locale);
        return tableDefine;
    }

    public ArrayList getSnmpStringValueListTableDefine(Locale locale) {
        SelectMonitorSnmpString snmp = new SelectMonitorSnmpString();
        ArrayList tableDefine = snmp.getStringValueListTableDefine(locale);
        return tableDefine;
    }
}

